/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Location;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.SymbolKind;

public class SymbolInformation
extends JSONBase {
    SymbolInformation(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public SymbolInformation setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public SymbolKind getKind() {
        return SymbolKind.get(this.jsonData.getInt("kind"));
    }

    public SymbolInformation setKind(SymbolKind kind) {
        this.jsonData.put("kind", kind.getIntValue());
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDeprecated() {
        return this.jsonData.has("deprecated") ? Boolean.valueOf(this.jsonData.getBoolean("deprecated")) : null;
    }

    public SymbolInformation setDeprecated(Boolean deprecated) {
        this.jsonData.putOpt("deprecated", deprecated);
        return this;
    }

    public Location getLocation() {
        return new Location(this.jsonData.getJSONObject("location"));
    }

    public SymbolInformation setLocation(Location location) {
        this.jsonData.put("location", location.jsonData);
        return this;
    }

    public String getContainerName() {
        return this.jsonData.optString("containerName", null);
    }

    public SymbolInformation setContainerName(String containerName) {
        this.jsonData.putOpt("containerName", containerName);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolInformation other = (SymbolInformation)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (this.getKind() != other.getKind()) {
            return false;
        }
        if (!Objects.equals(this.getDeprecated(), other.getDeprecated())) {
            return false;
        }
        if (!Objects.equals(this.getLocation(), other.getLocation())) {
            return false;
        }
        return Objects.equals(this.getContainerName(), other.getContainerName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getName());
        hash = 97 * hash + Objects.hashCode((Object)this.getKind());
        if (this.getDeprecated() != null) {
            hash = 97 * hash + Boolean.hashCode(this.getDeprecated());
        }
        hash = 97 * hash + Objects.hashCode(this.getLocation());
        if (this.getContainerName() != null) {
            hash = 97 * hash + Objects.hashCode(this.getContainerName());
        }
        return hash;
    }

    public static SymbolInformation create(String name, SymbolKind kind, Range range, String uri, String containerName) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.put("kind", kind.getIntValue());
        json.put("location", Location.create((String)uri, (Range)range).jsonData);
        json.putOpt("containerName", containerName);
        return new SymbolInformation(json);
    }
}

