/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressOptions;

public class SignatureHelpOptions
extends WorkDoneProgressOptions {
    SignatureHelpOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<String> getTriggerCharacters() {
        JSONArray json = this.jsonData.optJSONArray("triggerCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public SignatureHelpOptions setTriggerCharacters(List<String> triggerCharacters) {
        if (triggerCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : triggerCharacters) {
                json.put(string);
            }
            this.jsonData.put("triggerCharacters", json);
        }
        return this;
    }

    public List<String> getRetriggerCharacters() {
        JSONArray json = this.jsonData.optJSONArray("retriggerCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public SignatureHelpOptions setRetriggerCharacters(List<String> retriggerCharacters) {
        if (retriggerCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : retriggerCharacters) {
                json.put(string);
            }
            this.jsonData.put("retriggerCharacters", json);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureHelpOptions other = (SignatureHelpOptions)obj;
        if (!Objects.equals(this.getTriggerCharacters(), other.getTriggerCharacters())) {
            return false;
        }
        if (!Objects.equals(this.getRetriggerCharacters(), other.getRetriggerCharacters())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getTriggerCharacters() != null) {
            hash = 17 * hash + Objects.hashCode(this.getTriggerCharacters());
        }
        if (this.getRetriggerCharacters() != null) {
            hash = 17 * hash + Objects.hashCode(this.getRetriggerCharacters());
        }
        if (this.getWorkDoneProgress() != null) {
            hash = 17 * hash + Boolean.hashCode(this.getWorkDoneProgress());
        }
        return hash;
    }

    public static SignatureHelpOptions create() {
        JSONObject json = new JSONObject();
        return new SignatureHelpOptions(json);
    }
}

