/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class SelectionRange
extends JSONBase {
    SelectionRange(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public SelectionRange setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public SelectionRange getParent() {
        return this.jsonData.has("parent") ? new SelectionRange(this.jsonData.optJSONObject("parent")) : null;
    }

    public SelectionRange setParent(SelectionRange parent) {
        this.jsonData.putOpt("parent", parent != null ? parent.jsonData : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionRange other = (SelectionRange)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        return Objects.equals(this.getParent(), other.getParent());
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.getRange());
        if (this.getParent() != null) {
            hash = 43 * hash + Objects.hashCode(this.getParent());
        }
        return hash;
    }

    public static SelectionRange create(Range range, SelectionRange parent) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.putOpt("parent", parent != null ? parent.jsonData : null);
        return new SelectionRange(json);
    }
}

