/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class Registration
extends JSONBase {
    Registration(JSONObject jsonData) {
        super(jsonData);
    }

    public String getId() {
        return this.jsonData.getString("id");
    }

    public Registration setId(String id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getMethod() {
        return this.jsonData.getString("method");
    }

    public Registration setMethod(String method) {
        this.jsonData.put("method", method);
        return this;
    }

    public Object getRegisterOptions() {
        return this.jsonData.opt("registerOptions");
    }

    public Registration setRegisterOptions(Object registerOptions) {
        this.jsonData.putOpt("registerOptions", registerOptions);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Registration other = (Registration)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(this.getMethod(), other.getMethod())) {
            return false;
        }
        return Objects.equals(this.getRegisterOptions(), other.getRegisterOptions());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.getId());
        hash = 59 * hash + Objects.hashCode(this.getMethod());
        if (this.getRegisterOptions() != null) {
            hash = 59 * hash + Objects.hashCode(this.getRegisterOptions());
        }
        return hash;
    }

    public static Registration create(String id, String method) {
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("method", method);
        return new Registration(json);
    }
}

