/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressParams;

public class ExecuteCommandParams
extends WorkDoneProgressParams {
    ExecuteCommandParams(JSONObject jsonData) {
        super(jsonData);
    }

    public String getCommand() {
        return this.jsonData.getString("command");
    }

    public ExecuteCommandParams setCommand(String command) {
        this.jsonData.put("command", command);
        return this;
    }

    public List<Object> getArguments() {
        JSONArray json = this.jsonData.optJSONArray("arguments");
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.get(i));
        }
        return Collections.unmodifiableList(list);
    }

    public ExecuteCommandParams setArguments(List<Object> arguments) {
        if (arguments != null) {
            JSONArray json = new JSONArray();
            for (Object object : arguments) {
                json.put(object);
            }
            this.jsonData.put("arguments", json);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecuteCommandParams other = (ExecuteCommandParams)obj;
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getArguments(), other.getArguments())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.getCommand());
        if (this.getArguments() != null) {
            hash = 79 * hash + Objects.hashCode(this.getArguments());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 79 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        return hash;
    }

    public static ExecuteCommandParams create(String command) {
        JSONObject json = new JSONObject();
        json.put("command", command);
        return new ExecuteCommandParams(json);
    }
}

