/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.FormattingOptions;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;

public class DocumentOnTypeFormattingParams
extends JSONBase {
    DocumentOnTypeFormattingParams(JSONObject jsonData) {
        super(jsonData);
    }

    public TextDocumentIdentifier getTextDocument() {
        return new TextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public DocumentOnTypeFormattingParams setTextDocument(TextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public Position getPosition() {
        return new Position(this.jsonData.getJSONObject("position"));
    }

    public DocumentOnTypeFormattingParams setPosition(Position position) {
        this.jsonData.put("position", position.jsonData);
        return this;
    }

    public String getCh() {
        return this.jsonData.getString("ch");
    }

    public DocumentOnTypeFormattingParams setCh(String ch) {
        this.jsonData.put("ch", ch);
        return this;
    }

    public FormattingOptions getOptions() {
        return new FormattingOptions(this.jsonData.getJSONObject("options"));
    }

    public DocumentOnTypeFormattingParams setOptions(FormattingOptions options) {
        this.jsonData.put("options", options.jsonData);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentOnTypeFormattingParams other = (DocumentOnTypeFormattingParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getPosition(), other.getPosition())) {
            return false;
        }
        if (!Objects.equals(this.getCh(), other.getCh())) {
            return false;
        }
        return Objects.equals(this.getOptions(), other.getOptions());
    }

    public int hashCode() {
        int hash = 2;
        hash = 79 * hash + Objects.hashCode(this.getTextDocument());
        hash = 79 * hash + Objects.hashCode(this.getPosition());
        hash = 79 * hash + Objects.hashCode(this.getCh());
        hash = 79 * hash + Objects.hashCode(this.getOptions());
        return hash;
    }

    public static DocumentOnTypeFormattingParams create(TextDocumentIdentifier textDocument, Position position, String ch, FormattingOptions options) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        json.put("ch", ch);
        json.put("options", options.jsonData);
        return new DocumentOnTypeFormattingParams(json);
    }
}

