/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class DocumentLink
extends JSONBase {
    DocumentLink(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public DocumentLink setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public String getTarget() {
        return this.jsonData.optString("target", null);
    }

    public DocumentLink setTarget(String target) {
        this.jsonData.putOpt("target", target);
        return this;
    }

    public String getTooltip() {
        return this.jsonData.optString("tooltip", null);
    }

    public DocumentLink setTooltip(String tooltip) {
        this.jsonData.putOpt("tooltip", tooltip);
        return this;
    }

    public Object getData() {
        return this.jsonData.opt("data");
    }

    public DocumentLink setData(Object data) {
        this.jsonData.putOpt("data", data);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentLink other = (DocumentLink)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        if (!Objects.equals(this.getTarget(), other.getTarget())) {
            return false;
        }
        if (!Objects.equals(this.getTooltip(), other.getTooltip())) {
            return false;
        }
        return Objects.equals(this.getData(), other.getData());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.getRange());
        if (this.getTarget() != null) {
            hash = 37 * hash + Objects.hashCode(this.getTarget());
        }
        if (this.getTooltip() != null) {
            hash = 37 * hash + Objects.hashCode(this.getTooltip());
        }
        if (this.getData() != null) {
            hash = 37 * hash + Objects.hashCode(this.getData());
        }
        return hash;
    }

    public static DocumentLink create(Range range, String target, Object data) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.putOpt("target", target);
        json.putOpt("data", data);
        return new DocumentLink(json);
    }
}

