/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.DocumentHighlightKind;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Range;

public class DocumentHighlight
extends JSONBase {
    DocumentHighlight(JSONObject jsonData) {
        super(jsonData);
    }

    public Range getRange() {
        return new Range(this.jsonData.getJSONObject("range"));
    }

    public DocumentHighlight setRange(Range range) {
        this.jsonData.put("range", range.jsonData);
        return this;
    }

    public DocumentHighlightKind getKind() {
        return DocumentHighlightKind.get(this.jsonData.has("kind") ? Integer.valueOf(this.jsonData.getInt("kind")) : null);
    }

    public DocumentHighlight setKind(DocumentHighlightKind kind) {
        this.jsonData.putOpt("kind", kind != null ? Integer.valueOf(kind.getIntValue()) : null);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentHighlight other = (DocumentHighlight)obj;
        if (!Objects.equals(this.getRange(), other.getRange())) {
            return false;
        }
        return this.getKind() == other.getKind();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.getRange());
        if (this.getKind() != null) {
            hash = 47 * hash + Objects.hashCode((Object)this.getKind());
        }
        return hash;
    }

    public static DocumentHighlight create(Range range, DocumentHighlightKind kind) {
        JSONObject json = new JSONObject();
        json.put("range", range.jsonData);
        json.putOpt("kind", kind != null ? Integer.valueOf(kind.getIntValue()) : null);
        return new DocumentHighlight(json);
    }
}

