/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.VersionedTextDocumentIdentifier;

public class DidSaveTextDocumentParams
extends JSONBase {
    DidSaveTextDocumentParams(JSONObject jsonData) {
        super(jsonData);
    }

    public VersionedTextDocumentIdentifier getTextDocument() {
        return new VersionedTextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public DidSaveTextDocumentParams setTextDocument(VersionedTextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public String getText() {
        return this.jsonData.optString("text", null);
    }

    public DidSaveTextDocumentParams setText(String text) {
        this.jsonData.putOpt("text", text);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DidSaveTextDocumentParams other = (DidSaveTextDocumentParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getText(), other.getText());
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.getTextDocument());
        if (this.getText() != null) {
            hash = 79 * hash + Objects.hashCode(this.getText());
        }
        return hash;
    }

    public static DidSaveTextDocumentParams create(VersionedTextDocumentIdentifier textDocument) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        return new DidSaveTextDocumentParams(json);
    }
}

