/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.TextDocumentContentChangeEvent;
import org.graalvm.tools.lsp.server.types.VersionedTextDocumentIdentifier;

public class DidChangeTextDocumentParams
extends JSONBase {
    DidChangeTextDocumentParams(JSONObject jsonData) {
        super(jsonData);
    }

    public VersionedTextDocumentIdentifier getTextDocument() {
        return new VersionedTextDocumentIdentifier(this.jsonData.getJSONObject("textDocument"));
    }

    public DidChangeTextDocumentParams setTextDocument(VersionedTextDocumentIdentifier textDocument) {
        this.jsonData.put("textDocument", textDocument.jsonData);
        return this;
    }

    public List<TextDocumentContentChangeEvent> getContentChanges() {
        JSONArray json = this.jsonData.getJSONArray("contentChanges");
        ArrayList<TextDocumentContentChangeEvent> list = new ArrayList<TextDocumentContentChangeEvent>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new TextDocumentContentChangeEvent(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public DidChangeTextDocumentParams setContentChanges(List<TextDocumentContentChangeEvent> contentChanges) {
        JSONArray json = new JSONArray();
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : contentChanges) {
            json.put(textDocumentContentChangeEvent.jsonData);
        }
        this.jsonData.put("contentChanges", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DidChangeTextDocumentParams other = (DidChangeTextDocumentParams)obj;
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getContentChanges(), other.getContentChanges());
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.getTextDocument());
        hash = 53 * hash + Objects.hashCode(this.getContentChanges());
        return hash;
    }

    public static DidChangeTextDocumentParams create(VersionedTextDocumentIdentifier textDocument, List<TextDocumentContentChangeEvent> contentChanges) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        JSONArray contentChangesJsonArr = new JSONArray();
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : contentChanges) {
            contentChangesJsonArr.put(textDocumentContentChangeEvent.jsonData);
        }
        json.put("contentChanges", contentChangesJsonArr);
        return new DidChangeTextDocumentParams(json);
    }
}

