/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CompletionContext;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;

public class CompletionParams
extends TextDocumentPositionParams {
    CompletionParams(JSONObject jsonData) {
        super(jsonData);
    }

    public CompletionContext getContext() {
        return this.jsonData.has("context") ? new CompletionContext(this.jsonData.optJSONObject("context")) : null;
    }

    public CompletionParams setContext(CompletionContext context) {
        this.jsonData.putOpt("context", context != null ? context.jsonData : null);
        return this;
    }

    public Object getWorkDoneToken() {
        return this.jsonData.opt("workDoneToken");
    }

    public CompletionParams setWorkDoneToken(Object workDoneToken) {
        this.jsonData.putOpt("workDoneToken", workDoneToken);
        return this;
    }

    public Object getPartialResultToken() {
        return this.jsonData.opt("partialResultToken");
    }

    public CompletionParams setPartialResultToken(Object partialResultToken) {
        this.jsonData.putOpt("partialResultToken", partialResultToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionParams other = (CompletionParams)obj;
        if (!Objects.equals(this.getContext(), other.getContext())) {
            return false;
        }
        if (!Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken())) {
            return false;
        }
        if (!Objects.equals(this.getPartialResultToken(), other.getPartialResultToken())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getPosition(), other.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getContext() != null) {
            hash = 29 * hash + Objects.hashCode(this.getContext());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 29 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        if (this.getPartialResultToken() != null) {
            hash = 29 * hash + Objects.hashCode(this.getPartialResultToken());
        }
        hash = 29 * hash + Objects.hashCode(this.getTextDocument());
        hash = 29 * hash + Objects.hashCode(this.getPosition());
        return hash;
    }

    public static CompletionParams create(TextDocumentIdentifier textDocument, Position position) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        return new CompletionParams(json);
    }
}

