/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.request.CompletionRequestHandler;
import org.graalvm.tools.lsp.server.types.Hover;
import org.graalvm.tools.lsp.server.types.MarkedString;
import org.graalvm.tools.lsp.server.types.MarkupContent;
import org.graalvm.tools.lsp.server.types.MarkupKind;
import org.graalvm.tools.lsp.server.utils.CoverageData;
import org.graalvm.tools.lsp.server.utils.CoverageEventNode;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class HoverRequestHandler
extends AbstractRequestHandler {
    static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private final CompletionRequestHandler completionHandler;
    private final boolean developerMode;

    public HoverRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor contextAwareExecutor, CompletionRequestHandler completionHandler, boolean developerMode) {
        super(envMain, env, surrogateMap, contextAwareExecutor);
        this.completionHandler = completionHandler;
        this.developerMode = developerMode;
    }

    public Hover hoverWithEnteredContext(URI uri, int line, int column) {
        TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        InstrumentableNode nodeAtCaret = this.findNodeAtCaret(surrogate, line, column, new Class[0]);
        if (nodeAtCaret != null) {
            SourceSection hoverSection = ((Node)nodeAtCaret).getSourceSection();
            this.logger.log(Level.FINER, "Hover: SourceSection({0})", (Object)hoverSection.getCharacters());
            if (surrogate.hasCoverageData()) {
                List<CoverageData> coverages = surrogate.getCoverageData(hoverSection);
                if (coverages != null) {
                    return this.evalHoverInfos(coverages, hoverSection, surrogate.getLanguageInfo());
                }
            } else if (this.developerMode) {
                String sourceText = hoverSection.getCharacters().toString();
                MarkupContent content = MarkupContent.create(MarkupKind.PlainText, "Language: " + surrogate.getLanguageId() + ", Section: " + sourceText + "\nNode class: " + nodeAtCaret.getClass().getSimpleName() + "\nTags: " + HoverRequestHandler.getTags(nodeAtCaret));
                return Hover.create(content).setRange(SourceUtils.sourceSectionToRange(hoverSection));
            }
        }
        return Hover.create(Collections.emptyList());
    }

    private static String getTags(InstrumentableNode nodeAtCaret) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Class tagClass : new Class[]{StandardTags.StatementTag.class, StandardTags.CallTag.class, StandardTags.RootTag.class, StandardTags.ExpressionTag.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class}) {
            if (!nodeAtCaret.hasTag(tagClass)) continue;
            tags.add(Tag.getIdentifier((Class)tagClass));
        }
        return ((Object)tags).toString();
    }

    private Hover evalHoverInfos(List<CoverageData> coverages, SourceSection hoverSection, LanguageInfo langInfo) {
        String textAtHoverPosition = hoverSection.getCharacters().toString();
        for (CoverageData coverageData : coverages) {
            Hover frameSlotHover = this.tryFrameScope(coverageData.getFrame(), (Node)coverageData.getCoverageEventNode(), textAtHoverPosition, langInfo, hoverSection);
            if (frameSlotHover != null) {
                return frameSlotHover;
            }
            Hover coverageDataHover = this.tryCoverageDataEvaluation(hoverSection, langInfo, textAtHoverPosition, coverageData);
            if (coverageDataHover == null) continue;
            return coverageDataHover;
        }
        return Hover.create(Collections.emptyList());
    }

    private Hover tryCoverageDataEvaluation(SourceSection hoverSection, LanguageInfo langInfo, String textAtHoverPosition, CoverageData coverageData) {
        InstrumentableNode instrumentable = (InstrumentableNode)coverageData.getCoverageEventNode().getInstrumentedNode();
        if (!instrumentable.hasTag(StandardTags.ExpressionTag.class)) {
            return null;
        }
        Future<Hover> future = this.contextAwareExecutor.executeWithNestedContext(() -> {
            Hover signatureHover;
            LanguageInfo rootLangInfo = coverageData.getCoverageEventNode().getRootNode().getLanguageInfo();
            Source inlineEvalSource = Source.newBuilder((String)rootLangInfo.getId(), (CharSequence)textAtHoverPosition, (String)"in-line eval (hover request)").cached(false).build();
            ExecutableNode executableNode = null;
            try {
                executableNode = this.env.parseInline(inlineEvalSource, (Node)coverageData.getCoverageEventNode(), coverageData.getFrame());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (executableNode == null) {
                return Hover.create(Collections.emptyList());
            }
            CoverageEventNode coverageEventNode = coverageData.getCoverageEventNode();
            coverageEventNode.insertOrReplaceChild((Node)executableNode);
            Object evalResult = null;
            try {
                this.logger.fine("Trying coverage-based eval...");
                evalResult = executableNode.execute((VirtualFrame)coverageData.getFrame());
            }
            catch (Exception e) {
                if (!(e instanceof TruffleException) && !(e instanceof ControlFlowException)) {
                    e.printStackTrace(this.err);
                }
                Hover hover = Hover.create(Collections.emptyList());
                return hover;
            }
            finally {
                coverageEventNode.clearChild();
            }
            if (evalResult instanceof TruffleObject && (signatureHover = this.trySignature(hoverSection, langInfo, (TruffleObject)evalResult)) != null) {
                return signatureHover;
            }
            return Hover.create(this.createDefaultHoverInfos(textAtHoverPosition, evalResult, langInfo)).setRange(SourceUtils.sourceSectionToRange(hoverSection));
        }, true);
        return this.getFutureResultOrHandleExceptions(future);
    }

    private Hover trySignature(SourceSection hoverSection, LanguageInfo langInfo, TruffleObject evalResult) {
        String formattedSignature = this.completionHandler.getFormattedSignature(evalResult, langInfo);
        if (formattedSignature != null) {
            ArrayList<Object> contents = new ArrayList<Object>();
            contents.add(MarkedString.create(langInfo.getId(), formattedSignature));
            Object documentation = this.completionHandler.getDocumentation(evalResult, langInfo);
            if (documentation instanceof String) {
                contents.add(documentation);
            } else if (documentation instanceof MarkupContent) {
                MarkupContent markup = (MarkupContent)documentation;
                if (markup.getKind().equals((Object)MarkupKind.PlainText)) {
                    contents.add(markup.getValue());
                } else {
                    contents.add(MarkedString.create(langInfo.getId(), markup.getValue()));
                }
            }
            return Hover.create(contents).setRange(SourceUtils.sourceSectionToRange(hoverSection));
        }
        return null;
    }

    private Hover tryFrameScope(MaterializedFrame frame, Node node, String textAtHoverPosition, LanguageInfo langInfo, SourceSection hoverSection) {
        Iterator scopes = this.env.findLocalScopes(node, (Frame)frame).iterator();
        if (scopes.hasNext()) {
            Scope scope = (Scope)scopes.next();
            try {
                Object varsObject;
                Object argsObject = scope.getArguments();
                if (argsObject instanceof TruffleObject) {
                    Object keys = INTEROP.getMembers(argsObject);
                    long size = INTEROP.getArraySize(keys);
                    for (long i = 0L; i < size; ++i) {
                        String key = INTEROP.asString(INTEROP.readArrayElement(keys, i));
                        if (!key.equals(textAtHoverPosition)) continue;
                        Object argument = INTEROP.readMember(argsObject, key);
                        return Hover.create(this.createDefaultHoverInfos(textAtHoverPosition, argument, langInfo)).setRange(SourceUtils.sourceSectionToRange(hoverSection));
                    }
                }
                if ((varsObject = scope.getVariables()) instanceof TruffleObject) {
                    Object keys = INTEROP.getMembers(varsObject);
                    long size = INTEROP.getArraySize(keys);
                    for (long i = 0L; i < size; ++i) {
                        String key = INTEROP.asString(INTEROP.readArrayElement(keys, i));
                        if (!key.equals(textAtHoverPosition)) continue;
                        Object var = INTEROP.readMember(varsObject, key);
                        return Hover.create(this.createDefaultHoverInfos(textAtHoverPosition, var, langInfo)).setRange(SourceUtils.sourceSectionToRange(hoverSection));
                    }
                }
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private List<Object> createDefaultHoverInfos(String textAtHoverPosition, Object evalResultObject, LanguageInfo langInfo) {
        String result;
        ArrayList<Object> contents = new ArrayList<Object>();
        contents.add(MarkedString.create(langInfo.getId(), textAtHoverPosition));
        String string = result = evalResultObject != null ? this.env.toString(langInfo, evalResultObject) : "";
        if (!textAtHoverPosition.equals(result)) {
            String resultObjectString = evalResultObject instanceof String ? "\"" + result + "\"" : result;
            contents.add(resultObjectString);
        }
        String detailText = this.completionHandler.createCompletionDetail(evalResultObject, langInfo);
        contents.add("meta-object: " + detailText);
        Object documentation = this.completionHandler.getDocumentation(evalResultObject, langInfo);
        if (documentation instanceof String) {
            contents.add(documentation);
        } else if (documentation instanceof MarkupContent) {
            MarkupContent markup = (MarkupContent)documentation;
            if (markup.getKind().equals((Object)MarkupKind.PlainText)) {
                contents.add(markup.getValue());
            } else {
                contents.add(MarkedString.create(langInfo.getId(), markup.getValue()));
            }
        }
        return contents;
    }
}

