/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.request;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Function;
import org.graalvm.tools.lsp.exceptions.DiagnosticsNotification;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.request.AbstractRequestHandler;
import org.graalvm.tools.lsp.server.request.SourceCodeEvaluator;
import org.graalvm.tools.lsp.server.types.Coverage;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.DiagnosticSeverity;
import org.graalvm.tools.lsp.server.types.Range;
import org.graalvm.tools.lsp.server.utils.CoverageEventNode;
import org.graalvm.tools.lsp.server.utils.SourcePredicateBuilder;
import org.graalvm.tools.lsp.server.utils.SourceSectionReference;
import org.graalvm.tools.lsp.server.utils.SourceUtils;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogate;
import org.graalvm.tools.lsp.server.utils.TextDocumentSurrogateMap;

public final class CoverageRequestHandler
extends AbstractRequestHandler {
    private final SourceCodeEvaluator sourceCodeEvaluator;

    public CoverageRequestHandler(TruffleInstrument.Env envMain, TruffleInstrument.Env env, TextDocumentSurrogateMap surrogateMap, ContextAwareExecutor contextAwareExecutor, SourceCodeEvaluator sourceCodeEvaluator) {
        super(envMain, env, surrogateMap, contextAwareExecutor);
        this.sourceCodeEvaluator = sourceCodeEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean runCoverageAnalysisWithEnteredContext(URI uri) throws DiagnosticsNotification {
        TextDocumentSurrogate surrogateOfOpenedFile = this.surrogateMap.get(uri);
        if (surrogateOfOpenedFile == null) {
            return Boolean.FALSE;
        }
        TextDocumentSurrogate surrogateOfTestFile = this.sourceCodeEvaluator.createSurrogateForTestFile(surrogateOfOpenedFile, null);
        final URI runScriptUri = surrogateOfTestFile.getUri();
        this.clearRelatedCoverageData(runScriptUri);
        try {
            CallTarget callTarget = this.sourceCodeEvaluator.parse(surrogateOfTestFile);
            LanguageInfo languageInfo = surrogateOfTestFile.getLanguageInfo();
            SourceSectionFilter.SourcePredicate predicate = SourcePredicateBuilder.newBuilder().language(languageInfo).excludeInternal(this.env.getOptions()).build();
            SourceSectionFilter eventFilter = SourceSectionFilter.newBuilder().sourceIs(predicate).build();
            EventBinding eventFactoryBinding = this.env.getInstrumenter().attachExecutionEventFactory(eventFilter, new ExecutionEventNodeFactory(){
                private final long creatorThreadId = Thread.currentThread().getId();

                public ExecutionEventNode create(EventContext eventContext) {
                    SourceSection section = eventContext.getInstrumentedSourceSection();
                    if (section != null && section.isAvailable()) {
                        Node instrumentedNode = eventContext.getInstrumentedNode();
                        Function<URI, TextDocumentSurrogate> func = sourceUri -> CoverageRequestHandler.this.surrogateMap.getOrCreateSurrogate((URI)sourceUri, () -> instrumentedNode.getRootNode().getLanguageInfo());
                        return new CoverageEventNode(section, instrumentedNode, runScriptUri, func, this.creatorThreadId);
                    }
                    return null;
                }
            });
            try {
                callTarget.call(new Object[0]);
            }
            finally {
                eventFactoryBinding.dispose();
            }
            surrogateOfOpenedFile.setCoverageAnalysisDone(true);
            return Boolean.TRUE;
        }
        catch (DiagnosticsNotification e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof TruffleException) {
                SourceSection sourceSection;
                Node location = ((TruffleException)e).getLocation();
                URI uriOfErronousSource = null;
                if (location != null && (sourceSection = location.getEncapsulatingSourceSection()) != null) {
                    uriOfErronousSource = sourceSection.getSource().getURI();
                }
                if (uriOfErronousSource == null) {
                    uriOfErronousSource = uri;
                }
                throw DiagnosticsNotification.create(uriOfErronousSource, Diagnostic.create(SourceUtils.getRangeFrom((TruffleException)e), e.getMessage(), DiagnosticSeverity.Error, null, "Coverage analysis", null));
            }
            throw e;
        }
    }

    private void clearRelatedCoverageData(URI runScriptUri) {
        TextDocumentSurrogate surrogateOfRunScript = this.surrogateMap.get(runScriptUri);
        assert (surrogateOfRunScript != null);
        surrogateOfRunScript.clearCoverage();
        this.surrogateMap.getSurrogates().stream().forEach(surrogate -> surrogate.clearCoverage(runScriptUri));
    }

    public Coverage getCoverageWithEnteredContext(URI uri) {
        final TextDocumentSurrogate surrogate = this.surrogateMap.get(uri);
        if (surrogate != null && surrogate.getSourceWrapper() != null && surrogate.getSourceWrapper().isParsingSuccessful()) {
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{surrogate.getSourceWrapper().getSource()}).tagIs(new Class[]{StandardTags.StatementTag.class}).build();
            final HashSet duplicateFilter = new HashSet();
            final ArrayList<Range> covered = new ArrayList<Range>();
            final ArrayList<Range> uncovered = new ArrayList<Range>();
            this.env.getInstrumenter().attachLoadSourceSectionListener(filter, new LoadSourceSectionListener(){

                public void onLoad(LoadSourceSectionEvent event) {
                    SourceSection section = event.getSourceSection();
                    if (duplicateFilter.add(section)) {
                        if (surrogate.isLocationCovered(SourceSectionReference.from(section))) {
                            covered.add(SourceUtils.sourceSectionToRange(section));
                        } else {
                            uncovered.add(SourceUtils.sourceSectionToRange(section));
                        }
                    }
                }
            }, true).dispose();
            return Coverage.create(covered, uncovered);
        }
        return null;
    }
}

