/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.tools.lsp.server.VirtualLanguageServerFileProvider;

public final class LSPFileSystem
implements FileSystem {
    private final FileSystemProvider delegate;
    private final VirtualLanguageServerFileProvider fileProvider;
    static final String FILE_SCHEME = "file";

    public static FileSystem newReadOnlyFileSystem(VirtualLanguageServerFileProvider fileProvider) {
        return LSPFileSystem.newReadOnlyFileSystem(LSPFileSystem.findDefaultFileSystemProvider(), fileProvider);
    }

    static FileSystem newReadOnlyFileSystem(FileSystemProvider fileSystemProvider, VirtualLanguageServerFileProvider fileProvider) {
        return new LSPFileSystem(fileSystemProvider, fileProvider);
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider fsp : FileSystemProvider.installedProviders()) {
            if (!FILE_SCHEME.equals(fsp.getScheme())) continue;
            return fsp;
        }
        throw new IllegalStateException("No FileSystemProvider for scheme 'file'.");
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (lo != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private LSPFileSystem(FileSystemProvider fileSystemProvider, VirtualLanguageServerFileProvider fileProvider) {
        Objects.requireNonNull(fileSystemProvider, "FileSystemProvider must be non null.");
        this.delegate = fileSystemProvider;
        this.fileProvider = fileProvider;
    }

    public Path parsePath(URI uri) {
        return this.delegate.getPath(uri);
    }

    public Path parsePath(String path) {
        if (!FILE_SCHEME.equalsIgnoreCase(this.delegate.getScheme())) {
            throw new IllegalStateException("The ParsePath(String path) should be called only for file scheme.");
        }
        return Paths.get(path, new String[0]);
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        if (modes.contains((Object)AccessMode.WRITE)) {
            throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
        }
        if (modes.contains((Object)AccessMode.EXECUTE) && !this.delegate.readAttributes(path, BasicFileAttributes.class, linkOptions).isDirectory()) {
            throw new AccessDeniedException(path.toString(), null, "Execution not allowed. Read-only file-system.");
        }
        if (LSPFileSystem.isFollowLinks(linkOptions)) {
            this.delegate.checkAccess(path, modes.toArray(new AccessMode[modes.size()]));
        } else if (modes.isEmpty()) {
            this.delegate.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
        } else {
            throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
        }
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(dir.toString(), null, "Read-only file-system");
    }

    public void delete(Path path) throws IOException {
        throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
    }

    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new AccessDeniedException(source.toString(), target.toString(), "Read-only file-system");
    }

    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new AccessDeniedException(source.toString(), target.toString(), "Read-only file-system");
    }

    public SeekableByteChannel newByteChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        for (OpenOption openOption : options) {
            if (openOption instanceof StandardOpenOption && StandardOpenOption.READ.equals(openOption)) continue;
            throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
        }
        String text = this.fileProvider.getSourceText(path);
        if (text != null) {
            final byte[] byArray = text.getBytes();
            return new SeekableByteChannel(){
                int position = 0;

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
                }

                @Override
                public SeekableByteChannel truncate(long size) throws IOException {
                    throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
                }

                @Override
                public long size() throws IOException {
                    return byArray.length;
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    int len = Math.min(dst.remaining(), byArray.length - this.position);
                    dst.put(byArray, this.position, len);
                    this.position += len;
                    return len;
                }

                @Override
                public SeekableByteChannel position(long newPosition) throws IOException {
                    if (newPosition > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("> Integer.MAX_VALUE");
                    }
                    this.position = (int)newPosition;
                    return this;
                }

                @Override
                public long position() throws IOException {
                    return this.position;
                }
            };
        }
        try {
            return this.delegate.newFileChannel(path, options, attrs);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return this.delegate.newByteChannel(path, options, attrs);
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.delegate.newDirectoryStream(dir, filter);
    }

    public void createLink(Path link, Path existing) throws IOException {
        throw new AccessDeniedException(link.toString(), null, "Read-only file-system");
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(link.toString(), null, "Read-only file-system");
    }

    public Path readSymbolicLink(Path link) throws IOException {
        return this.delegate.readSymbolicLink(link);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(path, attributes, options);
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new AccessDeniedException(path.toString(), null, "Read-only file-system");
    }

    public Path toAbsolutePath(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return path.toAbsolutePath();
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        return path.toRealPath(linkOptions);
    }
}

