/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.graalvm.tools.lsp.server.TruffleAdapter;
import org.graalvm.tools.lsp.server.types.CodeLensOptions;
import org.graalvm.tools.lsp.server.types.CompletionOptions;
import org.graalvm.tools.lsp.server.types.DocumentLinkOptions;
import org.graalvm.tools.lsp.server.types.ExecuteCommandOptions;
import org.graalvm.tools.lsp.server.types.LanguageServer;
import org.graalvm.tools.lsp.server.types.RenameOptions;
import org.graalvm.tools.lsp.server.types.ServerCapabilities;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncKind;
import org.graalvm.tools.lsp.server.types.TextDocumentSyncOptions;

public final class DelegateServers {
    private final TruffleAdapter truffleAdapter;
    private final LanguageServer.DelegateServer[] delegateServers;
    private final LanguageServer.LoggerProxy logger;

    public DelegateServers(TruffleAdapter truffleAdapter, List<LanguageServer.DelegateServer> delegateServers, LanguageServer.LoggerProxy logger) {
        this.truffleAdapter = truffleAdapter;
        this.delegateServers = delegateServers.toArray(new LanguageServer.DelegateServer[delegateServers.size()]);
        this.logger = logger;
    }

    public void submitAll(ExecutorService executors) {
        for (LanguageServer.DelegateServer ds : this.delegateServers) {
            executors.submit(ds);
        }
    }

    public void sendMessageToDelegates(byte[] buffer, Object id, String method, JSONObject params) {
        String language = this.findContextLanguage(params);
        for (LanguageServer.DelegateServer ds : this.delegateServers) {
            if (!DelegateServers.languageMatch(language, ds.getLanguageId()) || !DelegateServers.supportsMethod(method, params, ds.getCapabilities())) continue;
            try {
                ds.sendMessage(buffer, id, method);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Delegate server " + ds.getAddress() + ": " + e.getMessage(), e);
            }
        }
    }

    private String findContextLanguage(JSONObject params) {
        JSONObject textDocument = params != null ? params.optJSONObject("textDocument") : null;
        Object uri = textDocument != null ? textDocument.opt("uri") : null;
        return uri instanceof String ? this.truffleAdapter.getLanguageId(URI.create((String)uri)) : null;
    }

    private static boolean languageMatch(String languageId1, String languageId2) {
        if (languageId1 == null || languageId2 == null) {
            return true;
        }
        return languageId1.equals(languageId2);
    }

    public Object mergeResults(Object id, Object result) {
        Object allResults = result;
        for (LanguageServer.DelegateServer ds : this.delegateServers) {
            try {
                JSONObject message = ds.awaitMessage(id);
                if (message != null && this.logger.isLoggable(Level.FINER)) {
                    String format = "[Trace - %s] Received response from %s: %s";
                    this.logger.log(Level.FINER, String.format(format, Instant.now().toString(), ds.toString(), message.toString()));
                }
                allResults = DelegateServers.mergeResults(allResults, message);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return allResults;
    }

    public void close() {
        for (LanguageServer.DelegateServer ds : this.delegateServers) {
            ds.close();
        }
    }

    private static Object mergeResults(Object allResults, JSONObject message2) {
        if (message2 != null && message2.has("result")) {
            Object result2 = message2.get("result");
            if (allResults == null) {
                return result2;
            }
            DelegateServers.mergeJSONInto("result", allResults, result2);
        }
        return allResults;
    }

    private static Object mergeJSONInto(String propertyName, Object j1, Object j2) {
        if (j1 instanceof JSONObject && j2 instanceof JSONObject) {
            JSONObject jo1 = (JSONObject)j1;
            JSONObject jo2 = (JSONObject)j2;
            for (String key2 : jo2.keySet()) {
                if (!jo1.has(key2)) {
                    jo1.put(key2, jo2.get(key2));
                    continue;
                }
                jo1.put(key2, DelegateServers.mergeJSONInto(key2, jo1.get(key2), jo2.get(key2)));
            }
        } else if (j1 instanceof JSONArray) {
            JSONArray ja1 = (JSONArray)j1;
            if (j2 instanceof JSONArray) {
                JSONArray ja2 = (JSONArray)j2;
                if (ja1.isEmpty()) {
                    for (Object value : ja2) {
                        ja1.put(value);
                    }
                } else if (!ja2.isEmpty()) {
                    Set<String> labels = DelegateServers.getLabels(ja1);
                    for (Object value : ja2) {
                        DelegateServers.addIfNoSuchLabel(ja1, labels, value);
                    }
                }
            } else if (!ja1.isEmpty()) {
                Set<String> labels = DelegateServers.getLabels(ja1);
                DelegateServers.addIfNoSuchLabel(ja1, labels, j2);
            } else {
                ja1.put(j2);
            }
        } else if (j2 instanceof JSONArray) {
            JSONArray ja2 = (JSONArray)j2;
            if (!ja2.isEmpty()) {
                Set<String> labels = DelegateServers.getLabels(ja2);
                DelegateServers.addIfNoSuchLabel(ja2, labels, j1);
            } else {
                ja2.put(j1);
            }
        } else {
            if (DelegateServers.isTrue(j1) && DelegateServers.isFalse(j2) || DelegateServers.isFalse(j1) && DelegateServers.isTrue(j2)) {
                return Boolean.TRUE;
            }
            if (j1 instanceof Number && j2 instanceof Number && "textDocumentSync".equals(propertyName)) {
                int i1 = ((Number)j1).intValue();
                int i2 = ((Number)j2).intValue();
                if (i1 == 0 || i2 == 0) {
                    return 0;
                }
                if (i1 == 1 || i2 == 1) {
                    return 1;
                }
            }
        }
        return j1;
    }

    private static boolean isTrue(Object jsonObj) {
        return Boolean.TRUE.equals(jsonObj) || jsonObj instanceof String && "true".equalsIgnoreCase((String)jsonObj);
    }

    private static boolean isFalse(Object jsonObj) {
        return Boolean.FALSE.equals(jsonObj) || jsonObj instanceof String && "false".equalsIgnoreCase((String)jsonObj);
    }

    private static String getLabel(Object value) {
        if (value instanceof JSONObject) {
            JSONObject jv = (JSONObject)value;
            return jv.optString("label");
        }
        return null;
    }

    private static Set<String> getLabels(JSONArray ja) {
        Set<String> labels = null;
        for (Object value : ja) {
            String label = DelegateServers.getLabel(value);
            if (label == null) continue;
            if (labels == null) {
                labels = new HashSet<String>();
            }
            labels.add(label);
        }
        return labels != null ? labels : Collections.emptySet();
    }

    private static void addIfNoSuchLabel(JSONArray ja, Set<String> labels, Object value) {
        String label = DelegateServers.getLabel(value);
        if (label == null || !labels.contains(label)) {
            ja.put(value);
        }
    }

    static boolean supportsMethod(String method, JSONObject params, ServerCapabilities capabilities) {
        Object capability;
        switch (method) {
            case "textDocument/codeAction": {
                capability = capabilities.getCodeActionProvider();
                break;
            }
            case "textDocument/codeLens": {
                capability = capabilities.getCodeLensProvider();
                break;
            }
            case "codeLens/resolve": {
                CodeLensOptions clp = capabilities.getCodeLensProvider();
                capability = clp != null ? clp.getResolveProvider() : null;
                break;
            }
            case "textDocument/colorPresentation": {
                capability = capabilities.getColorProvider();
                break;
            }
            case "textDocument/completion": {
                capability = capabilities.getCompletionProvider();
                break;
            }
            case "completionItem/resolve": {
                CompletionOptions co = capabilities.getCompletionProvider();
                capability = co != null ? co.getResolveProvider() : null;
                break;
            }
            case "textDocument/declaration": {
                capability = capabilities.getDeclarationProvider();
                break;
            }
            case "textDocument/definition": {
                capability = capabilities.getDefinitionProvider();
                break;
            }
            case "textDocument/formatting": {
                capability = capabilities.getDocumentFormattingProvider();
                break;
            }
            case "textDocument/documentHighlight": {
                capability = capabilities.getDocumentHighlightProvider();
                break;
            }
            case "textDocument/documentLink": {
                capability = capabilities.getDocumentLinkProvider();
                break;
            }
            case "documentLink/resolve": {
                DocumentLinkOptions dlo = capabilities.getDocumentLinkProvider();
                capability = dlo != null ? dlo.getResolveProvider() : null;
                break;
            }
            case "textDocument/onTypeFormatting": {
                capability = capabilities.getDocumentOnTypeFormattingProvider();
                break;
            }
            case "textDocument/rangeFormatting": {
                capability = capabilities.getDocumentRangeFormattingProvider();
                break;
            }
            case "textDocument/documentSymbol": {
                capability = capabilities.getDocumentSymbolProvider();
                break;
            }
            case "workspace/executeCommand": {
                ExecuteCommandOptions eco = capabilities.getExecuteCommandProvider();
                return eco.getCommands().contains(params.getString("command"));
            }
            case "textDocument/foldingRange": {
                capability = capabilities.getFoldingRangeProvider();
                break;
            }
            case "textDocument/hover": {
                capability = capabilities.getHoverProvider();
                break;
            }
            case "textDocument/implementation": {
                capability = capabilities.getImplementationProvider();
                break;
            }
            case "textDocument/references": {
                capability = capabilities.getReferencesProvider();
                break;
            }
            case "textDocument/rename": {
                capability = capabilities.getRenameProvider();
                break;
            }
            case "textDocument/prepareRename": {
                Object renameProvider = capabilities.getRenameProvider();
                capability = renameProvider != null ? ((RenameOptions)renameProvider).getPrepareProvider() : null;
                break;
            }
            case "textDocument/signatureHelp": {
                capability = capabilities.getSignatureHelpProvider();
                break;
            }
            case "textDocument/didChange": {
                capability = capabilities.getTextDocumentSync();
                if (capability instanceof TextDocumentSyncOptions) {
                    capability = ((TextDocumentSyncOptions)capability).getChange();
                }
                capability = capability == TextDocumentSyncKind.Full || capability == TextDocumentSyncKind.Incremental ? Boolean.valueOf(true) : null;
                break;
            }
            case "textDocument/typeDefinition": {
                capability = capabilities.getTypeDefinitionProvider();
                break;
            }
            case "workspace/symbol": {
                capability = capabilities.getWorkspaceSymbolProvider();
                break;
            }
            default: {
                return true;
            }
        }
        return capability != null && !Boolean.FALSE.equals(capability);
    }
}

