/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ByteIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.HalfIndexer;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferIndexer
extends ByteIndexer {
    protected ByteBuffer buffer;

    public ByteBufferIndexer(ByteBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public ByteBufferIndexer(ByteBuffer buffer, long ... sizes) {
        this(buffer, sizes, ByteBufferIndexer.strides(sizes));
    }

    public ByteBufferIndexer(ByteBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public byte get(long i) {
        return this.buffer.get((int)i);
    }

    @Override
    public ByteIndexer get(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j);
    }

    @Override
    public ByteIndexer get(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j, long k) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k);
    }

    @Override
    public byte get(long ... indices) {
        return this.buffer.get((int)this.index(indices));
    }

    @Override
    public ByteIndexer get(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get((int)this.index(indices) + n);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte b) {
        this.buffer.put((int)i, b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte b) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, long k, byte b) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte b) {
        this.buffer.put((int)this.index(indices), b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public short getShort(long i) {
        return this.buffer.getShort((int)i);
    }

    @Override
    public ByteIndexer putShort(long i, short s) {
        this.buffer.putShort((int)i, s);
        return this;
    }

    @Override
    public int getInt(long i) {
        return this.buffer.getInt((int)i);
    }

    @Override
    public ByteIndexer putInt(long i, int j) {
        this.buffer.putInt((int)i, j);
        return this;
    }

    @Override
    public long getLong(long i) {
        return this.buffer.getLong((int)i);
    }

    @Override
    public ByteIndexer putLong(long i, long j) {
        this.buffer.putLong((int)i, j);
        return this;
    }

    @Override
    public float getFloat(long i) {
        return this.buffer.getFloat((int)i);
    }

    @Override
    public ByteIndexer putFloat(long i, float f) {
        this.buffer.putFloat((int)i, f);
        return this;
    }

    @Override
    public double getDouble(long i) {
        return this.buffer.getDouble((int)i);
    }

    @Override
    public ByteIndexer putDouble(long i, double d) {
        this.buffer.putDouble((int)i, d);
        return this;
    }

    @Override
    public char getChar(long i) {
        return this.buffer.getChar((int)i);
    }

    @Override
    public ByteIndexer putChar(long i, char c) {
        this.buffer.putChar((int)i, c);
        return this;
    }

    @Override
    public int getUByte(long i) {
        return this.buffer.get((int)i) & 0xFF;
    }

    @Override
    public ByteIndexer putUByte(long i, int b) {
        this.buffer.put((int)i, (byte)b);
        return this;
    }

    @Override
    public int getUShort(long i) {
        return this.buffer.getShort((int)i) & 0xFFFF;
    }

    @Override
    public ByteIndexer putUShort(long i, int s) {
        this.buffer.putShort((int)i, (short)s);
        return this;
    }

    @Override
    public float getHalf(long i) {
        return HalfIndexer.toFloat(this.buffer.getShort((int)i));
    }

    @Override
    public ByteIndexer putHalf(long i, float h) {
        this.buffer.putShort((int)i, (short)HalfIndexer.fromFloat(h));
        return this;
    }

    @Override
    public float getBfloat16(long i) {
        return Bfloat16Indexer.toFloat(this.buffer.getShort((int)i));
    }

    @Override
    public ByteIndexer putBfloat16(long i, float h) {
        this.buffer.putShort((int)i, (short)Bfloat16Indexer.fromFloat(h));
        return this;
    }

    @Override
    public boolean getBoolean(long i) {
        return this.buffer.get((int)i) != 0;
    }

    @Override
    public ByteIndexer putBoolean(long i, boolean b) {
        this.buffer.put((int)i, b ? (byte)1 : 0);
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

