/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.AgentType;
import com.oracle.truffle.tools.agentscript.impl.EventContextObject;
import java.util.Locale;

final class InsightException
extends RuntimeException
implements TruffleException {
    static final long serialVersionUID = 1L;
    private final int exitCode;
    private final Node node;

    @CompilerDirectives.TruffleBoundary
    private InsightException(String msg, Throwable cause, int exitCode) {
        super("insight: " + msg, cause);
        this.exitCode = exitCode;
        this.node = null;
    }

    @CompilerDirectives.TruffleBoundary
    private InsightException(Throwable cause, Node node) {
        super(cause.getMessage());
        this.exitCode = -1;
        this.node = node;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public Node getLocation() {
        return this.node;
    }

    public boolean isExit() {
        return this.exitCode >= 0;
    }

    public int getExitStatus() {
        return this.exitCode;
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException raise(Exception ex) throws InsightException {
        String msg = ex.getMessage() == null ? "Unexpected " + ex.getClass().getSimpleName() : ex.getMessage().replace(System.lineSeparator(), ": ");
        throw new InsightException(msg, ex, -1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException notFound(TruffleFile file) {
        throw new InsightException(file.getName() + ": No such file or directory", null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException notRecognized(TruffleFile file) {
        throw new InsightException(file.getName() + ": No language to process the file. Try --polyglot", null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException unknownAttribute(String type) {
        throw new InsightException("Unknown attribute " + type, null, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static InsightException unknownType(Throwable originalError, String str, AgentType[] values) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown event type '").append(str).append("'. Known types are:");
        String sep = " ";
        for (AgentType t : values) {
            sb.append(sep).append("'").append(t.toString().toLowerCase(Locale.ENGLISH)).append("'");
            sep = ", ";
        }
        throw new InsightException(sb.toString(), originalError, 1);
    }

    @CompilerDirectives.TruffleBoundary
    static void throwWhenExecuted(Instrumenter instrumenter, Source source, final Exception ex) {
        TruffleStackTrace.getStackTrace((Throwable)ex);
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(new Source[]{source}).build();
        final EventBinding[] waitForSourceBeingExecuted = new EventBinding[]{null};
        waitForSourceBeingExecuted[0] = instrumenter.attachExecutionEventListener(filter, new ExecutionEventListener(){

            @CompilerDirectives.TruffleBoundary
            public void onEnter(EventContext context, VirtualFrame frame) {
                waitForSourceBeingExecuted[0].dispose();
                EventContextObject obj = new EventContextObject(context);
                if (ex instanceof TruffleException && ex instanceof RuntimeException) {
                    throw obj.rethrow((RuntimeException)ex);
                }
                InsightException wrapper = new InsightException(ex, context.getInstrumentedNode());
                throw obj.rethrow(wrapper);
            }

            public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
            }

            public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            }
        });
    }
}

