/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.SourceEventObject;

@ExportLibrary(value=InteropLibrary.class)
final class EventContextObject
implements TruffleObject {
    private static final ArrayObject MEMBERS = ArrayObject.array("name", "source", "characters", "line", "startLine", "endLine", "column", "startColumn", "endColumn");
    private final EventContext context;
    @CompilerDirectives.CompilationFinal
    private String name;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] values;

    EventContextObject(EventContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    RuntimeException wrap(Object target, int arity, InteropException ex) {
        IllegalStateException ill = new IllegalStateException("Cannot invoke " + target + " with " + arity + " arguments: " + ex.getMessage());
        ill.initCause(ex);
        return this.context.createError((RuntimeException)ill);
    }

    RuntimeException rethrow(RuntimeException ex) {
        if (ex instanceof TruffleException && !((TruffleException)ex).isInternalError()) {
            return this.context.createError(ex);
        }
        throw ex;
    }

    @ExportMessage
    static boolean hasMembers(EventContextObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(EventContextObject obj, boolean includeInternal) {
        return MEMBERS;
    }

    @ExportMessage
    Object readMember(String member) throws UnknownIdentifierException {
        int index;
        switch (member) {
            case "name": {
                if (this.name == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.name = this.context.getInstrumentedNode().getRootNode().getName();
                }
                return this.name;
            }
            case "characters": {
                CompilerDirectives.transferToInterpreter();
                return this.context.getInstrumentedSourceSection().getCharacters().toString();
            }
            case "source": {
                return new SourceEventObject(this.context.getInstrumentedSourceSection().getSource());
            }
            case "line": 
            case "startLine": {
                index = 0;
                break;
            }
            case "endLine": {
                index = 1;
                break;
            }
            case "column": 
            case "startColumn": {
                index = 2;
                break;
            }
            case "endColumn": {
                index = 3;
                break;
            }
            default: {
                throw UnknownIdentifierException.create((String)member);
            }
        }
        if (this.values == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.values = this.valuesForContext();
        }
        return this.values[index];
    }

    @CompilerDirectives.TruffleBoundary
    private int[] valuesForContext() {
        SourceSection section = this.context.getInstrumentedSourceSection();
        return new int[]{section.getStartLine(), section.getEndLine(), section.getStartColumn(), section.getEndColumn()};
    }

    @ExportMessage
    static boolean isMemberReadable(EventContextObject obj, String member) {
        return MEMBERS.contains(member);
    }
}

