/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.tools.agentscript.FrameLibrary;
import com.oracle.truffle.tools.agentscript.impl.DefaultFrameLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FrameLibrary.class)
final class FrameLibraryGen
extends LibraryFactory<FrameLibrary> {
    private static final Class<FrameLibrary> LIBRARY_CLASS = FrameLibraryGen.lazyLibraryClass();
    private static final Message READ_MEMBER = new MessageImpl("readMember", 0, Object.class, FrameLibrary.Query.class, String.class);
    private static final Message WRITE_MEMBER = new MessageImpl("writeMember", 1, Void.TYPE, FrameLibrary.Query.class, String.class, Object.class);
    private static final Message COLLECT_NAMES = new MessageImpl("collectNames", 2, Void.TYPE, FrameLibrary.Query.class, Set.class);
    private static final FrameLibraryGen INSTANCE = new FrameLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private FrameLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(READ_MEMBER, WRITE_MEMBER, COLLECT_NAMES)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof FrameLibrary.Query) {
            return DefaultFrameLibrary.class;
        }
        return FrameLibrary.class;
    }

    protected FrameLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected FrameLibrary createDelegate(FrameLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        FrameLibrary lib = (FrameLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.readMember((FrameLibrary.Query)receiver, (String)args[offset]);
            }
            case 1: {
                lib.writeMember((FrameLibrary.Query)receiver, (String)args[offset], args[offset + 1]);
                return null;
            }
            case 2: {
                lib.collectNames((FrameLibrary.Query)receiver, (Set)args[offset]);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected FrameLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected FrameLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<FrameLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.tools.agentscript.FrameLibrary", false, FrameLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static abstract class CachedDispatch
    extends FrameLibrary {
        @Node.Child
        FrameLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(FrameLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object readMember(FrameLibrary.Query receiver_, String member) throws UnknownIdentifierException {
            while (true) {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readMember(receiver_, member);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeMember(FrameLibrary.Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeMember(receiver_, member, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void collectNames(FrameLibrary.Query receiver_, Set<String> names) throws InteropException {
            while (true) {
                CachedDispatch current = this;
                do {
                    FrameLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.collectNames(receiver_, names);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(FrameLibrary.Query receiver_) {
            CachedDispatch current = this;
            FrameLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (FrameLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        FrameLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (FrameLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((FrameLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(FrameLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(FrameLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class UncachedDispatch
    extends FrameLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readMember(FrameLibrary.Query receiver_, String member) throws UnknownIdentifierException {
            return ((FrameLibrary)INSTANCE.getUncached(receiver_)).readMember(receiver_, member);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeMember(FrameLibrary.Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            ((FrameLibrary)INSTANCE.getUncached(receiver_)).writeMember(receiver_, member, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void collectNames(FrameLibrary.Query receiver_, Set<String> names) throws InteropException {
            ((FrameLibrary)INSTANCE.getUncached(receiver_)).collectNames(receiver_, names);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class CachedToUncachedDispatch
    extends FrameLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readMember(FrameLibrary.Query receiver_, String member) throws UnknownIdentifierException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((FrameLibrary)INSTANCE.getUncached(receiver_)).readMember(receiver_, member);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeMember(FrameLibrary.Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((FrameLibrary)INSTANCE.getUncached(receiver_)).writeMember(receiver_, member, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void collectNames(FrameLibrary.Query receiver_, Set<String> names) throws InteropException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((FrameLibrary)INSTANCE.getUncached(receiver_)).collectNames(receiver_, names);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class Delegate
    extends FrameLibrary {
        @Node.Child
        private FrameLibrary delegateLibrary;

        Delegate(FrameLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object readMember(FrameLibrary.Query receiver_, String member) throws UnknownIdentifierException {
            if (FrameLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = FrameLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((FrameLibrary)FrameLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readMember((FrameLibrary.Query)delegate, member);
            }
            return this.delegateLibrary.readMember(receiver_, member);
        }

        @Override
        public void writeMember(FrameLibrary.Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            if (FrameLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = FrameLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((FrameLibrary)FrameLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeMember((FrameLibrary.Query)delegate, member, value);
                return;
            }
            this.delegateLibrary.writeMember(receiver_, member, value);
        }

        @Override
        public void collectNames(FrameLibrary.Query receiver_, Set<String> names) throws InteropException {
            if (FrameLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = FrameLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((FrameLibrary)FrameLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).collectNames((FrameLibrary.Query)delegate, names);
                return;
            }
            this.delegateLibrary.collectNames(receiver_, names);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class Proxy
    extends FrameLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object readMember(FrameLibrary.Query receiver_, String member) throws UnknownIdentifierException {
            try {
                return this.lib.send((Object)receiver_, READ_MEMBER, new Object[]{member});
            }
            catch (UnknownIdentifierException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeMember(FrameLibrary.Query receiver_, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
            try {
                this.lib.send((Object)receiver_, WRITE_MEMBER, new Object[]{member, value});
                return;
            }
            catch (UnknownIdentifierException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void collectNames(FrameLibrary.Query receiver_, Set<String> names) throws InteropException {
            try {
                this.lib.send((Object)receiver_, COLLECT_NAMES, new Object[]{names});
                return;
            }
            catch (InteropException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=FrameLibrary.class)
    private static final class Default
    extends LibraryExport<FrameLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private Default() {
            super(FrameLibrary.class, FrameLibrary.Query.class, false);
        }

        protected FrameLibrary createUncached(Object receiver) {
            assert (receiver instanceof FrameLibrary.Query);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected FrameLibrary createCached(Object receiver) {
            assert (receiver instanceof FrameLibrary.Query);
            return CACHE;
        }

        @GeneratedBy(value=FrameLibrary.class)
        private static final class Uncached
        extends FrameLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof FrameLibrary.Query) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof FrameLibrary.Query;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(FrameLibrary.Query receiver, String member) throws UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readMember(receiver, member);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(FrameLibrary.Query receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeMember(receiver, member, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void collectNames(FrameLibrary.Query receiver, Set<String> names) throws InteropException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.collectNames(receiver, names);
            }
        }

        @GeneratedBy(value=FrameLibrary.class)
        private static final class Cached
        extends FrameLibrary {
            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof FrameLibrary.Query) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof FrameLibrary.Query;
            }

            public boolean isAdoptable() {
                return false;
            }

            @Override
            public Object readMember(FrameLibrary.Query receiver, String member) throws UnknownIdentifierException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readMember(receiver, member);
            }

            @Override
            public void writeMember(FrameLibrary.Query receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeMember(receiver, member, value);
            }

            @Override
            public void collectNames(FrameLibrary.Query receiver, Set<String> names) throws InteropException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.collectNames(receiver, names);
            }
        }
    }
}

