/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.truffle.api.SubstateTruffleOptions;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleInstalledCodeBridge;
import com.oracle.truffle.api.nodes.RootNode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class SubstrateOptimizedCallTarget
extends OptimizedCallTarget
implements SubstrateCompilableTruffleAST,
SubstrateInstalledCode,
OptimizedAssumptionDependency {
    protected long address;

    public SubstrateOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        super(sourceCallTarget, rootNode);
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return (SubstrateSpeculationLog)super.getSpeculationLog();
    }

    public SpeculationLog getCompilationSpeculationLog() {
        return this.getSpeculationLog();
    }

    @Override
    public void invalidate() {
        this.invalidate(null, null);
    }

    public CompilableTruffleAST getCompilable() {
        return this;
    }

    @Override
    public SubstrateInstalledCode getSubstrateInstalledCode() {
        return this;
    }

    public OptimizedAssumptionDependency getDependency() {
        return this;
    }

    public void invalidateCode() {
        CodeInfoTable.invalidateInstalledCode(this);
    }

    @Override
    public boolean isValid() {
        return this.address != 0L;
    }

    public boolean isValidLastTier() {
        long address0 = this.getAddress();
        return address0 != 0L && SubstrateOptimizedCallTarget.isValidLastTier0(address0);
    }

    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    private static boolean isValidLastTier0(long address0) {
        UntetheredCodeInfo info = CodeInfoTable.lookupCodeInfo((CodePointer)WordFactory.pointer((long)address0));
        if (info.isNonNull() && info.notEqual((ComparableWord)CodeInfoTable.getImageCodeInfo())) {
            return UntetheredCodeInfoAccess.getTier(info) == 2;
        }
        return false;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public long getCodeAddress() {
        return this.getAddress();
    }

    @Override
    public void setAddress(long address, ResolvedJavaMethod method) {
        this.address = address;
    }

    @Override
    public void clearAddress() {
        this.address = 0L;
    }

    public Object doInvoke(Object[] args) {
        long start = this.address;
        if (start != 0L) {
            CallBoundaryFunctionPointer target = (CallBoundaryFunctionPointer)WordFactory.pointer((long)start);
            return KnownIntrinsics.convertUnknownValue(target.invoke(this, args), Object.class);
        }
        return this.callBoundary(args);
    }

    public boolean cancelCompilation(CharSequence reason) {
        if (SubstateTruffleOptions.isMultiThreaded()) {
            return super.cancelCompilation(reason);
        }
        return false;
    }

    @Override
    public InstalledCode createInstalledCode() {
        return new SubstrateTruffleInstalledCodeBridge(this);
    }

    static interface CallBoundaryFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public Object invoke(OptimizedCallTarget var1, Object[] var2);
    }
}

