/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class JNIAccessibleMethodDescriptor {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String INITIALIZER_NAME = "<clinit>";
    private final String name;
    private final String signature;

    public static JNIAccessibleMethodDescriptor of(JavaMethod method) {
        return new JNIAccessibleMethodDescriptor(method.getName(), method.getSignature().toMethodDescriptor());
    }

    public static JNIAccessibleMethodDescriptor of(Executable method) {
        Class<Void> returnType;
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> type : method.getParameterTypes()) {
            sb.append(MetaUtil.toInternalName((String)type.getName()));
        }
        String name = method.getName();
        if (method instanceof Constructor) {
            name = CONSTRUCTOR_NAME;
            returnType = Void.TYPE;
        } else if (method instanceof Method) {
            returnType = ((Method)method).getReturnType();
        } else {
            throw VMError.shouldNotReachHere();
        }
        sb.append(')').append(MetaUtil.toInternalName((String)returnType.getName()));
        return new JNIAccessibleMethodDescriptor(name, sb.toString());
    }

    JNIAccessibleMethodDescriptor(String name, String signature) {
        assert (!signature.contains(".")) : "Malformed signature (needs to use '/' as package separator)";
        this.name = name;
        this.signature = signature;
    }

    public boolean isConstructor() {
        return this.name.equals(CONSTRUCTOR_NAME);
    }

    public boolean isClassInitializer() {
        return this.name.equals(INITIALIZER_NAME);
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNameAndSignature() {
        return this.name + this.signature;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JNIAccessibleMethodDescriptor) {
            JNIAccessibleMethodDescriptor other = (JNIAccessibleMethodDescriptor)obj;
            return other == this || this.name.equals(other.name) && this.signature.equals(other.signature);
        }
        return false;
    }

    boolean matchesIgnoreReturnType(ResolvedJavaMethod method) {
        if (!this.name.equals(method.getName())) {
            return false;
        }
        int position = 1;
        for (JavaType parameterType : method.getSignature().toParameterTypes(null)) {
            String paramInternal = parameterType.getName();
            if (!this.signature.startsWith(paramInternal, position)) {
                return false;
            }
            position += paramInternal.length();
        }
        return this.signature.startsWith(")", position);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.signature.hashCode();
    }
}

