/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.nodes.AnalysisArraysCopyOfNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionStoreNode;
import com.oracle.graal.pointsto.nodes.ConvertUnknownValueNode;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.jdk.ObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfWithExceptionNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.FarReturnNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadHeapBaseFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReturnAddressNode;
import com.oracle.svm.core.graal.nodes.ReadStackPointerNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.nodes.SubstrateReflectionGetCallerClassNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceAccessImpl;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.GraalEdgeUnsafePartition;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.snippets.Options;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DynamicPiNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.ObjectClone;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordCastNode;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import sun.misc.Unsafe;

public class SubstrateGraphBuilderPlugins {
    private static final String reflectionClass = JavaVersionUtil.JAVA_SPEC <= 8 ? "sun.reflect.Reflection" : "jdk.internal.reflect.Reflection";

    public static void registerInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutions, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, Replacements replacements, boolean analysis) {
        SubstrateGraphBuilderPlugins.registerSystemPlugins(metaAccess, plugins);
        SubstrateGraphBuilderPlugins.registerReflectionPlugins(plugins, replacements, analysis);
        SubstrateGraphBuilderPlugins.registerImageInfoPlugins(metaAccess, plugins);
        SubstrateGraphBuilderPlugins.registerProxyPlugins(snippetReflection, annotationSubstitutions, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerAtomicUpdaterPlugins(metaAccess, snippetReflection, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerObjectPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(metaAccess, plugins, snippetReflection, analysis);
        SubstrateGraphBuilderPlugins.registerKnownIntrinsicsPlugins(plugins, analysis);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerArraysPlugins(plugins, analysis);
        SubstrateGraphBuilderPlugins.registerArrayPlugins(plugins, snippetReflection, analysis);
        SubstrateGraphBuilderPlugins.registerClassPlugins(plugins, snippetReflection);
        SubstrateGraphBuilderPlugins.registerEdgesPlugins(metaAccess, plugins, analysis);
        SubstrateGraphBuilderPlugins.registerJFRThrowablePlugins(plugins, replacements);
        SubstrateGraphBuilderPlugins.registerJFREventTokenPlugins(plugins, replacements);
        SubstrateGraphBuilderPlugins.registerVMConfigurationPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerPlatformPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerSizeOfPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerReferenceAccessPlugins(plugins);
    }

    private static void registerSystemPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins) {
        if (SubstrateOptions.FoldSecurityManagerGetter.getValue().booleanValue()) {
            InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, System.class);
            proxyRegistration.register0("getSecurityManager", new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(null), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                    return true;
                }
            });
        }
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, reflectionClass, replacements);
        r.register0("getCallerClass", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (analysis) {
                    return false;
                }
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateReflectionGetCallerClassNode(b.getMetaAccess(), MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[0])));
                return true;
            }

            public boolean inlineOnly() {
                return true;
            }
        });
    }

    private static void registerImageInfoPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, ImageInfo.class);
        proxyRegistration.register0("inImageCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register0("inImageBuildtimeCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.FALSE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register0("inImageRuntimeCode", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph()));
                return true;
            }
        });
    }

    private static void registerProxyPlugins(final SnippetReflectionProvider snippetReflection, final AnnotationSubstitutionProcessor annotationSubstitutions, InvocationPlugins plugins, boolean analysis) {
        if (analysis) {
            InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, Proxy.class);
            proxyRegistration.register2("getProxyClass", ClassLoader.class, Class[].class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classLoaderNode, ValueNode interfacesNode) {
                    SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, snippetReflection, annotationSubstitutions, interfacesNode);
                    return false;
                }
            });
            proxyRegistration.register3("newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classLoaderNode, ValueNode interfacesNode, ValueNode invocationHandlerNode) {
                    SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, snippetReflection, annotationSubstitutions, interfacesNode);
                    return false;
                }
            });
        }
    }

    private static void interceptProxyInterfaces(GraphBuilderContext b, ResolvedJavaMethod targetMethod, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode interfacesNode) {
        Object[] interfaces = SubstrateGraphBuilderPlugins.extractClassArray(snippetReflection, annotationSubstitutions, interfacesNode);
        if (interfaces != null) {
            ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass((Class<?>[])interfaces);
            if (ImageSingletons.contains(FallbackFeature.class)) {
                ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).addAutoProxyInvoke(b.getMethod(), b.bci());
            }
            if (Options.DynamicProxyTracing.getValue().booleanValue()) {
                System.out.println("Successfully determined constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ". Registered proxy class for " + Arrays.toString(interfaces) + ".");
            }
        } else if (Options.DynamicProxyTracing.getValue().booleanValue() && !b.parsingIntrinsic()) {
            System.out.println("Could not determine constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ".");
        }
    }

    static Class<?>[] extractClassArray(SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode arrayNode) {
        return SubstrateGraphBuilderPlugins.extractClassArray(annotationSubstitutions, snippetReflection, arrayNode, false);
    }

    static Class<?>[] extractClassArray(AnnotationSubstitutionProcessor annotationSubstitutions, SnippetReflectionProvider snippetReflection, ValueNode arrayNode, boolean exact) {
        ValueNode originalArrayNode = SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(arrayNode);
        if (originalArrayNode.isConstant() && !exact) {
            Class[] classes = (Class[])snippetReflection.asObject(Class[].class, originalArrayNode.asJavaConstant());
            return classes == null ? null : (Stream.of(classes).allMatch(Objects::nonNull) ? classes : null);
        }
        if (originalArrayNode instanceof NewArrayNode) {
            NewArrayNode newArray = (NewArrayNode)originalArrayNode;
            ValueNode newArrayLengthNode = newArray.length();
            if (!newArrayLengthNode.isJavaConstant()) {
                return null;
            }
            assert (newArrayLengthNode.asJavaConstant().getJavaKind() == JavaKind.Int);
            ArrayList classList = new ArrayList();
            FixedNode successor = SubstrateGraphBuilderPlugins.unwrapNode(newArray.next());
            while (successor instanceof StoreIndexedNode) {
                StoreIndexedNode store = (StoreIndexedNode)successor;
                assert (SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(store.array()).equals(newArray));
                ValueNode valueNode = store.value();
                if (!valueNode.isConstant() || valueNode.isNullConstant()) {
                    classList = null;
                    break;
                }
                Class clazz = (Class)snippetReflection.asObject(Class.class, valueNode.asJavaConstant());
                classList.add(annotationSubstitutions.getTargetClass(clazz));
                successor = SubstrateGraphBuilderPlugins.unwrapNode(store.next());
            }
            int newArrayLength = newArrayLengthNode.asJavaConstant().asInt();
            return classList != null && classList.size() == newArrayLength ? classList.toArray(new Class[0]) : null;
        }
        return null;
    }

    private static ValueNode getDeoptProxyOriginalValue(ValueNode node) {
        ValueNode original = node;
        while (original instanceof DeoptProxyNode) {
            original = ((DeoptProxyNode)original).getOriginalNode();
        }
        return original;
    }

    private static FixedNode unwrapNode(FixedNode node) {
        FixedNode successor = node;
        while (successor instanceof FullInfopointNode || successor instanceof DeoptEntryNode) {
            assert (!(successor instanceof DeoptEntryNode) || ((HostedMethod)successor.graph().method()).isDeoptTarget());
            successor = ((FixedWithNextNode)successor).next();
        }
        return successor;
    }

    private static void registerAtomicUpdaterPlugins(final MetaAccessProvider metaAccess, final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration referenceUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicReferenceFieldUpdater.class);
        referenceUpdaterRegistration.register3("newUpdater", Class.class, Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode vclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration integerUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicIntegerFieldUpdater.class);
        integerUpdaterRegistration.register2("newUpdater", Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration longUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicLongFieldUpdater.class);
        longUpdaterRegistration.register2("newUpdater", Class.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(metaAccess, snippetReflection, analysis, tclassNode, fieldNameNode);
                return false;
            }
        });
    }

    private static void interceptUpdaterInvoke(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, boolean analysis, ValueNode tclassNode, ValueNode fieldNameNode) {
        if (analysis && tclassNode.isConstant() && fieldNameNode.isConstant()) {
            Class tclass = (Class)snippetReflection.asObject(Class.class, tclassNode.asJavaConstant());
            String fieldName = (String)snippetReflection.asObject(String.class, fieldNameNode.asJavaConstant());
            try {
                Field field = tclass.getDeclaredField(fieldName);
                RuntimeReflection.register((Class[])new Class[]{tclass});
                RuntimeReflection.register((Field[])new Field[]{field});
                SubstrateGraphBuilderPlugins.registerAsUnsafeAccessed(metaAccess, field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private static void registerAsUnsafeAccessed(MetaAccessProvider metaAccess, Field field) {
        AnalysisField targetField = (AnalysisField)metaAccess.lookupJavaField(field);
        targetField.registerAsAccessed();
        AnalysisUniverse universe = (AnalysisUniverse)((UniverseMetaAccess)metaAccess).getUniverse();
        targetField.registerAsUnsafeAccessed(universe);
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register1("clone", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, (ValueNode)SubstrateGraphBuilderPlugins.objectCloneNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[]{object}), b.parsingIntrinsic()).asNode());
                return true;
            }
        });
    }

    public static ObjectClone objectCloneNode(MacroNode.MacroParams macroParams, boolean parsingIntrinsic) {
        if (parsingIntrinsic) {
            return new SubstrateObjectCloneNode(macroParams);
        }
        return new ObjectCloneWithExceptionNode(macroParams);
    }

    private static void registerUnsafePlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection, final boolean analysis) {
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(metaAccess, new InvocationPlugins.Registration(plugins, Unsafe.class), snippetReflection, analysis);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe");
            SubstrateGraphBuilderPlugins.registerUnsafePlugins(metaAccess, r, snippetReflection, analysis);
            r.register3("objectFieldOffset", InvocationPlugin.Receiver.class, Class.class, String.class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode, ValueNode nameNode) {
                    if (classNode.isConstant() && nameNode.isConstant()) {
                        Class clazz = (Class)snippetReflection.asObject(Class.class, classNode.asJavaConstant());
                        String fieldName = (String)snippetReflection.asObject(String.class, nameNode.asJavaConstant());
                        try {
                            Field targetField = clazz.getDeclaredField(fieldName);
                            return SubstrateGraphBuilderPlugins.processObjectFieldOffset(b, targetField, analysis, metaAccess);
                        }
                        catch (NoClassDefFoundError | NoSuchFieldException e) {
                            return false;
                        }
                    }
                    return false;
                }
            });
            r.register3("allocateUninitializedArray", InvocationPlugin.Receiver.class, Class.class, Integer.TYPE, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode componentTypeNode, ValueNode lengthNode) {
                    ResolvedJavaType componentType;
                    BytecodeParser p = (BytecodeParser)b;
                    if (componentTypeNode.isJavaConstant() && componentTypeNode.asJavaConstant().isNonNull() && (componentType = b.getConstantReflection().asJavaType((Constant)componentTypeNode.asJavaConstant())).isPrimitive()) {
                        unsafe.get();
                        LogicNode lengthNegative = (LogicNode)b.append((ValueNode)IntegerLessThanNode.create((ValueNode)lengthNode, (ValueNode)ConstantNode.forInt((int)0), (NodeView)NodeView.DEFAULT));
                        p.emitBytecodeExceptionCheck(lengthNegative, false, BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION, new ValueNode[]{ConstantNode.forConstant((JavaConstant)snippetReflection.forObject((Object)"Negative length"), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph())});
                        b.addPush(JavaKind.Object, (ValueNode)new NewArrayNode(componentType, lengthNode, false));
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private static void registerUnsafePlugins(final MetaAccessProvider metaAccess, InvocationPlugins.Registration r, final SnippetReflectionProvider snippetReflection, final boolean analysis) {
        r.register2("objectFieldOffset", InvocationPlugin.Receiver.class, Field.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                if (fieldNode.isConstant()) {
                    Field targetField = (Field)snippetReflection.asObject(Field.class, fieldNode.asJavaConstant());
                    return SubstrateGraphBuilderPlugins.processObjectFieldOffset(b, targetField, analysis, metaAccess);
                }
                return false;
            }
        });
        r.register2("allocateInstance", InvocationPlugin.Receiver.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                ValueNode clazzNonNull = b.nullCheckedValue(clazz, DeoptimizationAction.None);
                b.add((ValueNode)new EnsureClassInitializedNode(clazzNonNull));
                b.addPush(JavaKind.Object, (ValueNode)new DynamicNewInstanceNode(clazzNonNull, true));
                return true;
            }
        });
    }

    private static boolean processObjectFieldOffset(GraphBuilderContext b, Field targetField, boolean analysis, MetaAccessProvider metaAccess) {
        if (targetField == null) {
            return false;
        }
        if (analysis) {
            SubstrateGraphBuilderPlugins.registerAsUnsafeAccessed(metaAccess, targetField);
            return false;
        }
        HostedMetaAccess hostedMetaAccess = (HostedMetaAccess)metaAccess;
        HostedField hostedField = hostedMetaAccess.lookupJavaField(targetField);
        if (hostedField.wrapped.isUnsafeAccessed()) {
            PrimitiveConstant offsetValue = JavaConstant.forLong((long)hostedField.getLocation());
            b.addPush(JavaKind.Long, (ValueNode)ConstantNode.forConstant((JavaConstant)offsetValue, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
            return true;
        }
        return false;
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Array.class).setAllowOverwrite(true);
        r.register2("newInstance", Class.class, int[].class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazzNode, ValueNode dimensionsNode) {
                if (analysis) {
                    ValueNode dimensionCountNode = GraphUtil.arrayLength((ValueNode)dimensionsNode, (ArrayLengthProvider.FindLengthMode)ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, (ConstantReflectionProvider)b.getConstantReflection());
                    if (clazzNode.isConstant() && !clazzNode.isNullConstant() && dimensionCountNode != null && dimensionCountNode.isConstant()) {
                        Class clazz = (Class)snippetReflection.asObject(Class.class, clazzNode.asJavaConstant());
                        int dimensionCount = dimensionCountNode.asJavaConstant().asInt();
                        AnalysisType type = (AnalysisType)b.getMetaAccess().lookupJavaType(clazz);
                        for (int i = 0; i < dimensionCount; ++i) {
                            type = type.getArrayClass();
                            type.registerAsAllocated((Node)clazzNode);
                        }
                    }
                }
                return false;
            }
        });
        r.register1("getLength", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode array) {
                return false;
            }
        });
    }

    private static void registerArraysPlugins(InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        r.register2("copyOf", Object[].class, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength) {
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength));
                } else {
                    GetClassNode originalArrayType = (GetClassNode)b.add((ValueNode)new GetClassNode(original.stamp(NodeView.DEFAULT), b.nullCheckedValue(original)));
                    ValueNode originalLength = b.add(ArrayLengthNode.create((ValueNode)original, (ConstantReflectionProvider)b.getConstantReflection()));
                    Stamp stamp = b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp().join(original.stamp(NodeView.DEFAULT));
                    b.addPush(JavaKind.Object, (ValueNode)new SubstrateArraysCopyOfWithExceptionNode(stamp, original, originalLength, newLength, (ValueNode)originalArrayType, b.bci()));
                }
                return true;
            }
        });
        r.register3("copyOf", Object[].class, Integer.TYPE, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength, ValueNode newArrayType) {
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength, newArrayType));
                } else {
                    Stamp stamp;
                    if (newArrayType.isConstant()) {
                        ResolvedJavaType newType = b.getConstantReflection().asJavaType(newArrayType.asConstant());
                        stamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)newType));
                    } else {
                        stamp = b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp();
                    }
                    ValueNode originalLength = b.add(ArrayLengthNode.create((ValueNode)original, (ConstantReflectionProvider)b.getConstantReflection()));
                    b.addPush(JavaKind.Object, (ValueNode)new SubstrateArraysCopyOfWithExceptionNode(stamp, original, originalLength, newLength, newArrayType, b.bci()));
                }
                return true;
            }
        });
    }

    private static void registerKnownIntrinsicsPlugins(InvocationPlugins plugins, final boolean analysis) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, KnownIntrinsics.class);
        r.register0("heapBase", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadHeapBaseFixedNode());
                return true;
            }
        });
        r.register1("readArrayLength", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array) {
                b.addPush(JavaKind.Int, (ValueNode)new ArrayLengthNode(array));
                return true;
            }
        });
        r.register1("readHub", Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                ValueNode nonNullObject = b.nullCheckedValue(object);
                b.addPush(JavaKind.Object, (ValueNode)new LoadHubNode(b.getStampProvider(), nonNullObject));
                return true;
            }
        });
        r.register1("nonNullPointer", Pointer.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Object, (ValueNode)new PiNode(object, (Stamp)SubstrateGraphBuilderPlugins.nonZeroWord()));
                return true;
            }
        });
        r.register0("readStackPointer", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new ReadStackPointerNode());
                return true;
            }
        });
        r.register0("readCallerStackPointer", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadCallerStackPointerNode());
                return true;
            }
        });
        r.register0("readReturnAddress", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadReturnAddressNode());
                return true;
            }
        });
        r.register4("farReturn", Object.class, Pointer.class, CodePointer.class, Boolean.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode sp, ValueNode ip, ValueNode fromMethodWithCalleeSavedRegisters) {
                if (!fromMethodWithCalleeSavedRegisters.isConstant()) {
                    throw b.bailout("parameter fromMethodWithCalleeSavedRegisters is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
                }
                b.add((ValueNode)new FarReturnNode(result, sp, ip, fromMethodWithCalleeSavedRegisters.asJavaConstant().asInt() != 0));
                return true;
            }
        });
        r.register0("testDeoptimize", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add((ValueNode)new TestDeoptimizeNode());
                return true;
            }
        });
        r.register0("isDeoptimizationTarget", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (b.getGraph().method() instanceof SharedMethod) {
                    SharedMethod method = (SharedMethod)b.getGraph().method();
                    if (method.isDeoptTarget()) {
                        b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)true));
                    } else {
                        b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
                    }
                } else {
                    b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)true));
                }
                return true;
            }
        });
        r.register2("convertUnknownValue", Object.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode typeNode) {
                ResolvedJavaType type = SubstrateGraphBuilderPlugins.typeValue(b.getConstantReflection(), b, targetMethod, typeNode, "type");
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)type);
                ObjectStamp stamp = StampFactory.object((TypeReference)typeRef);
                if (analysis) {
                    b.addPush(JavaKind.Object, (ValueNode)new ConvertUnknownValueNode(object, (Stamp)stamp));
                } else {
                    b.addPush(JavaKind.Object, PiNode.create((ValueNode)object, (Stamp)stamp));
                }
                return true;
            }
        });
        SubstrateGraphBuilderPlugins.registerCastExact(r);
    }

    public static void registerCastExact(InvocationPlugins.Registration r) {
        r.register2("castExact", Object.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                BytecodeParser p = (BytecodeParser)b;
                ValueNode nullCheckedClass = p.maybeEmitExplicitNullCheck(javaClass);
                LogicNode condition = (LogicNode)b.append((ValueNode)InstanceOfDynamicNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)nullCheckedClass, (ValueNode)object, (boolean)true, (boolean)true));
                AbstractBeginNode guard = p.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{object, nullCheckedClass});
                if (guard != null) {
                    b.addPush(JavaKind.Object, DynamicPiNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)object, (GuardingNode)guard, (ValueNode)nullCheckedClass, (boolean)true));
                } else {
                    b.addPush(JavaKind.Object, object);
                }
                return true;
            }
        });
    }

    private static void checkNeverInline(GraphBuilderContext b) {
        if (!DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)b.getMethod(), NeverInline.class)) {
            throw VMError.shouldNotReachHere("Accessing the stack pointer or instruction pointer of the caller frame is only safe and deterministic if the method is not inlined. Therefore, the method " + b.getMethod().format("%H.%n(%p)") + " must be annoated with @" + NeverInline.class.getSimpleName());
        }
    }

    private static IntegerStamp nonZeroWord() {
        return StampFactory.forUnsignedInteger((int)64, (long)1L, (long)-1L);
    }

    private static void registerStackValuePlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, StackValue.class);
        r.register1("get", Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                long size = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, sizeNode, "size");
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(1L, size, slotIdentity));
                return true;
            }
        });
        r.register1("get", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(1L, size, slotIdentity));
                return true;
            }
        });
        r.register2("get", Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode numElementsNode, ValueNode elementSizeNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                long elementSize = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, elementSizeNode, "elementSize");
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(numElements, elementSize, slotIdentity));
                return true;
            }
        });
        r.register2("get", Integer.TYPE, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode numElementsNode, ValueNode classNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                StackValueNode.StackSlotIdentity slotIdentity = new StackValueNode.StackSlotIdentity(b.getGraph().method().asStackTraceElement(b.bci()).toString());
                b.addPush(JavaKind.Object, (ValueNode)new StackValueNode(numElements, size, slotIdentity));
                return true;
            }
        });
    }

    private static ResolvedJavaType typeValue(ConstantReflectionProvider constantReflection, GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode typeNode, String name) {
        if (!typeNode.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        ResolvedJavaType type = constantReflection.asJavaType(typeNode.asConstant());
        if (type == null) {
            throw b.bailout("parameter " + name + " is null for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        return type;
    }

    private static void registerClassPlugins(InvocationPlugins plugins, SnippetReflectionProvider snippetReflection) {
        SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(plugins, snippetReflection);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class).setAllowOverwrite(true);
        r.register2("isAssignableFrom", InvocationPlugin.Receiver.class, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver type, ValueNode otherType) {
                return false;
            }
        });
    }

    public static void registerClassDesiredAssertionStatusPlugin(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register1("desiredAssertionStatus", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constantReceiver = receiver.get().asJavaConstant();
                if (constantReceiver != null && constantReceiver.isNonNull()) {
                    String className;
                    Object clazz = snippetReflection.asObject(Object.class, constantReceiver);
                    if (clazz instanceof Class) {
                        className = ((Class)clazz).getName();
                    } else if (clazz instanceof DynamicHub) {
                        className = ((DynamicHub)clazz).getName();
                    } else {
                        throw VMError.shouldNotReachHere("Unexpected class object: " + clazz);
                    }
                    b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((!SubstrateOptions.getRuntimeAssertionsForClass(className) ? 1 : 0) != 0));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerEdgesPlugins(final MetaAccessProvider metaAccess, InvocationPlugins plugins, boolean analysis) {
        if (analysis) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Edges.class).setAllowOverwrite(true);
            for (final Class c : new Class[]{Node.class, NodeList.class}) {
                r.register2("get" + c.getSimpleName() + "Unsafe", Node.class, Long.TYPE, new InvocationPlugin(){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset) {
                        b.addPush(JavaKind.Object, (ValueNode)new AnalysisUnsafePartitionLoadNode(node, offset, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), metaAccess.lookupJavaType(c)));
                        return true;
                    }
                });
                r.register3("put" + c.getSimpleName() + "Unsafe", Node.class, Long.TYPE, (Type)c, new InvocationPlugin(){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset, ValueNode value) {
                        b.add((ValueNode)new AnalysisUnsafePartitionStoreNode(node, offset, value, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), metaAccess.lookupJavaType(c)));
                        return true;
                    }
                });
            }
        }
    }

    protected static long longValue(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode node, String name) {
        if (!node.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()));
        }
        return node.asJavaConstant().asLong();
    }

    private static void registerJFRThrowablePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "oracle.jrockit.jfr.jdkevents.ThrowableTracer", replacements).setAllowOverwrite(true);
        r.register2("traceError", Error.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                return true;
            }
        });
        r.register2("traceThrowable", Throwable.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode throwable, ValueNode message) {
                return true;
            }
        });
    }

    private static void registerJFREventTokenPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.jrockit.jfr.EventToken", replacements);
        r.register1("isEnabled", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get();
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
                return true;
            }
        });
    }

    private static void registerVMConfigurationPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ImageSingletons.class);
        r.register1("contains", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = ImageSingletons.contains((Class)key);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result)));
                return true;
            }
        });
        r.register1("lookup", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                Object result = ImageSingletons.lookup((Class)key);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject(result), (MetaAccessProvider)b.getMetaAccess())));
                return true;
            }
        });
    }

    private static void registerPlatformPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Platform.class);
        r.register1("includedIn", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode) {
                Class platform = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = Platform.includedIn((Class)platform);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result)));
                return true;
            }
        });
    }

    private static void registerSizeOfPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, SizeOf.class);
        r.register1("get", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int result = SizeOf.get((Class)clazz);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Int, (ValueNode)ConstantNode.forInt((int)result)));
                return true;
            }
        });
        r.register1("unsigned", Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = (Class)SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                UnsignedWord result = SizeOf.unsigned((Class)clazz);
                b.notifyReplacedCall(targetMethod, (ConstantNode)b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject((Object)result), (MetaAccessProvider)b.getMetaAccess())));
                return true;
            }
        });
    }

    private static void registerReferenceAccessPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ReferenceAccessImpl.class);
        r.register2("getCompressedRepresentation", InvocationPlugin.Receiver.class, Object.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode objectNode) {
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    SubstrateCompressionNode compressedObj = SubstrateCompressionNode.compress(objectNode, (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class));
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    ValueNode compressedValue = b.add((ValueNode)WordCastNode.narrowOopToUntrackedWord((ValueNode)compressedObj, (JavaKind)compressedIntKind));
                    b.addPush(JavaKind.Object, ZeroExtendNode.convertUnsigned((ValueNode)compressedValue, (Stamp)FrameAccess.getWordStamp(), (NodeView)NodeView.DEFAULT));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.objectToUntrackedPointer((ValueNode)objectNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
        r.register2("uncompressReference", InvocationPlugin.Receiver.class, UnsignedWord.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode wordNode) {
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    CompressEncoding encoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    NarrowOopStamp compressedStamp = (NarrowOopStamp)SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)StampFactory.object(), encoding);
                    ValueNode narrowNode = b.add(NarrowNode.convertUnsigned((ValueNode)wordNode, (Stamp)StampFactory.forKind((JavaKind)compressedIntKind), (NodeView)NodeView.DEFAULT));
                    WordCastNode compressedObj = (WordCastNode)b.add((ValueNode)WordCastNode.wordToNarrowObject((ValueNode)narrowNode, (NarrowOopStamp)compressedStamp));
                    b.addPush(JavaKind.Object, (ValueNode)SubstrateCompressionNode.uncompress((ValueNode)compressedObj, encoding));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.wordToObject((ValueNode)wordNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
    }

    private static <T> T constantObjectParameter(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, int parameterIndex, Class<T> declaredType, ValueNode classNode) {
        SubstrateGraphBuilderPlugins.checkParameterUsage(classNode.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
        Object result = snippetReflection.asObject(declaredType, classNode.asJavaConstant());
        SubstrateGraphBuilderPlugins.checkParameterUsage(result != null, b, targetMethod, parameterIndex, "parameter is null");
        return (T)result;
    }

    private static void checkParameterUsage(boolean condition, GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, String message) {
        Local variable;
        if (condition) {
            return;
        }
        String parameterName = null;
        LocalVariableTable variableTable = targetMethod.getLocalVariableTable();
        if (variableTable != null && (variable = variableTable.getLocal(parameterIndex, 0)) != null) {
            parameterName = variable.getName();
        }
        if (parameterName == null) {
            parameterName = String.valueOf(parameterIndex);
        }
        throw UserError.abort(message + ": parameter " + parameterName + " of call to " + targetMethod.format("%H.%n(%p)") + " in " + b.getMethod().asStackTraceElement(b.bci()), new Object[0]);
    }
}

