/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.image.sources.ApplicationSourceCache;
import com.oracle.svm.hosted.image.sources.GraalVMSourceCache;
import com.oracle.svm.hosted.image.sources.JDKSourceCache;
import com.oracle.svm.hosted.image.sources.SourceCacheType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class SourceCache {
    protected static final List<Path> classPathEntries = new ArrayList<Path>();
    protected static final List<String> sourcePathEntries = new ArrayList<String>();
    protected List<Path> srcRoots;
    private final Path basePath = SubstrateOptions.getDebugInfoSourceCacheRoot().resolve(this.getType().getSubdir());

    protected SourceCache() {
        this.srcRoots = new ArrayList<Path>();
        this.initSrcRoots();
    }

    protected void initSrcRoots() {
        for (Path classPathEntry : classPathEntries) {
            this.trySourceRoot(classPathEntry, true);
        }
        for (String sourcePathEntry : sourcePathEntries) {
            this.trySourceRoot(sourcePathEntry, false);
        }
    }

    protected abstract void trySourceRoot(Path var1, boolean var2);

    protected abstract SourceCacheType getType();

    private void trySourceRoot(String sourceRoot, boolean fromClassPath) {
        this.trySourceRoot(Paths.get(sourceRoot, new String[0]), fromClassPath);
    }

    public Path resolve(Path filePath) {
        File cachedFile = this.findCandidate(filePath);
        if (cachedFile == null) {
            return this.tryCacheFile(filePath);
        }
        return this.checkCacheFile(filePath);
    }

    public File findCandidate(Path filePath) {
        File file = this.cachedFile(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public Path tryCacheFile(Path filePath) {
        for (Path root : this.srcRoots) {
            Path targetPath = this.cachedPath(filePath);
            Path sourcePath = this.extendPath(root, filePath);
            try {
                if (!SourceCache.checkSourcePath(sourcePath)) continue;
                SourceCache.ensureTargetDirs(targetPath.getParent());
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return filePath;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public Path checkCacheFile(Path filePath) {
        Path targetPath = this.cachedPath(filePath);
        for (Path root : this.srcRoots) {
            Path sourcePath = this.extendPath(root, filePath);
            try {
                if (!SourceCache.checkSourcePath(sourcePath)) continue;
                FileTime sourceTime = Files.getLastModifiedTime(sourcePath, new LinkOption[0]);
                FileTime destTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
                if (destTime.compareTo(sourceTime) < 0) {
                    try {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        targetPath.toFile().delete();
                        return null;
                    }
                }
                return filePath;
            }
            catch (IOException e) {
                targetPath.toFile().delete();
                return this.tryCacheFile(filePath);
            }
        }
        targetPath.toFile().delete();
        return null;
    }

    public static SourceCache createSourceCache(SourceCacheType type) {
        SourceCache sourceCache = null;
        switch (type) {
            case JDK: {
                sourceCache = new JDKSourceCache();
                break;
            }
            case GRAALVM: {
                sourceCache = new GraalVMSourceCache();
                break;
            }
            case APPLICATION: {
                sourceCache = new ApplicationSourceCache();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return sourceCache;
    }

    protected Path extendPath(Path root, Path filePath) {
        String newSeparator;
        String filePathString = filePath.toString();
        String fileSeparator = filePath.getFileSystem().getSeparator();
        if (!fileSeparator.equals(newSeparator = root.getFileSystem().getSeparator())) {
            filePathString = filePathString.replace(fileSeparator, newSeparator);
        }
        return root.resolve(filePathString);
    }

    protected Path cachedPath(Path candidate) {
        return this.basePath.resolve(candidate);
    }

    protected File cachedFile(Path candidate) {
        return this.cachedPath(candidate).toFile();
    }

    private static boolean checkSourcePath(Path sourcePath) {
        return Files.isRegularFile(sourcePath, new LinkOption[0]);
    }

    private static void ensureTargetDirs(Path targetDir) {
        File targetFile;
        if (targetDir != null && !(targetFile = targetDir.toFile()).exists()) {
            targetDir.toFile().mkdirs();
        }
    }

    private static void addClassPathEntry(Path path) {
        classPathEntries.add(path);
    }

    private static void addSourcePathEntry(String path) {
        sourcePathEntries.add(path);
    }

    @AutomaticFeature
    public static class SourceCacheFeature
    implements Feature {
        public void afterAnalysis(Feature.AfterAnalysisAccess access) {
            FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
            ImageClassLoader loader = accessImpl.getImageClassLoader();
            for (Path entry : loader.classpath()) {
                SourceCache.addClassPathEntry(entry);
            }
            if (SubstrateOptions.DebugInfoSourceSearchPath.getValue() != null) {
                for (String searchPathEntry : OptionUtils.flatten(",", SubstrateOptions.DebugInfoSourceSearchPath.getValue())) {
                    SourceCache.addSourcePathEntry(searchPathEntry);
                }
            }
        }
    }
}

