/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldSinkTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InitialReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnknownTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.ToJson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.nativeimage.hosted.Feature;

class PointsToJsonObject
extends ToJson.JsonObject {
    private final Feature.OnAnalysisExitAccess access;
    private boolean built = false;
    private final BitSet known = new BitSet(){
        private static final long serialVersionUID = 1L;
    };
    private final List<AnalysisWrapper> flows = new InflatableArrayList<AnalysisWrapper>();
    private static final Collection<String> REQUIRE_ENCLOSING_METHOD_INPUT = Arrays.asList("callsite", "alloc");
    private static final Collection<String> REQUIRE_ENCLOSING_METHOD_ID = Arrays.asList("formalParam", "formalReturn", "callsite");

    PointsToJsonObject(Feature.OnAnalysisExitAccess access) {
        this.access = access;
    }

    @Override
    Stream<String> getNames() {
        return Arrays.asList("type-flows").stream();
    }

    @Override
    ToJson.JsonValue getValue(String name) {
        return ToJson.JsonArray.get(PointsToJsonObject.transform(this.flows.stream()));
    }

    private static Stream<ToJson.JsonValue> transform(Stream<AnalysisWrapper> flows) {
        return flows.filter(f -> f != null).map(FlowJsonObject::new);
    }

    @Override
    protected void build() {
        if (this.built) {
            return;
        }
        FeatureImpl.OnAnalysisExitAccessImpl config = (FeatureImpl.OnAnalysisExitAccessImpl)this.access;
        BigBang bigbang = config.getBigBang();
        this.serializeMethods(bigbang);
        this.connectFlowsToEnclosingMethods(bigbang);
        this.matchInputsAndUses();
        this.built = true;
    }

    private void serializeMethods(BigBang bb) {
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            this.serializeMethod(new AnalysisWrapper(method));
        }
    }

    private void serializeMethod(AnalysisWrapper methodWrapper) {
        assert (!this.known.get(methodWrapper.id));
        this.known.set(methodWrapper.id);
        this.flows.set(methodWrapper.id, methodWrapper);
        if (methodWrapper.flowsGraph == null) {
            return;
        }
        for (TypeFlow flow : methodWrapper.flowsGraph.linearizedGraph) {
            if (flow == null) continue;
            this.serializeTypeFlow(flow);
        }
    }

    private void serializeTypeFlow(TypeFlow<?> flow) {
        int flowId = flow.id();
        if (this.known.get(flowId)) {
            return;
        }
        AnalysisWrapper flowWrapper = new AnalysisWrapper(flowId);
        flowWrapper.flowType = PointsToJsonObject.serializeTypeFlowName(flow);
        flowWrapper.codeLocation = PointsToJsonObject.getCodeLocation(flow);
        this.known.set(flowWrapper.id);
        this.flows.set(flowWrapper.id, flowWrapper);
        if (flow instanceof InvokeTypeFlow) {
            Collection callees = ((InvokeTypeFlow)flow).getCallees();
            flowWrapper.calleeNames = new ArrayList();
            for (AnalysisMethod callee : callees) {
                int calleeId = callee.getTypeFlow().id();
                PointsToJsonObject.addUnique(flowWrapper.uses, calleeId);
                flowWrapper.calleeNames.add(callee.getQualifiedName());
            }
        } else if (flow instanceof NewInstanceTypeFlow || flow instanceof DynamicNewInstanceTypeFlow) {
            flowWrapper.types = PointsToJsonObject.serializeTypeState(flow.getState());
        } else if (flow instanceof LoadFieldTypeFlow.LoadInstanceFieldTypeFlow || flow instanceof LoadFieldTypeFlow.LoadStaticFieldTypeFlow) {
            LoadFieldTypeFlow loadFlow = (LoadFieldTypeFlow)flow;
            flowWrapper.qualifiedName = PointsToJsonObject.fieldName(loadFlow.field());
        } else if (flow instanceof StoreFieldTypeFlow.StoreInstanceFieldTypeFlow || flow instanceof StoreFieldTypeFlow.StoreStaticFieldTypeFlow) {
            TypeState typeState = flow.getState();
            flowWrapper.types = PointsToJsonObject.serializeTypeState(typeState);
            StoreFieldTypeFlow storeFlow = (StoreFieldTypeFlow)flow;
            flowWrapper.qualifiedName = PointsToJsonObject.fieldName(storeFlow.field());
        } else if (flow instanceof FieldTypeFlow) {
            FieldTypeFlow fieldFlow = (FieldTypeFlow)flow;
            flowWrapper.qualifiedName = PointsToJsonObject.fieldName((AnalysisField)fieldFlow.getSource());
        } else if (flow instanceof FormalReceiverTypeFlow) {
            flowWrapper.qualifiedName = flow.getDeclaredType().toJavaName();
        }
        this.collectInputs(flow, flowWrapper.inputs);
        this.collectUses(flow, flowWrapper.uses);
    }

    private static String serializeTypeFlowName(TypeFlow<?> flow) {
        String name = DashboardTypeFlowNames.get(flow);
        if (name == null) {
            return "unhandled";
        }
        return name;
    }

    private void connectFlowsToEnclosingMethods(BigBang bb) {
        for (AnalysisMethod method : bb.getUniverse().getMethods()) {
            AnalysisWrapper methodWrapper = new AnalysisWrapper(method);
            if (methodWrapper.flowsGraph == null) continue;
            for (TypeFlow flow : methodWrapper.flowsGraph.linearizedGraph) {
                if (flow == null) continue;
                this.connectFlowToEnclosingMethod(flow.id(), methodWrapper.id);
            }
        }
    }

    private void connectFlowToEnclosingMethod(int flowId, int parentId) {
        AnalysisWrapper parent = this.flows.get(parentId);
        AnalysisWrapper flowWrapper = this.flows.get(flowId);
        assert (flowWrapper != null);
        if (parent == null) {
            return;
        }
        if (REQUIRE_ENCLOSING_METHOD_INPUT.contains(flowWrapper.flowType)) {
            PointsToJsonObject.addUnique(flowWrapper.inputs, parent.id);
            PointsToJsonObject.addUnique(parent.uses, flowWrapper.id);
        }
        if (REQUIRE_ENCLOSING_METHOD_ID.contains(flowWrapper.flowType)) {
            flowWrapper.enclosingMethod = parent.id;
        }
    }

    private static String getCodeLocation(TypeFlow<?> flow) {
        if (flow.getSource() instanceof BytecodePosition) {
            return flow.getSource().toString();
        }
        return null;
    }

    private void collectInputs(TypeFlow<?> flow, Set<Integer> targetList) {
        for (Object input : flow.getInputs()) {
            TypeFlow inputFlow = (TypeFlow)input;
            PointsToJsonObject.addUnique(targetList, inputFlow.id());
            this.serializeTypeFlow(inputFlow);
        }
        for (Object observee : flow.getObservees()) {
            TypeFlow observeeFlow = (TypeFlow)observee;
            PointsToJsonObject.addUnique(targetList, observeeFlow.id());
            this.serializeTypeFlow(observeeFlow);
        }
    }

    private void collectUses(TypeFlow<?> flow, Set<Integer> targetList) {
        for (Object use : flow.getUses()) {
            TypeFlow useFlow = (TypeFlow)use;
            PointsToJsonObject.addUnique(targetList, useFlow.id());
            this.serializeTypeFlow(useFlow);
        }
        for (Object observer : flow.getObservers()) {
            TypeFlow observerFlow = (TypeFlow)observer;
            PointsToJsonObject.addUnique(targetList, observerFlow.id());
            this.serializeTypeFlow(observerFlow);
        }
    }

    private static <T> void addUnique(Set<T> list, T element) {
        list.add(element);
    }

    private static ArrayList<String> serializeTypeState(TypeState typeState) {
        ArrayList<String> types = new ArrayList<String>();
        if (typeState.getClass().getSimpleName().equals("UnknownTypeState")) {
            return types;
        }
        for (AnalysisType type : typeState.types()) {
            types.add(type.toJavaName());
        }
        return types;
    }

    private static String fieldName(AnalysisField field) {
        return field.format("%H.%n");
    }

    private void matchInputsAndUses() {
        for (AnalysisWrapper node : this.flows) {
            if (node == null) continue;
            this.matchFromTo(node, true);
            this.matchFromTo(node, false);
        }
    }

    private void matchFromTo(AnalysisWrapper fromNode, boolean inputs) {
        Set<Integer> fromIds = inputs ? fromNode.inputs : fromNode.uses;
        for (Integer fromId : fromIds) {
            AnalysisWrapper referencedNode = this.flows.get(fromId);
            if (referencedNode == null) continue;
            Set<Integer> usesList = inputs ? referencedNode.uses : referencedNode.inputs;
            PointsToJsonObject.addUnique(usesList, fromNode.id);
        }
    }

    private static class AnalysisWrapper {
        public final int id;
        public String qualifiedName = null;
        public String qualifiedNameSimpleParams = null;
        public MethodFlowsGraph flowsGraph = null;
        public String flowType = null;
        public Set<Integer> inputs = new HashSet<Integer>();
        public Set<Integer> uses = new HashSet<Integer>();
        public String codeLocation = null;
        public ArrayList<String> calleeNames = null;
        public ArrayList<String> types = null;
        public Integer enclosingMethod = null;
        private static final String METHOD_FLOW = "method";

        AnalysisWrapper(AnalysisMethod method) {
            this(method.getTypeFlow().id());
            this.flowType = METHOD_FLOW;
            this.qualifiedName = method.getQualifiedName();
            this.qualifiedNameSimpleParams = method.format("%H.%n(%p)");
            this.flowsGraph = null;
            Collection flows = method.getTypeFlow().getFlows();
            if (!flows.isEmpty()) {
                VMError.guarantee(flows.size() == 1, "Expect to have a single type flow graph.");
                this.flowsGraph = (MethodFlowsGraph)flows.iterator().next();
            }
        }

        AnalysisWrapper(int id) {
            this.id = id;
        }
    }

    public static class DashboardTypeFlowNames {
        private static final HashMap<Class<?>, String> names = new HashMap<Class<?>, String>(){
            private static final long serialVersionUID = 1L;
        };

        public static String get(TypeFlow<?> flow) {
            Class clas = flow instanceof InvokeTypeFlow ? InvokeTypeFlow.class : flow.getClass();
            return names.get(clas);
        }

        static {
            names.put(FormalReturnTypeFlow.class, "formalReturn");
            names.put(ActualReturnTypeFlow.class, "actualReturn");
            names.put(FormalParamTypeFlow.class, "formalParam");
            names.put(ActualParameterTypeFlow.class, "actualParameter");
            names.put(InvokeTypeFlow.class, "callsite");
            names.put(NewInstanceTypeFlow.class, "alloc");
            names.put(DynamicNewInstanceTypeFlow.class, "dynamicAlloc");
            names.put(LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class, "instanceFieldLoad");
            names.put(LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class, "staticFieldLoad");
            names.put(StoreFieldTypeFlow.StoreInstanceFieldTypeFlow.class, "instanceFieldStore");
            names.put(StoreFieldTypeFlow.StoreStaticFieldTypeFlow.class, "staticFieldStore");
            names.put(FieldTypeFlow.class, "field");
            names.put(OffsetLoadTypeFlow.AtomicReadTypeFlow.class, "atomicRead");
            names.put(OffsetStoreTypeFlow.AtomicWriteTypeFlow.class, "atomicWrite");
            names.put(NullCheckTypeFlow.class, "nullCheck");
            names.put(ArrayCopyTypeFlow.class, "arrayCopy");
            names.put(BoxTypeFlow.class, "box");
            names.put(CloneTypeFlow.class, "clone");
            names.put(OffsetStoreTypeFlow.CompareAndSwapTypeFlow.class, "compareAndSwap");
            names.put(FilterTypeFlow.class, "filter");
            names.put(FormalReceiverTypeFlow.class, "formalReceiver");
            names.put(InstanceOfTypeFlow.class, "instanceOf");
            names.put(OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, "loadIndexed");
            names.put(MergeTypeFlow.class, "merge");
            names.put(MonitorEnterTypeFlow.class, "monitorEnter");
            names.put(ProxyTypeFlow.class, "proxy");
            names.put(SourceTypeFlow.class, "source");
            names.put(OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, "storeIndexed");
            names.put(OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, "unsafeLoad");
            names.put(OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, "unsafeStore");
            names.put(OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow.class, "unsafeLoad");
            names.put(OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow.class, "unsafeStore");
            names.put(AllInstantiatedTypeFlow.class, "allInstantiated");
            names.put(AllSynchronizedTypeFlow.class, "allSynchronized");
            names.put(ArrayElementsTypeFlow.class, "arrayElements");
            names.put(FieldFilterTypeFlow.class, "fieldFilter");
            names.put(FieldSinkTypeFlow.class, "fieldSink");
            names.put(InitialParamTypeFlow.class, "initialParam");
            names.put(InitialReceiverTypeFlow.class, "initialReceiver");
            names.put(UnknownTypeFlow.class, "unknown");
        }
    }

    private static class InfoJsonObject
    extends ToJson.JsonObject {
        private final AnalysisWrapper flow;
        private static final String QUALIFIED_NAME = "qualifiedName";
        private static final String QUALIFIED_NAME_SIMPLE_PARAMS = "qualifiedNameSimpleParams";
        private static final String INPUTS = "inputs";
        private static final String USES = "uses";
        private static final String CODE_LOCATION = "codeLocation";
        private static final String CALLEE_NAMES = "calleeNames";
        private static final String TYPES = "types";
        private static final String ENCLOSING_METHOD = "enclosingMethod";
        private static final List<String> NAMES = Arrays.asList("qualifiedName", "qualifiedNameSimpleParams", "inputs", "uses", "codeLocation", "calleeNames", "types", "enclosingMethod");

        InfoJsonObject(AnalysisWrapper flow) {
            this.flow = flow;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            switch (name) {
                case "qualifiedName": {
                    return ToJson.JsonString.get(this.flow.qualifiedName);
                }
                case "qualifiedNameSimpleParams": {
                    return ToJson.JsonString.get(this.flow.qualifiedNameSimpleParams);
                }
                case "inputs": {
                    return ToJson.JsonArray.get(this.flow.inputs.stream().map(ToJson.JsonNumber::get));
                }
                case "uses": {
                    return ToJson.JsonArray.get(this.flow.uses.stream().map(ToJson.JsonNumber::get));
                }
                case "codeLocation": {
                    return ToJson.JsonString.get(this.flow.codeLocation);
                }
                case "calleeNames": {
                    return this.flow.calleeNames == null ? null : ToJson.JsonArray.get(this.flow.calleeNames.stream().map(ToJson.JsonString::get));
                }
                case "types": {
                    return this.flow.types == null ? null : ToJson.JsonArray.get(this.flow.types.stream().map(ToJson.JsonString::get));
                }
                case "enclosingMethod": {
                    return ToJson.JsonNumber.get(this.flow.enclosingMethod);
                }
            }
            return null;
        }
    }

    private static class FlowJsonObject
    extends ToJson.JsonObject {
        private final AnalysisWrapper flow;
        private static final List<String> NAMES = Arrays.asList("id", "flowType", "info");

        FlowJsonObject(AnalysisWrapper flow) {
            this.flow = flow;
        }

        @Override
        Stream<String> getNames() {
            return NAMES.stream();
        }

        @Override
        ToJson.JsonValue getValue(String name) {
            return name == NAMES.get(0) ? ToJson.JsonNumber.get(this.flow.id) : (name == NAMES.get(1) ? ToJson.JsonString.get(this.flow.flowType) : new InfoJsonObject(this.flow));
        }
    }

    static class InflatableArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;

        InflatableArrayList() {
        }

        @Override
        public T set(int index, T element) {
            if (this.size() <= index) {
                this.addAll(Collections.nCopies(index - this.size(), null));
                this.add(element);
                return null;
            }
            return super.set(index, element);
        }
    }
}

