/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.dashboard.CodeBreakdownJsonObject;
import com.oracle.svm.hosted.dashboard.DashboardOptions;
import com.oracle.svm.hosted.dashboard.HeapBreakdownJsonObject;
import com.oracle.svm.hosted.dashboard.PointsToJsonObject;
import com.oracle.svm.hosted.dashboard.ToJson;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class DashboardDumpFeature
implements Feature {
    private final ToJson dumper = DashboardDumpFeature.isSane() ? DashboardDumpFeature.prepareDumper() : null;

    private static boolean isHeapBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardHeap.getValue() != false;
    }

    private static boolean isPointsToDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardPointsTo.getValue() != false;
    }

    private static boolean isCodeBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardCode.getValue() != false;
    }

    private static ToJson prepareDumper() {
        try {
            Path file = new File(DashboardOptions.DashboardDump.getValue()).getAbsoluteFile().toPath();
            Path folder = file.getParent();
            Path fileName = file.getFileName();
            if (folder == null || fileName == null) {
                throw new IllegalArgumentException("File parameter must be a file, got: " + file);
            }
            Files.createDirectories(folder, new FileAttribute[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            System.out.println("Printing Dashboard dump output to " + file);
            return new ToJson(new PrintWriter(new FileWriter(file.toFile())), DashboardOptions.DashboardPretty.getValue());
        }
        catch (Exception e) {
            System.out.println("Dashboard Dumper initialization failed with: " + e);
            return null;
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return DashboardDumpFeature.isSane();
    }

    private static boolean isSane() {
        return DashboardOptions.DashboardDump.getValue() != null && (DashboardDumpFeature.isHeapBreakdownDumped() || DashboardDumpFeature.isPointsToDumped() || DashboardDumpFeature.isCodeBreakdownDumped());
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        if (this.dumper != null && DashboardDumpFeature.isPointsToDumped()) {
            this.dumper.put("points-to", new PointsToJsonObject(access));
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (this.dumper != null && DashboardDumpFeature.isCodeBreakdownDumped()) {
            this.dumper.put("code-breakdown", new CodeBreakdownJsonObject(access));
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        if (this.dumper != null && DashboardDumpFeature.isHeapBreakdownDumped()) {
            this.dumper.put("heap-breakdown", new HeapBreakdownJsonObject(access));
        }
    }

    public void cleanup() {
        if (this.dumper != null) {
            try {
                System.out.println("Print of Dashboard dump output ended.");
                this.dumper.close();
            }
            catch (Exception ex) {
                Logger.getLogger(DashboardDumpFeature.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

