/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;

public class HybridLayoutSupport {
    public boolean isHybrid(ResolvedJavaType clazz) {
        return clazz.isAnnotationPresent(Hybrid.class);
    }

    public boolean isHybridField(ResolvedJavaField field) {
        return field.getAnnotation(Hybrid.Array.class) != null || field.getAnnotation(Hybrid.Bitset.class) != null;
    }

    public Pair<HostedField, HostedField> findHybridFields(HostedInstanceClass hybridClass) {
        assert (hybridClass.getAnnotation(Hybrid.class) != null);
        assert (Modifier.isFinal(hybridClass.getModifiers()));
        HostedField foundArrayField = null;
        HostedField foundBitsetField = null;
        for (HostedField field : hybridClass.getInstanceFields(true)) {
            if (field.getAnnotation(Hybrid.Array.class) != null) {
                assert (foundArrayField == null) : "must have exactly one hybrid array field";
                assert (field.getType().isArray());
                foundArrayField = field;
            }
            if (field.getAnnotation(Hybrid.Bitset.class) == null) continue;
            assert (foundBitsetField == null) : "must have at most one hybrid bitset field";
            assert (!field.getType().isArray());
            foundBitsetField = field;
        }
        assert (foundArrayField != null) : "must have exactly one hybrid array field";
        return Pair.create(foundArrayField, foundBitsetField);
    }
}

