/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.LocationIdentity;

public class SnippetRuntime {
    public static final SubstrateForeignCallDescriptor UNSUPPORTED_FEATURE = SnippetRuntime.findForeignCall(SnippetRuntime.class, "unsupportedFeature", true, LocationIdentity.any());
    public static final SubstrateForeignCallDescriptor REGISTER_FINALIZER = SnippetRuntime.findForeignCall(SnippetRuntime.class, "registerFinalizer", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_SIN = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature.getName(), Math.class, "sin", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_COS = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature.getName(), Math.class, "cos", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_TAN = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature.getName(), Math.class, "tan", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_LOG = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature.getName(), Math.class, "log", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_LOG10 = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature.getName(), Math.class, "log10", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_EXP = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature.getName(), Math.class, "exp", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_POW = SnippetRuntime.findForeignCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature.getName(), Math.class, "pow", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor OBJECT_CLONE = SnippetRuntime.findForeignCall(Object.class, "clone", false, LocationIdentity.any());

    public static List<SubstrateForeignCallDescriptor> getRuntimeCalls() {
        ArrayList<SubstrateForeignCallDescriptor> result = new ArrayList<SubstrateForeignCallDescriptor>();
        try {
            for (Field field : SnippetRuntime.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != SubstrateForeignCallDescriptor.class) continue;
                result.add((SubstrateForeignCallDescriptor)((Object)field.get(null)));
            }
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex);
        }
        return result;
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(methodName, declaringClass, methodName, isReexecutable, killedLocations);
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, boolean isReexecutable, boolean needsDebugInfo, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(methodName, declaringClass, methodName, isReexecutable, needsDebugInfo, killedLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(descriptorName, declaringClass, methodName, isReexecutable, true, killedLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, boolean needsDebugInfo, LocationIdentity ... killedLocations) {
        Method foundMethod = null;
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            assert (foundMethod == null) : "found more than one method " + declaringClass.getName() + "." + methodName;
            foundMethod = method;
        }
        assert (foundMethod != null) : "did not find method " + declaringClass.getName() + "." + methodName;
        VMError.guarantee(declaringClass.getName().startsWith("java.lang") || DirectAnnotationAccess.isAnnotationPresent(foundMethod, SubstrateForeignCallTarget.class), "Add missing @SubstrateForeignCallTarget to " + declaringClass.getName() + "." + methodName);
        boolean isGuaranteedSafepoint = needsDebugInfo && !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)foundMethod, Uninterruptible.class);
        return new SubstrateForeignCallDescriptor(descriptorName, foundMethod, isReexecutable, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void unsupportedFeature(String msg) {
        throw VMError.unsupportedFeature(msg);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void registerFinalizer(Object obj) {
    }

    public static class SubstrateForeignCallDescriptor
    extends ForeignCallDescriptor {
        private final Class<?> declaringClass;
        private final String methodName;

        SubstrateForeignCallDescriptor(String descriptorName, Method method, boolean isReexecutable, LocationIdentity[] killedLocations, boolean needsDebugInfo, boolean isGuaranteedSafepoint) {
            super(descriptorName, method.getReturnType(), (Class[])method.getParameterTypes(), isReexecutable, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
            this.declaringClass = method.getDeclaringClass();
            this.methodName = method.getName();
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess) {
            for (Method method : this.declaringClass.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName)) continue;
                return metaAccess.lookupJavaMethod((Executable)method);
            }
            throw VMError.shouldNotReachHere("method " + this.methodName + " not found");
        }

        public boolean needsDebugInfo() {
            return this.canDeoptimize();
        }
    }
}

