/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.jdk.Target_sun_util_locale_provider_LocaleServiceProviderPool;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.resources.LocaleData;

public abstract class LocalizationFeature
implements Feature {
    protected final Locale imageLocale = Locale.getDefault();
    protected LocalizationSupport support;
    private static final List<Class<? extends LocaleServiceProvider>> spiClasses = Arrays.asList(BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class, CalendarNameProvider.class);
    private static final Field PARENT_FIELD = ReflectionUtil.lookupField(ResourceBundle.class, (String)"parent");

    public void afterRegistration(Feature.AfterRegistrationAccess arg0) {
        this.support = new LocalizationSupport();
        ImageSingletons.add(LocalizationSupport.class, (Object)this.support);
        ImageSingletons.add(LocalizationFeature.class, (Object)this);
        LocalizationFeature.addCharsets();
        this.addProviders();
        this.addResourceBundles();
    }

    private static void addCharsets() {
        if (Options.AddAllCharsets.getValue().booleanValue()) {
            for (Charset c : Charset.availableCharsets().values()) {
                LocalizationFeature.addCharset(c);
            }
        } else {
            LocalizationFeature.addCharset(Charset.defaultCharset());
            LocalizationFeature.addCharset(Charset.forName("US-ASCII"));
            LocalizationFeature.addCharset(Charset.forName("ISO-8859-1"));
            LocalizationFeature.addCharset(Charset.forName("UTF-8"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16BE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16LE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16"));
        }
    }

    public static void addCharset(Charset charset) {
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        charsets.put(charset.name().toLowerCase(), charset);
        for (String name : charset.aliases()) {
            charsets.put(name.toLowerCase(), charset);
        }
        charset.newDecoder();
        if (charset.canEncode()) {
            charset.newEncoder();
        }
    }

    protected List<Class<? extends LocaleServiceProvider>> getSpiClasses() {
        return spiClasses;
    }

    private void addProviders() {
        for (Class<? extends LocaleServiceProvider> providerClass : this.getSpiClasses()) {
            LocaleProviderAdapter adapter = Objects.requireNonNull(LocaleProviderAdapter.getAdapter(providerClass, this.imageLocale));
            this.support.adaptersByClass.put(providerClass, adapter);
            LocaleProviderAdapter existing = this.support.adaptersByType.put(adapter.getAdapterType(), adapter);
            assert (existing == null || existing == adapter) : "Overwriting adapter type with a different adapter";
            LocaleServiceProvider provider = Objects.requireNonNull(adapter.getLocaleServiceProvider(providerClass));
            this.support.providerPools.put(providerClass, new Target_sun_util_locale_provider_LocaleServiceProviderPool(provider));
        }
    }

    protected void addResourceBundles() {
        this.addBundleToCache(this.localeData(CalendarDataProvider.class).getCalendarData(this.imageLocale));
        this.addBundleToCache(this.localeData(CurrencyNameProvider.class).getCurrencyNames(this.imageLocale));
        this.addBundleToCache(this.localeData(LocaleNameProvider.class).getLocaleNames(this.imageLocale));
        this.addBundleToCache(this.localeData(TimeZoneNameProvider.class).getTimeZoneNames(this.imageLocale));
        this.addBundleToCache(this.localeData(BreakIteratorProvider.class).getBreakIteratorInfo(this.imageLocale));
        this.addBundleToCache(this.localeData(BreakIteratorProvider.class).getCollationData(this.imageLocale));
        this.addBundleToCache(this.localeData(DateFormatProvider.class).getDateFormatData(this.imageLocale));
        this.addBundleToCache(this.localeData(NumberFormatProvider.class).getNumberFormatData(this.imageLocale));
        String[] alwaysRegisteredResourceBundles = new String[]{"sun.util.logging.resources.logging"};
        for (String bundleName : alwaysRegisteredResourceBundles) {
            this.addBundleToCache(bundleName);
        }
        for (String bundleName : OptionUtils.flatten(",", Options.IncludeResourceBundles.getValue())) {
            this.addBundleToCache(bundleName);
        }
    }

    protected LocaleData localeData(Class<? extends LocaleServiceProvider> providerClass) {
        return ((ResourceBundleBasedAdapter)((Object)LocaleProviderAdapter.getAdapter(providerClass, this.imageLocale))).getLocaleData();
    }

    protected void addBundleToCache(ResourceBundle bundle) {
        this.addBundleToCache(bundle.getBaseBundleName(), bundle);
    }

    public void addBundleToCache(String bundleName) {
        ResourceBundle resourceBundle;
        if (bundleName.isEmpty()) {
            return;
        }
        try {
            resourceBundle = ModuleSupport.getResourceBundle((String)bundleName, (Locale)this.imageLocale, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            if (!bundleName.contains("/")) {
                throw mre;
            }
            String dotBundleName = bundleName.replace("/", ".");
            resourceBundle = ModuleSupport.getResourceBundle((String)dotBundleName, (Locale)this.imageLocale, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        UserError.guarantee(resourceBundle != null, "The bundle named: %s, has not been found. If the bundle is part of a module, verify the bundle name is a fully qualified class name. Otherwise verify the bundle path is accessible in the classpath.", bundleName);
        this.addBundleToCache(bundleName, resourceBundle);
    }

    private void addBundleToCache(String bundleName, ResourceBundle bundle) {
        ResourceBundle cur = bundle;
        while (cur != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{cur.getClass()});
            cur.keySet();
            cur = LocalizationFeature.getParent(cur);
        }
        this.support.resourceBundles.put(bundleName, bundle);
    }

    private static ResourceBundle getParent(ResourceBundle bundle) {
        try {
            return (ResourceBundle)PARENT_FIELD.get(bundle);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static final class CharsetNodePlugin
    implements NodePlugin {
        public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if ((method.getName().equals("initc2b") || method.getName().equals("initb2c")) && b.getMetaAccess().lookupJavaType(Charset.class).isAssignableFrom(method.getDeclaringClass())) {
                ResolvedJavaType charsetType = method.getDeclaringClass();
                ResolvedJavaField initializedField = CharsetNodePlugin.findStaticField(charsetType, method.getName().substring(4, 7) + "Initialized");
                if (!b.getConstantReflection().readFieldValue(initializedField, null).asBoolean()) {
                    String charsetName = charsetType.getUnqualifiedName();
                    try {
                        Charset charset = Charset.forName(charsetName);
                        LocalizationFeature.addCharset(charset);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw VMError.shouldNotReachHere("Could not find non-initialized charset " + charsetType.getSourceFileName(), e);
                    }
                }
                return true;
            }
            return false;
        }

        private static ResolvedJavaField findStaticField(ResolvedJavaType declaringClass, String name) {
            for (ResolvedJavaField field : declaringClass.getStaticFields()) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            throw VMError.shouldNotReachHere();
        }
    }

    public static class Options {
        @Option(help={"Comma separated list of bundles to be included into the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> IncludeResourceBundles = new HostedOptionKey<Object>(null);
        @Option(help={"Make all hosted charsets available at run time"})
        public static final HostedOptionKey<Boolean> AddAllCharsets = new HostedOptionKey<Boolean>(false);
    }
}

