/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.log.Log;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class SpaceAccounting {
    private static final Log log = Log.noopLog();
    private long alignedCount;
    private UnsignedWord alignedChunkBytes;
    private long unalignedCount;
    private UnsignedWord unalignedChunkBytes;

    SpaceAccounting() {
        this.reset();
    }

    public void reset() {
        this.alignedCount = 0L;
        this.alignedChunkBytes = (UnsignedWord)WordFactory.zero();
        this.unalignedCount = 0L;
        this.unalignedChunkBytes = (UnsignedWord)WordFactory.zero();
    }

    long getAlignedChunkCount() {
        return this.alignedCount;
    }

    UnsignedWord getAlignedChunkBytes() {
        return this.alignedChunkBytes;
    }

    long getUnalignedChunkCount() {
        return this.unalignedCount;
    }

    UnsignedWord getUnalignedChunkBytes() {
        return this.unalignedChunkBytes;
    }

    void report(Log reportLog) {
        reportLog.string("aligned: ").unsigned((WordBase)this.alignedChunkBytes).string("/").unsigned(this.alignedCount);
        reportLog.string(" ");
        reportLog.string("unaligned: ").unsigned((WordBase)this.unalignedChunkBytes).string("/").unsigned(this.unalignedCount);
    }

    void noteAlignedHeapChunk(UnsignedWord size) {
        log.string("[SpaceAccounting.NoteAlignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
        ++this.alignedCount;
        this.alignedChunkBytes = this.alignedChunkBytes.add(size);
        log.string("  alignedCount: ").unsigned(this.alignedCount).string("  alignedChunkBytes: ").unsigned((WordBase)this.alignedChunkBytes).string("]").newline();
    }

    void unnoteAlignedHeapChunk(UnsignedWord size) {
        log.string("[SpaceAccounting.unnoteAlignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
        --this.alignedCount;
        this.alignedChunkBytes = this.alignedChunkBytes.subtract(size);
        log.string("  alignedCount: ").unsigned(this.alignedCount).string("  alignedChunkBytes: ").unsigned((WordBase)this.alignedChunkBytes).string("]").newline();
    }

    void noteUnalignedHeapChunk(UnsignedWord size) {
        log.string("[SpaceAccounting.NoteUnalignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
        ++this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.add(size);
        log.string("  unalignedCount: ").unsigned(this.unalignedCount).string("  unalignedChunkBytes: ").unsigned((WordBase)this.unalignedChunkBytes).newline();
    }

    void unnoteUnalignedHeapChunk(UnsignedWord size) {
        log.string("SpaceAccounting.unnoteUnalignedChunk(").string("size: ").unsigned((WordBase)size).string(")");
        --this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.subtract(size);
        log.string("  unalignedCount: ").unsigned(this.unalignedCount).string("  unalignedChunkBytes: ").unsigned((WordBase)this.unalignedChunkBytes).string("]").newline();
    }
}

