/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.FirstObjectTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class ImageHeapChunkWriter {
    private final int headerSize = SizeOf.get(HeapChunk.Header.class);
    private final int topOffsetAt = OffsetOf.get(HeapChunk.Header.class, "TopOffset");
    private final int endOffsetAt = OffsetOf.get(HeapChunk.Header.class, "EndOffset");
    private final int spaceOffsetAt = OffsetOf.get(HeapChunk.Header.class, "Space");
    private final int offsetToPreviousChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToPreviousChunk");
    private final int offsetToNextChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToNextChunk");
    private final int alignedChunkCardTableOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getCardTableStartOffset());
    private final UnsignedWord alignedChunkCardTableSize = AlignedHeapChunk.getCardTableSize();
    private final int alignedChunkFirstObjectTableOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getFirstObjectTableStartOffset());
    private final UnsignedWord alignedChunkFirstObjectTableSize = AlignedHeapChunk.getFirstObjectTableSize();
    private final UnsignedWord alignedChunkObjectsStartOffset = AlignedHeapChunk.getObjectsStartOffset();
    private final int unalignedChunkCardTableOffset = UnsignedUtils.safeToInt(UnalignedHeapChunk.getCardTableStartOffset());
    private final UnsignedWord unalignedChunkCardTableSize = UnalignedHeapChunk.getCardTableSize();

    ImageHeapChunkWriter() {
    }

    public void initializeAlignedChunk(ByteBuffer buffer, int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        this.writeHeader(buffer, chunkPosition, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
        CardTable.cleanTableInBuffer(buffer, chunkPosition + this.alignedChunkCardTableOffset, this.alignedChunkCardTableSize);
        FirstObjectTable.initializeTableInBuffer(buffer, chunkPosition + this.alignedChunkFirstObjectTableOffset, this.alignedChunkFirstObjectTableSize);
    }

    public void initializeUnalignedChunk(ByteBuffer buffer, int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        this.writeHeader(buffer, chunkPosition, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
        CardTable.cleanTableInBuffer(buffer, chunkPosition + this.unalignedChunkCardTableOffset, this.unalignedChunkCardTableSize);
    }

    private void writeHeader(ByteBuffer buffer, int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        for (int i = 0; i < this.headerSize; ++i) {
            assert (buffer.get(chunkPosition + i) == 0) : "Header area must be zeroed out";
        }
        buffer.putLong(chunkPosition + this.topOffsetAt, topOffset);
        buffer.putLong(chunkPosition + this.endOffsetAt, endOffset);
        ImageHeapChunkWriter.putObjectReference(buffer, chunkPosition + this.spaceOffsetAt, 0L);
        buffer.putLong(chunkPosition + this.offsetToPreviousChunkAt, offsetToPreviousChunk);
        buffer.putLong(chunkPosition + this.offsetToNextChunkAt, offsetToNextChunk);
    }

    public void insertIntoAlignedChunkFirstObjectTable(ByteBuffer buffer, int chunkPosition, long objectOffsetInChunk, long objectEndOffsetInChunk) {
        assert (chunkPosition >= 0 && objectOffsetInChunk >= 0L && objectEndOffsetInChunk > objectOffsetInChunk);
        int bufferTableOffset = chunkPosition + this.alignedChunkFirstObjectTableOffset;
        UnsignedWord offsetInObjects = WordFactory.unsigned((long)objectOffsetInChunk).subtract(this.alignedChunkObjectsStartOffset);
        UnsignedWord endOffsetInObjects = WordFactory.unsigned((long)objectEndOffsetInChunk).subtract(this.alignedChunkObjectsStartOffset);
        FirstObjectTable.setTableInBufferForObject(buffer, bufferTableOffset, offsetInObjects, endOffsetInObjects);
    }

    static void putObjectReference(ByteBuffer buffer, int position, long value) {
        switch (ConfigurationValues.getObjectLayout().getReferenceSize()) {
            case 4: {
                buffer.putInt(position, NumUtil.safeToInt((long)value));
                break;
            }
            case 8: {
                buffer.putLong(position, value);
                break;
            }
            default: {
                VMError.shouldNotReachHere("Unsupported reference size");
            }
        }
    }
}

