/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.IncompatibleException;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.persist.AbstractCatalogStorage;
import org.graalvm.component.installer.remote.FileDownloader;

public class MergeStorage
extends AbstractCatalogStorage
implements ComponentCatalog.DownloadInterceptor {
    private final Map<ComponentInfo, SoftwareChannel> channelMap = new HashMap<ComponentInfo, SoftwareChannel>();
    private final List<SoftwareChannel> channels = new ArrayList<SoftwareChannel>();
    private final Map<SoftwareChannel, SoftwareChannelSource> channelInfos = new HashMap<SoftwareChannel, SoftwareChannelSource>();
    private boolean ignoreCatalogErrors;
    private boolean idsLoaded;

    public MergeStorage(ComponentRegistry localRegistry, Feedback feedback) {
        super(localRegistry, feedback, null);
    }

    public void addChannel(SoftwareChannelSource info, SoftwareChannel delegate) {
        this.channels.add(delegate);
        this.channelInfos.put(delegate, info);
    }

    public boolean isIgnoreCatalogErrors() {
        return this.ignoreCatalogErrors;
    }

    public void setIgnoreCatalogErrors(boolean ignoreCatalogErrors) {
        this.ignoreCatalogErrors = ignoreCatalogErrors;
    }

    private void reportError(Exception exc, SoftwareChannel errChannel) {
        if (exc == null) {
            return;
        }
        SoftwareChannelSource info = this.channelInfos.get(errChannel);
        String l = info.getLabel();
        if (l == null) {
            l = info.getLocationURL();
        }
        this.feedback.error("REMOTE_CannotLoadChannel", exc, l, exc.getLocalizedMessage());
    }

    @Override
    public Set<String> listComponentIDs() throws IOException {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<IncompatibleException> savedEx = new ArrayList<IncompatibleException>();
        ArrayList<SoftwareChannel> errChannels = new ArrayList<SoftwareChannel>();
        boolean oneSucceeded = false;
        Exception toThrow = null;
        for (SoftwareChannel del : new ArrayList<SoftwareChannel>(this.channels)) {
            try {
                ids.addAll(del.getStorage().listComponentIDs());
                oneSucceeded = true;
            }
            catch (IncompatibleException ex) {
                savedEx.add(ex);
                errChannels.add(del);
                this.channels.remove(del);
            }
            catch (IOException | FailedOperationException ex) {
                if (!this.isIgnoreCatalogErrors()) {
                    throw ex;
                }
                if (!this.idsLoaded) {
                    this.reportError(ex, del);
                }
                toThrow = ex;
                this.channels.remove(del);
            }
        }
        if (!oneSucceeded || ids.isEmpty()) {
            for (int i = 0; i < savedEx.size(); ++i) {
                toThrow = (Exception)savedEx.get(i);
                this.reportError(toThrow, (SoftwareChannel)errChannels.get(i));
            }
            if (toThrow instanceof IOException) {
                throw (IOException)toThrow;
            }
            if (toThrow != null) {
                throw (InstallerStopException)toThrow;
            }
        }
        this.idsLoaded = true;
        return ids;
    }

    List<SoftwareChannel> getChannels() {
        return this.channels;
    }

    @Override
    public Set<ComponentInfo> loadComponentMetadata(String id) throws IOException {
        HashSet<ComponentInfo> cis = new HashSet<ComponentInfo>();
        for (SoftwareChannel swch : this.channels) {
            Set<ComponentInfo> newInfos = swch.getStorage().loadComponentMetadata(id);
            if (newInfos == null || newInfos.isEmpty()) continue;
            newInfos.removeAll(cis);
            for (ComponentInfo ci : newInfos) {
                this.channelMap.put(ci, swch);
            }
            cis.addAll(newInfos);
            break;
        }
        return cis;
    }

    public SoftwareChannel getOrigin(ComponentInfo ci) {
        return this.channelMap.get(ci);
    }

    @Override
    public FileDownloader processDownloader(ComponentInfo info, FileDownloader dn) {
        SoftwareChannel orig = this.getOrigin(info);
        return orig != null ? orig.configureDownloader(info, dn) : dn;
    }
}

