/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.URLConnectionFactory;
import org.graalvm.component.installer.remote.ProxyConnectionFactory;

public final class FileDownloader {
    private static final int TRANSFER_LENGTH = 2048;
    private static final long MIN_PROGRESS_THRESHOLD = Long.getLong("org.graalvm.component.installer.minDownloadFeedback", 0x100000L);
    private final String fileDescription;
    private final URL sourceURL;
    private final Feedback feedback;
    private File downloadDir;
    private File localFile;
    private long size;
    private static boolean deleteTemporary = !Boolean.FALSE.toString().equals(System.getProperty("org.graalvm.component.installer.deleteTemporary"));
    private boolean verbose;
    private static volatile File tempDir;
    private boolean displayProgress;
    private byte[] shaDigest;
    long sizeThreshold = MIN_PROGRESS_THRESHOLD;
    private final Map<String, String> requestHeaders = new HashMap<String, String>();
    private Consumer<SeekableByteChannel> dataInterceptor;
    private URLConnectionFactory connectionFactory;
    private String digestAlgorithm = "SHA-256";
    StringBuilder progressString;
    String backspaceString;
    int startPos;
    int signCount;
    long received;
    char signChar;
    MessageDigest fileDigest;
    byte[] receivedDigest;

    public FileDownloader(String fileDescription, URL sourceURL, Feedback feedback) {
        this.fileDescription = fileDescription;
        this.sourceURL = sourceURL;
        this.feedback = feedback.withBundle(FileDownloader.class);
    }

    public void setShaDigest(byte[] shaDigest) {
        this.shaDigest = shaDigest;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(File downloadDir) {
        this.downloadDir = downloadDir;
    }

    public static void setDeleteTemporary(boolean deleteTemporary) {
        FileDownloader.deleteTemporary = deleteTemporary;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDisplayProgress(boolean displayProgress) {
        this.displayProgress = displayProgress;
    }

    public void addRequestHeader(String header, String val) {
        this.requestHeaders.put(header, val);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public static synchronized File createTempDir() throws IOException {
        if (tempDir == null) {
            Path p = Files.createTempDirectory("graalvm_install", new FileAttribute[0]);
            tempDir = p.toFile();
            tempDir.deleteOnExit();
        }
        return tempDir;
    }

    private static File deleteOnExit(File f) {
        if (deleteTemporary) {
            f.deleteOnExit();
        }
        return f;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public URL getSourceURL() {
        return this.sourceURL;
    }

    private static int toKB(long size) {
        return (int)(size + 1023L) / 1024;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    void setupProgress() {
        if (!this.displayProgress) {
            return;
        }
        this.progressString = new StringBuilder(this.feedback.l10n("MSG_DownloadProgress", new Object[0]));
        this.signChar = this.feedback.l10n("MSG_DownloadProgressSignChar", new Object[0]).charAt(0);
        this.startPos = this.progressString.toString().indexOf(32);
        StringBuilder bs = new StringBuilder(this.progressString.length());
        for (int i = 0; i < this.progressString.length(); ++i) {
            bs.append('\b');
        }
        this.backspaceString = bs.toString();
    }

    int cnt(long rcvd) {
        return (int)((rcvd * 20L + rcvd / 2L) / this.size);
    }

    void makeProgress(boolean first, int chunk) {
        if (!this.displayProgress) {
            return;
        }
        int now = this.cnt(this.received);
        this.received += (long)chunk;
        int next = this.cnt(this.received);
        if (now < next) {
            this.progressString.setCharAt(next + this.startPos - 1, this.signChar);
            this.signCount = next;
            if (!first) {
                this.feedback.verbatimPart(this.backspaceString, false);
            }
            this.feedback.verbatimPart(this.progressString.toString(), false);
        }
    }

    void stopProgress(boolean success) {
        if (this.displayProgress) {
            this.feedback.verbatimPart(this.backspaceString, false);
        }
        if (success) {
            this.feedback.verboseOutput("MSG_DownloadingDone", new Object[0]);
        } else {
            this.feedback.output("MSG_DownloadingTerminated", new Object[0]);
        }
    }

    void updateFileDigest(ByteBuffer input) throws IOException {
        if (this.shaDigest == null) {
            return;
        }
        if (this.fileDigest == null) {
            try {
                this.fileDigest = MessageDigest.getInstance(this.getDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException(this.feedback.l10n("ERR_ComputeDigest", ex.getLocalizedMessage()), ex);
            }
        }
        this.fileDigest.update(input);
    }

    static String fingerPrint(byte[] digest) {
        return SystemUtils.fingerPrint(digest);
    }

    byte[] getDigest() {
        return this.fileDigest.digest();
    }

    public byte[] getReceivedDigest() throws IOException {
        if (this.receivedDigest == null) {
            if (this.localFile == null) {
                return null;
            }
            this.receivedDigest = SystemUtils.computeFileDigest(this.localFile.toPath(), this.getDigestAlgorithm());
        }
        return this.receivedDigest == null ? null : (byte[])this.receivedDigest.clone();
    }

    void verifyDigest() throws IOException {
        if (this.shaDigest == null || this.shaDigest.length == 0) {
            return;
        }
        byte[] computed = this.fileDigest.digest();
        this.receivedDigest = computed;
        if (Arrays.equals(computed, this.shaDigest)) {
            return;
        }
        throw new IOException(this.feedback.l10n("ERR_FileDigestError", FileDownloader.fingerPrint(this.shaDigest), FileDownloader.fingerPrint(computed)));
    }

    void configureHeaders(URLConnection con) {
        for (String h : this.requestHeaders.keySet()) {
            con.addRequestProperty(h, this.requestHeaders.get(h));
        }
    }

    protected void dataDownloaded(SeekableByteChannel ch) {
        if (this.dataInterceptor != null) {
            this.dataInterceptor.accept(ch);
        }
    }

    public FileDownloader setDataInterceptor(Consumer<SeekableByteChannel> interceptor) {
        this.dataInterceptor = interceptor;
        return this;
    }

    private void copySubtree(Path from) throws IOException {
        Path to = Files.createTempDirectory(FileDownloader.createTempDir().toPath(), "download", new FileAttribute[0]);
        SystemUtils.copySubtree(from, to);
        this.localFile = to.toFile();
    }

    public void download() throws IOException {
        Path localCache;
        boolean fromFile = this.sourceURL.getProtocol().equals("file");
        if (this.fileDescription != null) {
            if (!this.feedback.verboseOutput("MSG_DownloadingVerbose", this.getFileDescription(), this.getSourceURL())) {
                this.feedback.output(fromFile ? "MSG_UsingFile" : "MSG_Downloading", this.getFileDescription(), this.getSourceURL().getHost());
            }
        } else {
            this.feedback.output("MSG_DownloadingFrom", this.getSourceURL());
        }
        if ((localCache = this.feedback.getLocalCache(this.sourceURL)) != null) {
            this.localFile = localCache.toFile();
            return;
        }
        if (fromFile) {
            try {
                Path p = Paths.get(this.sourceURL.toURI());
                if (Files.isDirectory(p, new LinkOption[0])) {
                    this.copySubtree(p);
                    return;
                }
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        URLConnection conn = this.getConnectionFactory().createConnection(this.sourceURL, this::configureHeaders);
        this.size = conn.getContentLengthLong();
        this.verbose = this.feedback.verbosePart("MSG_DownloadReceivingBytes", FileDownloader.toKB(this.size));
        if (this.verbose) {
            this.displayProgress = true;
        }
        if (this.size < this.sizeThreshold) {
            this.displayProgress = false;
        }
        this.setupProgress();
        ByteBuffer bb = ByteBuffer.allocate(2048);
        this.localFile = FileDownloader.deleteOnExit(File.createTempFile("download", "", this.downloadDir == null ? FileDownloader.createTempDir() : this.downloadDir));
        boolean first = this.displayProgress;
        boolean success = false;
        try (ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
             SeekableByteChannel wbc = Files.newByteChannel(this.localFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int read;
            while ((read = rbc.read(bb)) >= 0) {
                if (first) {
                    this.feedback.verbatimPart(this.progressString.toString(), false);
                }
                bb.flip();
                while (bb.hasRemaining()) {
                    wbc.write(bb);
                    long pos = wbc.position();
                    this.dataDownloaded(wbc);
                    wbc.position(pos);
                }
                bb.flip();
                this.updateFileDigest(bb);
                this.makeProgress(first, read);
                bb.clear();
                first = false;
            }
            success = true;
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.stopProgress(success);
        }
        this.verifyDigest();
        this.feedback.addLocalFileCache(this.sourceURL, this.localFile.toPath());
    }

    public void setConnectionFactory(URLConnectionFactory connFactory) {
        this.connectionFactory = connFactory;
    }

    URLConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ProxyConnectionFactory(this.feedback, this.sourceURL);
        }
        return this.connectionFactory;
    }
}

