/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.DistributionType;
import org.graalvm.component.installer.model.ManagementStorage;
import org.graalvm.component.installer.persist.SortedProperties;

public class DirectoryStorage
implements ManagementStorage {
    public static final String META_LICENSE_FILE = "LICENSE_PATH";
    private static final String PATH_RELEASE_FILE = "release";
    private static final String COMPONENT_FILE_SUFFIX = ".component";
    private static final String NATIVE_COMPONENT_FILE_SUFFIX = ".meta";
    private static final String LIST_FILE_SUFFIX = ".filelist";
    private static final String PATH_REPLACED_FILES = "replaced-files.properties";
    private static final String LICENSE_DIR = "licenses";
    private static final String LICENSE_CONTENTS_NAME = "licenses/{0}";
    private static final String LICENSE_FILE_TEMPLATE = "licenses/{0}.accepted/{1}";
    private static final String BUNDLE_REQUIRED_PREFIX = "Bundle-RequireCapability-";
    private static final String BUNDLE_PROVIDED_PREFIX = "Bundle-ProvideCapability-";
    protected final Path registryPath;
    protected final Path graalHomePath;
    private final Feedback feedback;
    private Properties loaded;
    private ComponentInfo graalCore;
    private static final String GRAALVM_SOURCE = "source";
    private static final Pattern SOURCE_REVISION = Pattern.compile("\\b([a-z-._]+):([0-9a-f]+)\\b");
    private static final String REVISION_PREFIX = "source_";
    private static final String[] REQUIRED_ATTRIBUTES = new String[]{"graalvm_version", "os_name", "os_arch"};
    private static final String ENTERPRISE_EDITION = "ee";
    private static final String VM_ENTERPRISE_COMPONENT = "vm-enterprise:";
    private String javaVersion;

    public DirectoryStorage(Feedback feedback, Path storagePath, Path graalHomePath) {
        this.feedback = feedback;
        this.registryPath = storagePath;
        this.graalHomePath = graalHomePath;
        this.javaVersion = "" + SystemUtils.getJavaMajorVersion();
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> loadGraalVersionInfo() {
        Path graalVersionFile = this.graalHomePath.resolve(SystemUtils.fromCommonString(PATH_RELEASE_FILE));
        try (InputStream istm = Files.newInputStream(graalVersionFile, new OpenOption[0]);){
            Map<String, String> map = this.load(istm);
            return map;
        }
        catch (IOException ex) {
            throw this.feedback.failure("ERROR_ReadingRealeaseFile", ex, graalVersionFile, ex.getMessage());
        }
    }

    public Version getGraalVMVersion() {
        String s = this.loadGraalVersionInfo().get("graalvm_version");
        return Version.fromString(s);
    }

    private Map<String, String> load(InputStream istm) throws IOException {
        HashMap<String, String> graalAttributes = new HashMap<String, String>();
        Properties props = new Properties();
        props.load(istm);
        String srcText = null;
        for (String key : Collections.list(props.propertyNames())) {
            String val = props.getProperty(key, "");
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (!val.isEmpty() && val.charAt(0) == '\"' && val.length() > 1 && val.charAt(val.length() - 1) == '\"') {
                val = val.substring(1, val.length() - 1).trim();
            }
            if (GRAALVM_SOURCE.equals(lowerKey)) {
                Matcher m = SOURCE_REVISION.matcher(val);
                srcText = val;
                while (m.find()) {
                    if (m.group(1) == null || m.group(2) == null || m.group(1).isEmpty() || m.group(2).isEmpty()) {
                        throw this.feedback.failure("ERROR_ReleaseSourceRevisions", null, this.graalHomePath);
                    }
                    graalAttributes.put(REVISION_PREFIX + m.group(1), m.group(2));
                }
                continue;
            }
            graalAttributes.put(lowerKey, val);
        }
        for (String a : REQUIRED_ATTRIBUTES) {
            if (graalAttributes.containsKey(a)) continue;
            throw this.feedback.failure("STORAGE_InvalidReleaseFile", null, new Object[0]);
        }
        if (graalAttributes.get("edition") == null && srcText != null) {
            if (srcText.contains(VM_ENTERPRISE_COMPONENT)) {
                graalAttributes.put("edition", ENTERPRISE_EDITION);
            } else {
                graalAttributes.put("edition", "ce");
            }
        }
        graalAttributes.putIfAbsent("java_version", this.javaVersion);
        return graalAttributes;
    }

    @Override
    public Set<String> listComponentIDs() throws IOException {
        if (!Files.exists(this.registryPath, new LinkOption[0])) {
            return Collections.emptySet();
        }
        File d = this.registryPath.toFile();
        File[] files = d.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                if (!Files.isRegularFile(child.toPath(), new LinkOption[0])) {
                    return false;
                }
                return child.getName().endsWith(DirectoryStorage.COMPONENT_FILE_SUFFIX) || child.getName().endsWith(DirectoryStorage.NATIVE_COMPONENT_FILE_SUFFIX);
            }
        });
        if (files != null) {
            HashSet<String> result = new HashSet<String>();
            for (File f : files) {
                String s = this.registryPath.relativize(f.toPath()).toString();
                int lastDot = s.lastIndexOf(46);
                result.add(s.substring(0, lastDot));
            }
            if (Files.exists(this.graalHomePath.resolve("bin"), new LinkOption[0])) {
                result.add("org.graalvm");
            }
            return result;
        }
        throw new IllegalArgumentException("File listing of " + d + " returned null.");
    }

    private static String computeTag(Properties data) throws IOException {
        try (StringWriter wr = new StringWriter();){
            data.store(wr, "");
            String string = SystemUtils.digestString(wr.toString().replaceAll("#.*\n", ""), false);
            return string;
        }
    }

    ComponentInfo loadMetadataFrom(InputStream fileStream) throws IOException {
        this.loaded = new Properties();
        this.loaded.load(fileStream);
        String serial = this.loaded.getProperty("x-GraalVM-Serial");
        if (serial == null) {
            serial = DirectoryStorage.computeTag(this.loaded);
        }
        String id = this.getRequiredProperty("Bundle-Symbolic-Name");
        String name = this.getRequiredProperty("Bundle-Name");
        String version = this.getRequiredProperty("Bundle-Version");
        return DirectoryStorage.propertiesToMeta(this.loaded, new ComponentInfo(id, name, version, serial), this.feedback);
    }

    public static ComponentInfo propertiesToMeta(Properties loaded, ComponentInfo ci, Feedback fb) {
        String u;
        String postInst;
        String license = loaded.getProperty("x-GraalVM-License-Path");
        if (license != null) {
            SystemUtils.checkCommonRelative(null, license);
            ci.setLicensePath(license);
        }
        block8: for (String string : loaded.stringPropertyNames()) {
            Object o;
            String v;
            String k;
            if (string.startsWith(BUNDLE_REQUIRED_PREFIX)) {
                k = string.substring(BUNDLE_REQUIRED_PREFIX.length());
                v = loaded.getProperty(string, "");
                ci.addRequiredValue(k, v);
            }
            if (!string.startsWith(BUNDLE_PROVIDED_PREFIX)) continue;
            k = string.substring(BUNDLE_PROVIDED_PREFIX.length());
            v = loaded.getProperty(string, "");
            if (v.length() < 2) continue;
            String val = v.substring(1);
            switch (v.charAt(0)) {
                case 'V': {
                    o = Version.fromString(val);
                    break;
                }
                case '\"': {
                    o = val;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            ci.provideValue(k, o);
        }
        LinkedHashSet<String> deps = new LinkedHashSet<String>();
        for (String s : loaded.getProperty("Require-Bundle", "").split(",")) {
            String p = s.trim();
            if (p.isEmpty()) continue;
            deps.add(s.trim());
        }
        if (!deps.isEmpty()) {
            ci.setDependencies(deps);
        }
        if (Boolean.TRUE.toString().equals(loaded.getProperty("x-GraalVM-Polyglot-Part", ""))) {
            ci.setPolyglotRebuild(true);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String s : loaded.getProperty("x-GraalVM-Working-Directories", "").split(":")) {
            String p = s.trim();
            if (p.isEmpty()) continue;
            SystemUtils.checkCommonRelative(null, p);
            arrayList.add(p);
        }
        ci.addWorkingDirectories(arrayList);
        String licType = loaded.getProperty("x-GraalVM-License-Type");
        if (licType != null) {
            ci.setLicenseType(licType);
        }
        if ((postInst = loaded.getProperty("x-GraalVM-Message-PostInst")) != null) {
            String text = postInst.replace("\\n", "\n").replace("\\\\", "\\");
            ci.setPostinstMessage(text);
        }
        if ((u = loaded.getProperty("x-GraalVM-Component-Origin")) != null) {
            try {
                ci.setRemoteURL(new URL(u));
            }
            catch (MalformedURLException s) {
                // empty catch block
            }
        }
        String dtn = loaded.getProperty("x-GraalVM-Component-Distribution", DistributionType.OPTIONAL.name());
        try {
            ci.setDistributionType(DistributionType.valueOf(dtn.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataException("x-GraalVM-Component-Distribution", fb.withBundle(DirectoryStorage.class).l10n("ERROR_InvalidDistributionType", dtn));
        }
        return ci;
    }

    private ComponentInfo getCoreInfo() {
        if (this.graalCore != null) {
            return this.graalCore;
        }
        Version v = this.getGraalVMVersion();
        ComponentInfo ci = new ComponentInfo("org.graalvm", this.feedback.l10n("NAME_GraalCoreComponent", new Object[0]), v.originalString());
        Path cmpFile = this.registryPath.resolve(SystemUtils.fileName("org.graalvm.meta"));
        if (Files.exists(cmpFile, new LinkOption[0])) {
            ci.setNativeComponent(true);
        }
        this.graalCore = ci;
        return this.graalCore;
    }

    @Override
    public Set<ComponentInfo> loadComponentMetadata(String tag) throws IOException {
        Path cmpFile = this.registryPath.resolve(SystemUtils.fileName(tag + COMPONENT_FILE_SUFFIX));
        boolean nc = false;
        if (!Files.exists(cmpFile, new LinkOption[0])) {
            if ("org.graalvm".equals(tag)) {
                return Collections.singleton(this.getCoreInfo());
            }
            cmpFile = this.registryPath.resolve(SystemUtils.fileName(tag + NATIVE_COMPONENT_FILE_SUFFIX));
            if (!Files.exists(cmpFile, new LinkOption[0])) {
                return null;
            }
            nc = true;
        }
        try (InputStream fileStream = Files.newInputStream(cmpFile, new OpenOption[0]);){
            ComponentInfo info = this.loadMetadataFrom(fileStream);
            info.setInfoPath(cmpFile.toString());
            info.setNativeComponent(nc);
            Set<ComponentInfo> set = Collections.singleton(info);
            return set;
        }
    }

    @Override
    public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
        String tag = ci.getId();
        Path listFile = this.registryPath.resolve(SystemUtils.fileName(tag + LIST_FILE_SUFFIX));
        if (!Files.exists(listFile, new LinkOption[0])) {
            return ci;
        }
        List<String> s = Files.readAllLines(listFile);
        HashSet<String> result = new HashSet<String>(s.size());
        for (String e : s) {
            String trimmed = e.trim();
            if (trimmed.isEmpty()) continue;
            SystemUtils.checkCommonRelative(null, trimmed);
            result.add(trimmed);
        }
        s = new ArrayList<String>(result);
        Collections.sort(s);
        ci.addPaths(s);
        return ci;
    }

    private String getRequiredProperty(String key) {
        String val = this.loaded.getProperty(key);
        if (val == null) {
            throw this.feedback.failure("STORAGE_CorruptedComponentStorage", null, new Object[0]);
        }
        return val;
    }

    @Override
    public Map<String, Collection<String>> readReplacedFiles() throws IOException {
        Path replacedPath = this.registryPath.resolve(SystemUtils.fromCommonString(PATH_REPLACED_FILES));
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        Properties props = new Properties();
        if (!Files.exists(replacedPath, new LinkOption[0])) {
            return result;
        }
        try (InputStream is = Files.newInputStream(replacedPath, new OpenOption[0]);){
            props.load(is);
        }
        for (String s : Collections.list(props.propertyNames())) {
            String files = props.getProperty(s, "");
            HashSet<String> unsorted = new HashSet<String>();
            for (String x : files.split(" *, *")) {
                String t = x.trim();
                if (t.isEmpty()) continue;
                SystemUtils.checkCommonRelative(null, t);
                unsorted.add(t);
            }
            ArrayList components = new ArrayList(unsorted);
            Collections.sort(components);
            result.put(s, components);
        }
        return result;
    }

    @Override
    public void updateReplacedFiles(Map<String, Collection<String>> replacedFiles) throws IOException {
        SortedProperties props = new SortedProperties();
        for (String k : replacedFiles.keySet()) {
            ArrayList<String> ids = new ArrayList<String>(replacedFiles.get(k));
            Collections.sort(ids);
            props.setProperty(k, String.join((CharSequence)",", ids));
        }
        Path replacedPath = this.registryPath.resolve(SystemUtils.fromCommonString(PATH_REPLACED_FILES));
        if (props.isEmpty()) {
            Files.deleteIfExists(replacedPath);
        } else {
            try (OutputStream os = Files.newOutputStream(replacedPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                props.store(os, null);
            }
        }
    }

    @Override
    public void deleteComponent(String id) throws IOException {
        Path compFile = this.registryPath.resolve(SystemUtils.fileName(id + COMPONENT_FILE_SUFFIX));
        Path listFile = this.registryPath.resolve(SystemUtils.fileName(id + LIST_FILE_SUFFIX));
        Files.deleteIfExists(compFile);
        Files.deleteIfExists(listFile);
    }

    @Override
    public void saveComponent(ComponentInfo info) throws IOException {
        this.verifyUserAccess();
        if (info == null) {
            return;
        }
        if (info.isNativeComponent()) {
            return;
        }
        Path cmpFile = this.registryPath.resolve(SystemUtils.fileName(info.getId() + COMPONENT_FILE_SUFFIX));
        try (OutputStream compFile = Files.newOutputStream(cmpFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            DirectoryStorage.metaToProperties(info).store(compFile, null);
        }
        this.saveComponentFileList(info);
    }

    public static Properties metaToProperties(ComponentInfo info) {
        URL u;
        SortedProperties p = new SortedProperties();
        p.setProperty("Bundle-Symbolic-Name", info.getId());
        p.setProperty("Bundle-Name", info.getName());
        p.setProperty("Bundle-Version", info.getVersionString());
        String s = info.getTag();
        if (s != null && !s.isEmpty()) {
            p.setProperty("x-GraalVM-Serial", s);
        }
        if (info.getLicensePath() != null) {
            p.setProperty("x-GraalVM-License-Path", info.getLicensePath());
        }
        if (info.getLicenseType() != null) {
            p.setProperty("x-GraalVM-License-Type", info.getLicenseType());
        }
        for (String k : info.getRequiredGraalValues().keySet()) {
            String v = info.getRequiredGraalValues().get(k);
            if (v == null) {
                v = "";
            }
            p.setProperty(BUNDLE_REQUIRED_PREFIX + k, v);
        }
        for (String k : info.getProvidedValues().keySet()) {
            char t;
            Object o = info.getProvidedValue(k, Object.class);
            if (o instanceof String) {
                t = '\"';
            } else {
                if (!(o instanceof Version)) continue;
                t = 'V';
                o = ((Version)o).originalString();
            }
            p.setProperty(BUNDLE_PROVIDED_PREFIX + k, t + o.toString());
        }
        if (!info.getDependencies().isEmpty()) {
            p.setProperty("Require-Bundle", ((Stream)info.getDependencies().stream().sequential()).collect(Collectors.joining(":")));
        }
        if (info.getPostinstMessage() != null) {
            p.setProperty("x-GraalVM-Message-PostInst", info.getPostinstMessage());
        }
        if (info.isPolyglotRebuild()) {
            p.setProperty("x-GraalVM-Polyglot-Part", Boolean.TRUE.toString());
        }
        if (!info.getWorkingDirectories().isEmpty()) {
            p.setProperty("x-GraalVM-Working-Directories", ((Stream)info.getWorkingDirectories().stream().sequential()).collect(Collectors.joining(":")));
        }
        if (info.getDistributionType() != DistributionType.OPTIONAL) {
            p.setProperty("x-GraalVM-Component-Distribution", info.getDistributionType().name().toLowerCase(Locale.ENGLISH));
        }
        if ((u = info.getRemoteURL()) != null) {
            p.setProperty("x-GraalVM-Component-Origin", u.toString());
        }
        return p;
    }

    void saveComponentFileList(ComponentInfo info) throws IOException {
        Path listFile = this.registryPath.resolve(SystemUtils.fileName(info.getId() + LIST_FILE_SUFFIX));
        ArrayList<String> entries = new ArrayList<String>(new HashSet<String>(info.getPaths()));
        Collections.sort(entries);
        Files.write(listFile, entries, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void checkLicenseID(String licenseID) {
        if (licenseID.contains("/")) {
            throw new IllegalArgumentException("Invalid license ID: " + licenseID);
        }
    }

    @Override
    public Date licenseAccepted(ComponentInfo info, String licenseID) {
        if (!SystemUtils.isLicenseTrackingEnabled()) {
            return null;
        }
        DirectoryStorage.checkLicenseID(licenseID);
        try {
            String fn = MessageFormat.format(LICENSE_FILE_TEMPLATE, licenseID, info.getId());
            Path listFile = this.registryPath.resolve(SystemUtils.fromCommonRelative(fn));
            if (!Files.isReadable(listFile)) {
                return null;
            }
            return new Date(Files.getLastModifiedTime(listFile, new LinkOption[0]).toMillis());
        }
        catch (IOException ex) {
            throw this.feedback.failure("ERR_CannotReadAcceptance", ex, licenseID);
        }
    }

    @Override
    public Map<String, Collection<String>> findAcceptedLicenses() {
        if (!SystemUtils.isLicenseTrackingEnabled()) {
            return Collections.emptyMap();
        }
        Path licDir = this.registryPath.resolve(LICENSE_DIR);
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        try {
            if (!Files.isDirectory(licDir, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            Files.walk(licDir, new FileVisitOption[0]).forEach(lp -> {
                if (!Files.isRegularFile(lp, new LinkOption[0])) {
                    return;
                }
                Path parent = lp.getParent();
                if (parent.equals(licDir)) {
                    return;
                }
                String fn = parent.getFileName().toString();
                if (!fn.endsWith(".accepted")) {
                    return;
                }
                int dot = fn.lastIndexOf(46);
                String id = fn.substring(0, dot);
                result.computeIfAbsent(id, x -> new ArrayList()).add(lp.getFileName().toString());
            });
        }
        catch (IOException ex) {
            throw this.feedback.failure("ERR_CannotReadAcceptance", ex, "(all)");
        }
        return result;
    }

    @Override
    public void recordLicenseAccepted(ComponentInfo info, String licenseID, String licenseText, Date d) throws IOException {
        if (!SystemUtils.isLicenseTrackingEnabled()) {
            return;
        }
        if (licenseID == null) {
            this.clearRecordedLicenses();
            return;
        }
        DirectoryStorage.checkLicenseID(licenseID);
        String fn = MessageFormat.format(LICENSE_FILE_TEMPLATE, licenseID, info.getId());
        Path listFile = this.registryPath.resolve(SystemUtils.fromCommonRelative(fn));
        if (listFile == null) {
            throw new IllegalArgumentException(licenseID);
        }
        Path dir = listFile.getParent();
        if (dir == null) {
            throw new IllegalArgumentException(licenseID);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path contentsFile = this.registryPath.resolve(SystemUtils.fromCommonRelative(MessageFormat.format(LICENSE_CONTENTS_NAME, licenseID)));
            Files.write(contentsFile, Arrays.asList(licenseText.split("\n")), new OpenOption[0]);
        }
        String ds = (d == null ? new Date() : d).toString();
        Files.write(listFile, Collections.singletonList(ds), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    void clearRecordedLicenses() throws IOException {
        Path listFile = this.registryPath.resolve(LICENSE_DIR);
        if (Files.isDirectory(listFile, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(listFile, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        if (p.equals(listFile)) {
                            return;
                        }
                        Files.delete(p);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
    }

    @Override
    public String licenseText(String licID) {
        Path contentsFile = this.registryPath.resolve(SystemUtils.fromCommonRelative(MessageFormat.format(LICENSE_CONTENTS_NAME, licID)));
        try {
            return Files.lines(contentsFile).collect(Collectors.joining("\n"));
        }
        catch (IOException ex) {
            throw this.feedback.failure("ERR_CannotReadAcceptance", ex, licID);
        }
    }

    void verifyUserAccess() {
        if (Files.isWritable(this.registryPath)) {
            return;
        }
        try {
            String owner = SystemUtils.findFileOwner(this.registryPath);
            if (owner != null) {
                throw this.feedback.failure("ERROR_MustBecomeUser", null, owner);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw this.feedback.failure("ERROR_MustBecomeAdmin", null, new Object[0]);
    }
}

