/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.DistributionType;
import org.graalvm.component.installer.persist.HeaderParser;
import org.graalvm.component.installer.persist.MetadataLoader;

public class ComponentPackageLoader
implements Closeable,
MetadataLoader {
    protected final Feedback feedback;
    private final Function<String, String> valueSupplier;
    private boolean infoOnly;
    private final List<InstallerStopException> errors = new ArrayList<InstallerStopException>();
    private final List<String> fileList = new ArrayList<String>();
    private String id;
    private String version;
    private String name;
    private String licensePath;
    private String licenseType;
    private ComponentInfo info;
    private boolean noVerifySymlinks;
    private final String componentTag;
    private final Properties props = new Properties();
    static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.graalvm.component.installer.persist.Bundle");

    public ComponentPackageLoader(String tag, Function<String, String> supplier, Feedback feedback) {
        this.feedback = feedback.withBundle(ComponentPackageLoader.class);
        this.valueSupplier = supplier;
        this.componentTag = tag;
    }

    public ComponentPackageLoader(Function<String, String> supplier, Feedback feedback) {
        this(null, supplier, feedback);
    }

    @Override
    public Archive getArchive() {
        return null;
    }

    private String value(String key) {
        String v = this.valueSupplier.apply(key);
        if (v != null && (this.componentTag == null || this.componentTag.isEmpty())) {
            this.props.put(key, v);
        }
        return v;
    }

    @Override
    public ComponentPackageLoader infoOnly(boolean only) {
        this.infoOnly = only;
        return this;
    }

    private HeaderParser parseHeader(String header) throws MetadataException {
        return this.parseHeader2(header, null);
    }

    private HeaderParser parseHeader2(String header, Function<String, String> fn) throws MetadataException {
        String s = this.value(header);
        if (fn != null) {
            s = fn.apply(s);
        }
        return new HeaderParser(header, s, this.feedback).mustExist();
    }

    private HeaderParser parseHeader(String header, String defValue) throws MetadataException {
        String s = this.value(header);
        if (s == null) {
            if (defValue == null) {
                return new HeaderParser(header, s, this.feedback);
            }
            return new HeaderParser(header, defValue, this.feedback);
        }
        return new HeaderParser(header, s, this.feedback).mustExist();
    }

    @Override
    public ComponentInfo getComponentInfo() {
        if (this.info == null) {
            return this.createComponentInfo();
        }
        return this.info;
    }

    private void parse(Runnable ... parts) {
        for (Runnable r : parts) {
            try {
                r.run();
            }
            catch (MetadataException ex) {
                if ("Bundle-Symbolic-Name".equals(ex.getOffendingHeader())) {
                    throw ex;
                }
                if (this.infoOnly) {
                    this.errors.add(ex);
                    continue;
                }
                throw ex;
            }
            catch (InstallerStopException ex) {
                if (this.infoOnly) {
                    this.errors.add(ex);
                    continue;
                }
                throw ex;
            }
        }
    }

    @Override
    public List<InstallerStopException> getErrors() {
        return this.errors;
    }

    private void supplyComponentTag() {
        String ct = this.info.getTag();
        if (ct != null && !ct.isEmpty()) {
            return;
        }
        try (StringWriter wr = new StringWriter();){
            this.props.store(wr, "");
            this.info.setTag(SystemUtils.digestString(wr.toString().replaceAll("#.*\n", ""), false));
        }
        catch (IOException ex) {
            throw new FailedOperationException(ex.getLocalizedMessage(), ex);
        }
    }

    private void loadWorkingDirectories(ComponentInfo nfo) {
        String val = this.parseHeader("x-GraalVM-Working-Directories", null).getContents("");
        LinkedHashSet<String> workDirs = new LinkedHashSet<String>();
        for (String s : val.split(":")) {
            String p = s.trim();
            if (p.isEmpty()) continue;
            workDirs.add(p);
        }
        nfo.addWorkingDirectories(workDirs);
    }

    private String findComponentTag() {
        String t = this.value("x-GraalVM-Serial");
        return t != null && !t.isEmpty() ? t : this.componentTag;
    }

    protected ComponentInfo createBaseComponentInfo() {
        this.parse(() -> {
            this.id = this.parseHeader("Bundle-Symbolic-Name").parseSymbolicName();
        }, () -> {
            this.name = this.parseHeader("Bundle-Name").getContents(this.id);
        }, () -> {
            this.version = this.parseHeader("Bundle-Version").version();
        }, () -> {
            this.info = new ComponentInfo(this.id, this.name, this.version, this.findComponentTag());
            this.info.addRequiredValues(this.parseHeader("Bundle-RequireCapability").parseRequiredCapabilities());
            this.info.addProvidedValues(this.parseHeader("Bundle-ProvideCapability", "").parseProvidedCapabilities());
            this.info.setDependencies(this.parseHeader("Require-Bundle", "").parseDependencies());
        });
        this.supplyComponentTag();
        return this.info;
    }

    protected ComponentInfo loadExtendedMetadata(ComponentInfo base) {
        this.parse(() -> base.setPolyglotRebuild(this.parseHeader("x-GraalVM-Polyglot-Part", null).getBoolean(Boolean.FALSE)), () -> base.setDistributionType(this.parseDistributionType()), () -> this.loadWorkingDirectories(base), () -> this.loadMessages(base), () -> this.loadLicenseType(base));
        return base;
    }

    public ComponentInfo createComponentInfo() {
        ComponentInfo nfo = this.createBaseComponentInfo();
        return this.loadExtendedMetadata(nfo);
    }

    private DistributionType parseDistributionType() {
        String dtString = this.parseHeader("x-GraalVM-Component-Distribution", null).getContents(DistributionType.OPTIONAL.name());
        try {
            return DistributionType.valueOf(dtString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataException("x-GraalVM-Component-Distribution", this.feedback.l10n("ERROR_InvalidDistributionType", dtString));
        }
    }

    private void loadLicenseType(ComponentInfo nfo) {
        this.licenseType = this.parseHeader("x-GraalVM-License-Type", null).getContents(null);
        nfo.setLicenseType(this.licenseType);
        if (this.licenseType != null) {
            this.licensePath = this.parseHeader("x-GraalVM-License-Path").mustExist().getContents(null);
            nfo.setLicensePath(this.licensePath);
        }
    }

    @Override
    public String getLicensePath() {
        return this.licensePath;
    }

    @Override
    public String getLicenseID() {
        return null;
    }

    @Override
    public String getLicenseType() {
        return this.licenseType;
    }

    private void throwInvalidPermissions() {
        throw this.feedback.failure("ERROR_PermissionFormat", null, new Object[0]);
    }

    protected Map<String, String> parsePermissions(BufferedReader r) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Properties prop = new Properties();
        prop.load(r);
        ArrayList paths = new ArrayList(Collections.list(prop.propertyNames()));
        Collections.sort(paths);
        for (String k : paths) {
            SystemUtils.fromCommonRelative(k);
            String v = prop.getProperty(k, "").trim();
            if (!v.isEmpty()) {
                try {
                    PosixFilePermissions.fromString(v);
                }
                catch (IllegalArgumentException ex) {
                    this.throwInvalidPermissions();
                }
            }
            result.put(k, v);
        }
        return result;
    }

    @Override
    public Map<String, String> loadPermissions() throws IOException {
        return Collections.emptyMap();
    }

    protected Map<String, String> parseSymlinks(Properties links) {
        for (String key : new HashSet<String>(links.stringPropertyNames())) {
            Path p = SystemUtils.fromCommonRelative(key).normalize();
            String prop = (String)links.remove(key);
            links.setProperty(SystemUtils.toCommonPath(p), prop);
        }
        if (this.noVerifySymlinks) {
            return new HashMap<Object, Object>(links);
        }
        Iterator<String> iterator = Collections.list(links.propertyNames()).iterator();
        block1: while (iterator.hasNext()) {
            String s;
            String l = s = iterator.next();
            HashSet<String> seen = new HashSet<String>();
            while (l != null) {
                if (!seen.add(l)) {
                    throw this.feedback.failure("ERROR_CircularSymlink", null, l);
                }
                String target = links.getProperty(l);
                Path linkPath = SystemUtils.fromCommonRelative(l);
                SystemUtils.checkCommonRelative(linkPath, target);
                Path targetPath = linkPath.resolveSibling(target).normalize();
                String targetString = SystemUtils.toCommonPath(targetPath);
                if (this.fileList.contains(targetString)) continue block1;
                String lt = links.getProperty(targetString);
                if (lt == null) {
                    throw this.feedback.failure("ERROR_BrokenSymlink", null, target);
                }
                l = targetString;
            }
        }
        return new HashMap<Object, Object>(links);
    }

    @Override
    public Map<String, String> loadSymlinks() throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public void loadPaths() {
        this.getComponentInfo();
    }

    @Override
    public boolean isNoVerifySymlinks() {
        return this.noVerifySymlinks;
    }

    @Override
    public void setNoVerifySymlinks(boolean noVerifySymlinks) {
        this.noVerifySymlinks = noVerifySymlinks;
    }

    @Override
    public void close() throws IOException {
    }

    private void loadMessages(ComponentInfo nfo) {
        String val = this.parseHeader("x-GraalVM-Message-PostInst", null).getContents(null);
        if (val != null) {
            String text = val.replace("\\n", "\n").replace("\\\\", "\\");
            nfo.setPostinstMessage(text);
        }
    }

    protected void setLicensePath(String path) {
        this.licensePath = path;
        this.getComponentInfo().setLicensePath(this.licensePath);
    }

    protected void addFiles(List<String> files) {
        this.fileList.addAll(files);
    }

    @Override
    public ComponentInfo completeMetadata() throws IOException {
        return this.getComponentInfo();
    }
}

