/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.ComponentCollection;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.commands.AbstractInstaller;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.Verifier;

public class Installer
extends AbstractInstaller {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final Set<PosixFilePermission> DEFAULT_CHANGE_PERMISSION = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
    private final List<Path> filesToDelete = new ArrayList<Path>();
    private final List<Path> dirsToDelete = new ArrayList<Path>();
    private boolean rebuildPolyglot;
    private final Set<Path> visitedPaths = new HashSet<Path>();

    public Installer(Feedback feedback, FileOperations fileOps, ComponentInfo componentInfo, ComponentRegistry registry, ComponentCollection collection, Archive a) {
        super(feedback, fileOps, componentInfo, registry, collection, a);
    }

    @Override
    public void revertInstall() {
        if (this.isDryRun()) {
            return;
        }
        LOG.fine("Reverting installation");
        for (Path p : this.filesToDelete) {
            try {
                LOG.log(Level.FINE, "Deleting: {0}", p);
                this.feedback.verboseOutput("INSTALL_CleanupFile", p);
                this.fileOps.deleteFile(p);
            }
            catch (IOException ex) {
                this.feedback.error("INSTALL_CannotCleanupFile", ex, p, ex.getLocalizedMessage());
            }
        }
        Collections.reverse(this.dirsToDelete);
        for (Path p : this.dirsToDelete) {
            try {
                LOG.log(Level.FINE, "Deleting directory: {0}", p);
                this.feedback.verboseOutput("INSTALL_CleanupDirectory", p);
                this.fileOps.deleteFile(p);
            }
            catch (IOException ex) {
                this.feedback.error("INSTALL_CannotCleanupFile", ex, p, ex.getLocalizedMessage());
            }
        }
    }

    Path translateTargetPath(Archive.FileEntry entry) {
        return this.translateTargetPath(entry.getName());
    }

    Path translateTargetPath(String n) {
        return this.translateTargetPath(null, n);
    }

    Path translateTargetPath(Path base, String n) {
        Path rel = SystemUtils.fromCommonRelative(base, n);
        Path p = this.getInstallPath().resolve(rel).normalize();
        if (!p.startsWith(this.getInstallPath())) {
            throw new IllegalStateException(this.feedback.l10n("INSTALL_WriteOutsideGraalvm", p));
        }
        return p;
    }

    @Override
    public boolean validateAll() throws IOException {
        Verifier veri = this.validateRequirements();
        ComponentInfo existing = this.registry.findComponent(this.componentInfo.getId());
        if (existing != null && !veri.shouldInstall(this.componentInfo)) {
            return false;
        }
        this.validateFiles();
        this.validateSymlinks();
        return true;
    }

    @Override
    public void validateFiles() throws IOException {
        if (this.archive == null) {
            throw new UnsupportedOperationException();
        }
        for (Archive.FileEntry entry : this.archive) {
            if (entry.getName().startsWith("META-INF")) continue;
            this.feedback.verboseOutput("INSTALL_VerboseValidation", entry.getName());
            this.validateOneEntry(this.translateTargetPath(entry), entry);
        }
    }

    @Override
    public void validateSymlinks() throws IOException {
        Map<String, String> processSymlinks = this.getSymlinks();
        for (String sl : processSymlinks.keySet()) {
            Path target = this.fileOps.materialize(this.translateTargetPath(sl), true);
            if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) continue;
            this.checkLinkReplacement(target, this.translateTargetPath(target, processSymlinks.get(sl)));
        }
    }

    boolean validateOneEntry(Path target, Archive.FileEntry entry) throws IOException {
        boolean existingFile;
        if (entry.isDirectory()) {
            Path dirPath = this.fileOps.materialize(SystemUtils.resolveRelative(this.getInstallPath(), entry.getName()), false);
            if (Files.exists(dirPath, new LinkOption[0]) && !Files.isDirectory(dirPath, new LinkOption[0])) {
                throw new IOException(this.feedback.l10n("INSTALL_OverwriteWithDirectory", dirPath));
            }
            return true;
        }
        Path mt = this.fileOps.materialize(target, false);
        boolean bl = existingFile = mt != null && Files.exists(mt, LinkOption.NOFOLLOW_LINKS);
        if (existingFile) {
            return this.checkFileReplacement(mt, entry);
        }
        return false;
    }

    public void install() throws IOException {
        assert (this.archive != null) : "Must first download / set jar file";
        this.installContent();
        this.installFinish();
    }

    void installContent() throws IOException {
        if (this.archive == null) {
            throw new UnsupportedOperationException();
        }
        this.unpackFiles();
        this.archive.completeMetadata(this.componentInfo);
        this.processPermissions();
        this.createSymlinks();
        ArrayList<String> ll = new ArrayList<String>(this.getTrackedPaths());
        Collections.sort(ll);
        this.componentInfo.setPaths(ll);
        this.rebuildPolyglot = this.componentInfo.isPolyglotRebuild() || ll.stream().filter(p -> p.startsWith("lib/installer/components/polyglot/")).findAny().isPresent();
    }

    void installFinish() throws IOException {
        if (!this.isDryRun()) {
            this.registry.addComponent(this.getComponentInfo());
        }
    }

    void unpackFiles() throws IOException {
        String storagePrefix = "lib/installer/components/";
        for (Archive.FileEntry entry : this.archive) {
            String path = entry.getName();
            if (path.startsWith("lib/installer/components/") && path.length() > "lib/installer/components/".length() && path.indexOf(47, "lib/installer/components/".length()) == -1) continue;
            this.installOneEntry(entry);
        }
    }

    void ensurePathExists(Path targetPath) throws IOException {
        if (!this.visitedPaths.add(targetPath)) {
            return;
        }
        Path parent = this.getInstallPath();
        if (!targetPath.normalize().startsWith(parent)) {
            throw new IllegalStateException(this.feedback.l10n("INSTALL_WriteOutsideGraalvm", targetPath));
        }
        Path relative = this.getInstallPath().relativize(targetPath);
        int count = 0;
        for (Path n : relative) {
            Path relativeSubpath = relative.subpath(0, ++count);
            Path dir = this.fileOps.materialize(parent.resolve(n), true);
            String pathString = SystemUtils.toCommonPath(relativeSubpath) + "/";
            if (!Files.exists(dir, new LinkOption[0]) || this.getComponentDirectories().contains(pathString)) {
                this.feedback.verboseOutput("INSTALL_CreatingDirectory", dir);
                this.dirsToDelete.add(dir);
                this.addTrackedPath(pathString);
                if (!Files.exists(dir, new LinkOption[0]) && !this.isDryRun()) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
            }
            parent = dir;
        }
    }

    Path installOneEntry(Archive.FileEntry entry) throws IOException {
        if (entry.getName().startsWith("META-INF")) {
            return null;
        }
        Path targetPath = this.translateTargetPath(entry);
        boolean b = this.validateOneEntry(targetPath, entry);
        if (entry.isDirectory()) {
            this.ensurePathExists(targetPath);
            return targetPath;
        }
        String eName = entry.getName();
        if (b) {
            this.feedback.verboseOutput("INSTALL_SkipIdenticalFile", eName);
            return targetPath;
        }
        return this.installOneFile(targetPath, entry);
    }

    Path installOneFile(Path target, Archive.FileEntry entry) throws IOException {
        try (InputStream jarStream = this.archive.getInputStream(entry);){
            Path mt = this.fileOps.materialize(target, false);
            Path mt2 = this.fileOps.materialize(target, true);
            boolean existingFile = mt != null && Files.exists(mt, LinkOption.NOFOLLOW_LINKS);
            String eName = entry.getName();
            if (existingFile) {
                this.feedback.verboseOutput("INSTALL_ReplacingFile", eName);
            } else {
                this.filesToDelete.add(mt2);
                this.feedback.verboseOutput("INSTALL_InstallingFile", eName);
            }
            this.ensurePathExists(target.getParent());
            this.addTrackedPath(SystemUtils.toCommonPath(this.getInstallPath().relativize(target)));
            if (!this.isDryRun()) {
                this.fileOps.installFile(target, jarStream);
            }
        }
        return target;
    }

    @Override
    public void processPermissions() throws IOException {
        Map<String, String> setPermissions = this.getPermissions();
        ArrayList<String> paths = new ArrayList<String>(setPermissions.keySet());
        Collections.sort(paths);
        for (String s : paths) {
            Path target = this.getInstallPath().resolve(SystemUtils.fromCommonRelative(s));
            String permissionString = setPermissions.get(s);
            Set<PosixFilePermission> perms = permissionString != null && !"".equals(permissionString) ? PosixFilePermissions.fromString(permissionString) : DEFAULT_CHANGE_PERMISSION;
            if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) continue;
            this.fileOps.setPermissions(target, perms);
        }
    }

    @Override
    public void createSymlinks() throws IOException {
        if (SystemUtils.isWindows()) {
            return;
        }
        Map<String, String> makeSymlinks = this.getSymlinks();
        ArrayList<String> createdRelativeLinks = new ArrayList<String>();
        try {
            ArrayList<String> paths = new ArrayList<String>(makeSymlinks.keySet());
            Collections.sort(paths);
            Path instDir = this.getInstallPath();
            for (String s : paths) {
                Path target;
                Path result;
                Path parent;
                Path source = instDir.resolve(SystemUtils.fromCommonRelative(s));
                if (source == null || (parent = source.getParent()) == null || (result = parent.resolve(target = SystemUtils.fromCommonString(makeSymlinks.get(s)))) == null) continue;
                if (!(result = result.normalize()).startsWith(this.getInstallPath())) {
                    throw new IllegalStateException(this.feedback.l10n("INSTALL_SymlinkOutsideGraalvm", source, result));
                }
                this.ensurePathExists(source.getParent());
                createdRelativeLinks.add(s);
                this.addTrackedPath(s);
                if (Files.exists(source, LinkOption.NOFOLLOW_LINKS)) {
                    if (this.checkLinkReplacement(source, target)) {
                        this.feedback.verboseOutput("INSTALL_SkipIdenticalFile", s);
                        this.filesToDelete.add(source);
                        continue;
                    }
                    this.feedback.verboseOutput("INSTALL_ReplacingFile", s);
                    Files.delete(source);
                }
                this.filesToDelete.add(source);
                this.feedback.verboseOutput("INSTALL_CreatingSymlink", s, makeSymlinks.get(s));
                if (this.isDryRun()) continue;
                Files.createSymbolicLink(source, target, new FileAttribute[0]);
            }
        }
        catch (UnsupportedOperationException ex) {
            LOG.log(Level.INFO, "Symlinks not supported", ex);
        }
        this.componentInfo.addPaths(createdRelativeLinks);
    }

    boolean checkLinkReplacement(Path existingPath, Path target) throws IOException {
        boolean replace = this.isReplaceDiferentFiles();
        if (Files.exists(existingPath, LinkOption.NOFOLLOW_LINKS) && !Files.isSymbolicLink(existingPath)) {
            if (Files.isRegularFile(existingPath, new LinkOption[0]) && replace) {
                return false;
            }
            throw new IOException(this.feedback.l10n("INSTALL_OverwriteWithLink", existingPath));
        }
        Path p = Files.readSymbolicLink(existingPath);
        if (!target.equals(p)) {
            if (replace) {
                return false;
            }
            throw this.feedback.failure("INSTALL_ReplacedFileDiffers", null, existingPath);
        }
        return true;
    }

    boolean checkFileReplacement(Path existingPath, Archive.FileEntry entry) throws IOException {
        boolean replace = this.isReplaceDiferentFiles();
        if (Files.isDirectory(existingPath, new LinkOption[0])) {
            throw new IOException(this.feedback.l10n("INSTALL_OverwriteWithFile", existingPath));
        }
        if (!Files.isRegularFile(existingPath, new LinkOption[0]) || Files.size(existingPath) != entry.getSize()) {
            if (replace) {
                return false;
            }
            throw this.feedback.failure("INSTALL_ReplacedFileDiffers", null, existingPath);
        }
        try (SeekableByteChannel is = Files.newByteChannel(existingPath, new OpenOption[0]);){
            if (!this.archive.checkContentsMatches(is, entry)) {
                if (replace) {
                    boolean bl = false;
                    return bl;
                }
                throw this.feedback.failure("INSTALL_ReplacedFileDiffers", null, existingPath);
            }
        }
        return true;
    }

    @Override
    public boolean isRebuildPolyglot() {
        return this.rebuildPolyglot;
    }

    public String toString() {
        return "Installer[" + this.componentInfo.getId() + ":" + this.componentInfo.getName() + "=" + this.componentInfo.getVersion().displayString() + "]";
    }
}

