/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.model.ComponentRegistry;

public class SystemUtils {
    public static final char DELIMITER_CHAR = '/';
    public static final String DELIMITER = "/";
    private static final String DOT = ".";
    private static final String DOTDOT = "..";
    private static final String SPLIT_DELIMITER = Pattern.quote("/");
    private static final Pattern OLD_VERSION_PATTERN = Pattern.compile("([0-9]+\\.[0-9]+(\\.[0-9]+)?(\\.[0-9]+)?)(-([a-z]+)([0-9]+)?)?");
    static boolean licenseTracking = false;

    public static Path fromCommonString(String p) {
        String[] comps = p.split(SPLIT_DELIMITER);
        if (comps.length == 1) {
            return Paths.get(comps[0], new String[0]);
        }
        int l = comps.length - 1;
        String s = comps[0];
        System.arraycopy(comps, 1, comps, 0, l);
        comps[l] = "";
        return Paths.get(s, comps);
    }

    public static Path fromUserString(String p) {
        return Paths.get(p, new String[0]);
    }

    public static Path fileName(String s) {
        if (s.indexOf(47) >= 0 || '/' != File.separatorChar && s.indexOf(File.separatorChar) >= 0) {
            throw new IllegalArgumentException(s);
        }
        if (DOT.equals(s) || DOTDOT.equals(s)) {
            throw new IllegalArgumentException(s);
        }
        return Paths.get(s, new String[0]);
    }

    public static String toCommonPath(Path p) {
        StringBuilder sb = new StringBuilder();
        boolean next = false;
        for (Path comp : p) {
            if (next) {
                sb.append('/');
            }
            String compS = comp.toString();
            if (File.separatorChar != '/') {
                compS = compS.replace(File.separator, DELIMITER);
            }
            sb.append(compS);
            next = true;
        }
        return sb.toString();
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase(Locale.ENGLISH).contains("linux");
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase(Locale.ENGLISH).contains("mac");
    }

    public static Path fromCommonRelative(String p) {
        if (p == null) {
            return null;
        }
        return SystemUtils.fromArray(SystemUtils.checkRelativePath(null, p));
    }

    private static Path fromArray(String[] comps) {
        if (comps.length == 1) {
            return Paths.get(comps[0], new String[0]);
        }
        int l = comps.length - 1;
        String s = comps[0];
        System.arraycopy(comps, 1, comps, 0, l);
        comps[l] = "";
        return Paths.get(s, comps);
    }

    public static Path resolveRelative(Path baseDir, String p) {
        if (baseDir == null) {
            return null;
        }
        if (p == null) {
            return null;
        }
        String[] comps = SystemUtils.checkRelativePath(baseDir, p);
        return baseDir.resolve(SystemUtils.fromArray(comps));
    }

    public static Path fromCommonRelative(Path base, String p) {
        if (p == null) {
            return null;
        }
        if (base == null) {
            return SystemUtils.fromCommonRelative(p);
        }
        String[] comps = SystemUtils.checkRelativePath(base, p);
        return base.resolveSibling(SystemUtils.fromArray(comps));
    }

    public static void checkCommonRelative(Path base, String p) {
        if (p == null) {
            return;
        }
        SystemUtils.checkRelativePath(base, p);
    }

    private static String[] checkRelativePath(Path base, String p) {
        if (p.startsWith(DELIMITER)) {
            throw new IllegalArgumentException("Absolute path");
        }
        String[] comps = p.split(SPLIT_DELIMITER);
        int d = base == null ? 0 : base.normalize().getNameCount() - 1;
        int fromIndex = 0;
        int toIndex = 0;
        for (String s : comps) {
            if (s.isEmpty()) {
                ++fromIndex;
                continue;
            }
            if (DOTDOT.equals(s)) {
                if (--d < 0) {
                    throw new IllegalArgumentException("Relative path reaches above root");
                }
            } else {
                ++d;
            }
            if (toIndex < fromIndex) {
                comps[toIndex] = comps[fromIndex];
            }
            ++fromIndex;
            ++toIndex;
        }
        if (fromIndex == toIndex) {
            return comps;
        }
        String[] newcomps = new String[toIndex];
        System.arraycopy(comps, 0, newcomps, 0, toIndex);
        return newcomps;
    }

    public static String normalizeOldVersions(String v) {
        if (v == null) {
            return null;
        }
        Matcher m = OLD_VERSION_PATTERN.matcher(v);
        if (!m.matches()) {
            return v;
        }
        String numbers = m.group(1);
        String rel = m.group(5);
        String relNo = m.group(6);
        if (numbers.startsWith("0.")) {
            return v;
        }
        if (rel == null) {
            if (m.group(3) == null) {
                return numbers + ".0";
            }
            return numbers;
        }
        if (m.group(3) == null) {
            numbers = numbers + ".0";
        }
        return numbers + "-0." + rel + (relNo == null ? "" : DOT + relNo);
    }

    public static Path getGraalVMJDKRoot(ComponentRegistry reg) {
        if ("macos".equals(reg.getGraalCapabilities().get("os_name"))) {
            return Paths.get("Contents", "Home");
        }
        return Paths.get("", new String[0]);
    }

    public static String findFileOwner(Path file) throws IOException {
        PosixFileAttributeView posix = file.getFileSystem().provider().getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
        if (posix != null) {
            return posix.getOwner().getName();
        }
        AclFileAttributeView acl = file.getFileSystem().provider().getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
        if (acl != null) {
            return acl.getOwner().getName();
        }
        return null;
    }

    public static boolean isLicenseTrackingEnabled() {
        return licenseTracking;
    }

    public static String parseURLParameters(String s, Map<String, String> params) throws MalformedURLException {
        int q = s.indexOf(63);
        if (q == -1) {
            return s;
        }
        String queryString = s.substring(q + 1);
        for (String parSpec : queryString.split("&")) {
            String[] nameAndVal = parSpec.split("=");
            try {
                String n = URLDecoder.decode(nameAndVal[0], "UTF-8");
                if (n.isEmpty()) continue;
                String v = nameAndVal.length > 1 ? URLDecoder.decode(nameAndVal[1], "UTF-8") : "";
                params.put(n, v);
            }
            catch (UnsupportedEncodingException ex) {
                MalformedURLException newEx = new MalformedURLException(ex.getLocalizedMessage());
                newEx.initCause(ex);
                throw newEx;
            }
        }
        return s.substring(0, q);
    }

    public static int getJavaMajorVersion(CommandInput cmd) {
        String v;
        String string = v = cmd.getLocalRegistry() != null ? cmd.getLocalRegistry().getJavaVersion() : null;
        if (v == null) {
            cmd.getParameter("java.specification.version", true);
        }
        if (v != null) {
            return SystemUtils.interpretJavaMajorVersion(v);
        }
        return SystemUtils.getJavaMajorVersion();
    }

    public static int getJavaMajorVersion() {
        String v = System.getProperty("java.specification.version");
        return SystemUtils.interpretJavaMajorVersion(v);
    }

    public static int interpretJavaMajorVersion(String v) {
        String s = v.startsWith("1.") ? v.substring(2) : v;
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static Path getRuntimeLibDir(Path graalPath, boolean archDir) {
        Path newLibPath;
        Path base = SystemUtils.getRuntimeBaseDir(graalPath);
        switch (OS.get()) {
            case LINUX: {
                String arch = System.getProperty("os.arch");
                Path temp = base.resolve(Paths.get("lib", new String[0]));
                if (!archDir || SystemUtils.getJavaMajorVersion() >= 10) {
                    newLibPath = temp;
                    break;
                }
                newLibPath = temp.resolve(Paths.get(arch, new String[0]));
                break;
            }
            case MAC: {
                newLibPath = base.resolve(Paths.get("lib", new String[0]));
                break;
            }
            case WINDOWS: {
                newLibPath = base.resolve(Paths.get("bin", new String[0]));
                break;
            }
            default: {
                return null;
            }
        }
        return newLibPath;
    }

    public static Path getRuntimeBaseDir(Path jdkInstallDir) {
        int v = SystemUtils.getJavaMajorVersion();
        if (v >= 10) {
            return jdkInstallDir;
        }
        if (v > 0) {
            return jdkInstallDir.resolve("jre");
        }
        Path jre = jdkInstallDir.resolve("jre");
        if (Files.exists(jre, new LinkOption[0]) && Files.isDirectory(jre, new LinkOption[0])) {
            return jre;
        }
        return jdkInstallDir;
    }

    public static Path copySubtree(Path from, Path to) throws IOException {
        Files.walkFileTree(from, new CopyDirVisitor(from, to));
        return to;
    }

    public static byte[] toHashBytes(String hashS) {
        int s;
        boolean lenOK;
        boolean divided;
        String val = hashS.trim();
        if (val.length() < 4) {
            return null;
        }
        char c = val.charAt(2);
        boolean bl = divided = !(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f');
        if (divided) {
            lenOK = (val.length() + 1) % 3 == 0;
            s = (val.length() + 1) / 3;
        } else {
            lenOK = val.length() % 2 == 0;
            s = (val.length() + 1) / 2;
        }
        if (!lenOK) {
            return null;
        }
        byte[] digest = new byte[s];
        int dI = 0;
        int i = 0;
        while (i + 1 < val.length()) {
            int b;
            try {
                b = Integer.parseInt(val.substring(i, i + 2), 16);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            if (b < 0) {
                return null;
            }
            digest[dI++] = (byte)b;
            if (divided) {
                ++i;
            }
            i += 2;
        }
        return digest;
    }

    public static String fingerPrint(byte[] digest) {
        return SystemUtils.fingerPrint(digest, true);
    }

    public static String fingerPrint(byte[] digest, boolean delimiter) {
        if (digest == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(digest.length * 3);
        for (int i = 0; i < digest.length; ++i) {
            if (delimiter && i > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", digest[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String digestString(String s, boolean delimiters) {
        try {
            MessageDigest dg = MessageDigest.getInstance("SHA-256");
            dg.update(s.getBytes());
            byte[] digest = dg.digest();
            return SystemUtils.fingerPrint(digest, delimiters);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FailedOperationException(ex.getLocalizedMessage(), ex);
        }
    }

    public static String normalizeArchitecture(String os, String arch) {
        if (arch == null) {
            return null;
        }
        switch (arch.toLowerCase(Locale.ENGLISH)) {
            case "x86_64": {
                return "amd64";
            }
        }
        return arch.toLowerCase(Locale.ENGLISH);
    }

    public static String normalizeOSName(String os, String arch) {
        if (os == null) {
            return null;
        }
        switch (os.toLowerCase(Locale.ENGLISH)) {
            case "darwin": {
                return "macos";
            }
        }
        return os.toLowerCase(Locale.ENGLISH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] computeFileDigest(Path localFile, String digestAlgo) throws IOException {
        try (FileChannel s = FileChannel.open(localFile, StandardOpenOption.READ);){
            int r;
            ByteBuffer bb = ByteBuffer.allocate(4096);
            MessageDigest dg = MessageDigest.getInstance("SHA-256");
            for (long size = Files.size(localFile); size > 0L; size -= (long)r) {
                if ((long)bb.limit() > size) {
                    bb.limit((int)size);
                }
                if ((r = s.read(bb)) < 0) break;
                bb.flip();
                dg.update(bb);
                bb.clear();
            }
            byte[] byArray = dg.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }

    public static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption;

        public CopyDirVisitor(Path fromPath, Path toPath, StandardCopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        public CopyDirVisitor(Path fromPath, Path toPath) {
            this(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        UNKNOWN;


        public static OS get() {
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.isEmpty()) {
                String osNameLower = osName.toLowerCase(Locale.ENGLISH);
                if (osNameLower.contains("windows")) {
                    return WINDOWS;
                }
                if (osNameLower.contains("linux")) {
                    return LINUX;
                }
                if (osNameLower.contains("mac") || osNameLower.contains("darwin")) {
                    return MAC;
                }
            }
            return UNKNOWN;
        }
    }
}

