/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.ComponentInstaller;

public class SimpleGetopt {
    private LinkedList<String> parameters;
    private final Map<String, String> globalOptions;
    private final Map<String, Map<String, String>> commandOptions = new HashMap<String, Map<String, String>>();
    private final Map<String, String> optValues = new HashMap<String, String>();
    private final LinkedList<String> positionalParameters = new LinkedList();
    private String command;
    private boolean ignoreUnknownCommands;
    private boolean unknownCommand;
    private List<String> unknownOptions;
    private Map<String, String> abbreviations = new HashMap<String, String>();
    private final Map<String, Map<String, String>> commandAbbreviations = new HashMap<String, Map<String, String>>();
    private static final String NO_ABBREV = "**no-abbrev";

    public SimpleGetopt(Map<String, String> globalOptions) {
        this.globalOptions = globalOptions;
    }

    public void setParameters(LinkedList<String> parameters) {
        this.parameters = parameters;
    }

    public SimpleGetopt ignoreUnknownOptions(boolean ignore) {
        this.unknownOptions = ignore ? new ArrayList() : null;
        return this;
    }

    public SimpleGetopt ignoreUnknownCommands(boolean ignore) {
        this.ignoreUnknownCommands = ignore;
        return this;
    }

    public List<String> getUnknownOptions() {
        return this.unknownOptions == null ? Collections.emptyList() : this.unknownOptions;
    }

    public RuntimeException err(String messageKey, Object ... args) {
        throw ComponentInstaller.err(messageKey, args);
    }

    private String findCommand(String cmdString) {
        String cmd = cmdString;
        if (cmd.isEmpty()) {
            if (this.ignoreUnknownCommands) {
                return null;
            }
            throw this.err("ERROR_MissingCommand", new Object[0]);
        }
        String selCommand = null;
        for (String s : this.commandOptions.keySet()) {
            if (!s.startsWith(cmdString)) continue;
            if (selCommand != null) {
                throw this.err("ERROR_AmbiguousCommand", cmdString, selCommand, s);
            }
            selCommand = s;
            if (s.length() != cmdString.length()) continue;
            break;
        }
        if (selCommand == null) {
            if (this.ignoreUnknownCommands) {
                this.unknownCommand = true;
                this.command = cmdString;
                return null;
            }
            throw this.err("ERROR_UnknownCommand", cmdString);
        }
        this.command = selCommand;
        return this.command;
    }

    private boolean hasCommand() {
        return this.command != null && !this.unknownCommand;
    }

    Map<String, String> computeAbbreviations(Collection<String> optNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String o : optNames) {
            if (o.length() < 2) continue;
            result.put(o, NO_ABBREV);
            for (int i = 2; i < o.length(); ++i) {
                String s = o.substring(0, i);
                String fullName = (String)result.get(s);
                if (fullName == null) {
                    result.put(s, o);
                    continue;
                }
                result.put(s, NO_ABBREV);
            }
        }
        Iterator ens = result.entrySet().iterator();
        while (ens.hasNext()) {
            Map.Entry en = ens.next();
            if (!NO_ABBREV.equals(en.getValue())) continue;
            ens.remove();
        }
        return result;
    }

    Collection<String> getAllOptions() {
        HashSet<String> s = new HashSet<String>();
        s.addAll(this.globalOptions.keySet());
        for (Map<String, String> cmdOpts : this.commandOptions.values()) {
            s.addAll(cmdOpts.keySet());
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String opt = (String)it.next();
            if (opt.length() != 1 || Character.isLetterOrDigit(opt.charAt(0))) continue;
            it.remove();
        }
        return s;
    }

    void computeAbbreviations() {
        this.abbreviations = this.computeAbbreviations(this.globalOptions.keySet());
        for (String c : this.commandOptions.keySet()) {
            HashSet<String> names = new HashSet<String>(this.commandOptions.get(c).keySet());
            names.addAll(this.globalOptions.keySet());
            Map<String, String> commandAbbrevs = this.computeAbbreviations(names);
            this.commandAbbreviations.put(c, commandAbbrevs);
        }
    }

    public void process() {
        String p;
        this.computeAbbreviations();
        block0: while ((p = this.parameters.peek()) != null) {
            if (!p.startsWith("-")) {
                if (this.command == null) {
                    this.findCommand(this.parameters.poll());
                    Map<String, String> cOpts = this.commandOptions.get(this.command);
                    if (cOpts != null) {
                        for (String s : this.optValues.keySet()) {
                            if (s.length() > 1 || !"X".equals(cOpts.get(s))) continue;
                            this.unknownOption(s, this.command);
                            break;
                        }
                        if (!cOpts.containsKey("*")) continue;
                        this.positionalParameters.addAll(this.parameters);
                        break;
                    }
                    this.positionalParameters.add(p);
                    continue;
                }
                this.positionalParameters.add(this.parameters.poll());
                continue;
            }
            if (p.length() == 1 || "--".equals(p)) {
                this.parameters.poll();
                this.positionalParameters.addAll(this.parameters);
                break;
            }
            String param = this.parameters.poll();
            boolean nextParam = p.startsWith("--");
            int optCharIndex = 1;
            while (optCharIndex < param.length()) {
                String optName;
                if (nextParam) {
                    optName = param.substring(2);
                    param = this.processOptSpec(optName, optCharIndex, param, nextParam);
                } else {
                    optName = param.substring(optCharIndex, optCharIndex + 1);
                    param = this.processOptSpec(optName, optCharIndex += optName.length(), param, nextParam);
                }
                if (this.optValues.get("h") != null) {
                    return;
                }
                if (!nextParam) continue;
                continue block0;
            }
        }
    }

    private void unknownOption(String option, String cmd) {
        if (this.unknownOptions == null) {
            if (cmd == null) {
                throw this.err("ERROR_UnsupportedGlobalOption", option);
            }
            throw this.err("ERROR_UnsupportedOption", option, cmd);
        }
        this.unknownOptions.add(option);
    }

    private String processOptSpec(String o, int optCharIndex, String optParam, boolean nextParam) {
        String param = optParam;
        String optSpec = null;
        String optName = o;
        Map<String, String> cmdSpec = null;
        if (this.hasCommand()) {
            String c;
            Map<String, String> cmdAbbrevs = this.commandAbbreviations.get(this.command);
            String fullO = cmdAbbrevs.get(optName);
            if (fullO != null) {
                optName = fullO;
            }
            if ((c = (cmdSpec = this.commandOptions.get(this.command)).get(optName)) != null && optName.length() > 1) {
                optSpec = cmdSpec.get(c);
                optName = c;
            } else {
                optSpec = c;
            }
        }
        if (optSpec == null) {
            String c;
            String fullO = this.abbreviations.get(optName);
            if (fullO != null) {
                optName = fullO;
            }
            if ((c = this.globalOptions.get(optName)) != null && optName.length() > 1) {
                optSpec = this.globalOptions.get(c);
                optName = c;
            } else {
                optSpec = c;
            }
        }
        if (optSpec != null && optSpec.startsWith("=")) {
            String s = optSpec.substring(1);
            String nspec = null;
            if (cmdSpec != null) {
                nspec = (String)cmdSpec.get(s);
            }
            if (nspec == null) {
                nspec = this.globalOptions.get(s);
            }
            if (nspec != null) {
                optSpec = nspec;
                optName = s;
            }
        }
        if (optSpec == null) {
            if (this.unknownCommand) {
                return param;
            }
            this.unknownOption(optName, this.command);
            return param;
        }
        String optVal = "";
        switch (optSpec) {
            case "s": {
                if (nextParam) {
                    optVal = this.parameters.poll();
                    if (optVal != null) break;
                    throw this.err("ERROR_OptionNeedsParameter", o, this.command);
                }
                if (optCharIndex < param.length()) {
                    optVal = param.substring(optCharIndex);
                    param = "";
                    break;
                }
                if (this.parameters.isEmpty()) {
                    throw this.err("ERROR_OptionNeedsParameter", o, this.command);
                }
                optVal = this.parameters.poll();
                break;
            }
            case "X": {
                this.unknownOption(o, this.command);
                return param;
            }
        }
        this.optValues.put(optName, optVal);
        return param;
    }

    public String getCommand() {
        return this.command;
    }

    public void addCommandOptions(String commandName, Map<String, String> optSpec) {
        this.commandOptions.put(commandName, new HashMap<String, String>(optSpec));
    }

    void addCommandOption(String commandName, String optName, String optVal) {
        this.commandOptions.get(commandName).put(optName, optVal);
    }

    public Map<String, String> getOptValues() {
        return this.optValues;
    }

    public LinkedList<String> getPositionalParameters() {
        return this.positionalParameters;
    }
}

