/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.ComponentIterable;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileIterable;
import org.graalvm.component.installer.FileOperations;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.NonInteractiveException;
import org.graalvm.component.installer.UserAbortException;
import org.graalvm.component.installer.model.ComponentRegistry;

public class Environment
implements Feedback,
CommandInput {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.graalvm.component.installer.Bundle");
    private final String commandName;
    private final LinkedList<String> parameters;
    private final Map<String, String> options;
    private final boolean verbose;
    private final ResourceBundle bundle;
    private int parameterPos;
    private InputStream in = System.in;
    private PrintStream err = System.err;
    private PrintStream out = System.out;
    private ComponentRegistry localRegistry;
    private boolean stacktraces;
    private ComponentIterable fileIterable;
    private Map<URL, Path> fileMap = new HashMap<URL, Path>();
    private boolean allOutputToErr;
    private boolean autoYesEnabled;
    private boolean nonInteractive;
    private Path graalHome;
    private FileOperations fileOperations;
    private CommandInput.CatalogFactory catalogFactory;
    private ComponentCatalog componentCatalog;

    Environment(String commandName, List<String> parameters, Map<String, String> options) {
        this(commandName, (String)null, parameters, options);
    }

    Environment(String commandName, InstallerCommand cmdInstance, List<String> parameters, Map<String, String> options) {
        this(commandName, Environment.makeBundle(cmdInstance), parameters, options);
    }

    public void setIn(InputStream input) {
        this.in = input;
    }

    private static String makeBundle(InstallerCommand cmdInstance) {
        if (cmdInstance == null) {
            return null;
        }
        String s = cmdInstance.getClass().getName();
        s = s.substring(0, s.lastIndexOf(46));
        return s;
    }

    public Environment(String commandName, String bundlePackage, List<String> parameters, Map<String, String> options) {
        this.commandName = commandName;
        this.parameters = new LinkedList<String>(parameters);
        this.options = options;
        this.verbose = options.containsKey("v");
        this.stacktraces = options.containsKey("e");
        this.bundle = bundlePackage != null ? ResourceBundle.getBundle(bundlePackage + ".Bundle") : BUNDLE;
        this.fileIterable = new FileIterable(this, this);
    }

    Environment enableStacktraces() {
        this.stacktraces = true;
        return this;
    }

    public boolean isAutoYesEnabled() {
        return this.autoYesEnabled;
    }

    public void setAutoYesEnabled(boolean autoYesEnabled) {
        this.autoYesEnabled = autoYesEnabled;
    }

    public boolean isNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public boolean isAllOutputToErr() {
        return this.allOutputToErr;
    }

    public void setAllOutputToErr(boolean allOutputToErr) {
        this.allOutputToErr = allOutputToErr;
        this.out = allOutputToErr ? this.err : System.out;
    }

    public void setFileIterable(ComponentIterable fileIterable) {
        this.fileIterable = fileIterable;
    }

    public void setCatalogFactory(CommandInput.CatalogFactory catalogFactory) {
        this.catalogFactory = catalogFactory;
    }

    @Override
    public ComponentCatalog getRegistry() {
        if (this.componentCatalog == null) {
            this.componentCatalog = this.catalogFactory.createComponentCatalog(this, this.getLocalRegistry());
        }
        return this.componentCatalog;
    }

    @Override
    public ComponentRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public void setLocalRegistry(ComponentRegistry r) {
        this.localRegistry = r;
    }

    public void setGraalHome(Path f) {
        this.graalHome = f.normalize();
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    @Override
    public void error(String bundleKey, Throwable error, Object ... args) {
        this.print(false, this.bundle, this.err, bundleKey, args);
        if (this.stacktraces && error != null) {
            error.printStackTrace(this.err);
        }
    }

    @Override
    public RuntimeException failure(String bundleKey, Throwable error, Object ... args) {
        return new FailedOperationException(Environment.createMessage(this.bundle, bundleKey, args), error);
    }

    @Override
    public void message(String bundleKey, Object ... args) {
        this.print(false, this.bundle, this.err, bundleKey, args);
    }

    @Override
    public boolean verbosePart(String bundleKey, Object ... args) {
        if (bundleKey != null) {
            this.print(true, false, this.bundle, this.out, bundleKey, args);
        }
        return this.verbose;
    }

    @Override
    public void output(String bundleKey, Object ... args) {
        this.print(false, this.bundle, this.out, bundleKey, args);
    }

    @Override
    public void outputPart(String bundleKey, Object ... args) {
        this.print(false, false, this.bundle, this.out, bundleKey, args);
    }

    @Override
    public boolean verboseOutput(String bundleKey, Object ... args) {
        if (bundleKey != null) {
            this.print(true, this.bundle, this.out, bundleKey, args);
        }
        return this.verbose;
    }

    @Override
    public String l10n(String bundleKey, Object ... args) {
        return Environment.createMessage(this.bundle, bundleKey, args);
    }

    @Override
    public boolean verbatimOut(String msg, boolean beVerbose) {
        this.print(beVerbose, true, null, this.out, msg, new Object[0]);
        return beVerbose;
    }

    @Override
    public boolean verbatimPart(String msg, boolean beVerbose) {
        this.print(beVerbose, false, null, this.out, msg, new Object[0]);
        return beVerbose;
    }

    @Override
    public boolean verbatimPart(String msg, boolean error, boolean beVerbose) {
        this.print(beVerbose, false, null, error ? this.err : this.out, msg, new Object[0]);
        return beVerbose;
    }

    @Override
    public boolean backspace(int chars, boolean beVerbose) {
        if (beVerbose && !this.verbose) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars; ++i) {
            sb.append('\b');
        }
        this.verbatimPart(sb.toString(), beVerbose);
        return this.verbose;
    }

    @Override
    public <T> Feedback withBundle(Class<T> clazz) {
        String s = clazz.getName();
        s = s.substring(0, s.lastIndexOf(46));
        final ResourceBundle localBundle = ResourceBundle.getBundle(s + ".Bundle");
        return new Feedback(){

            @Override
            public void message(String bundleKey, Object ... params) {
                Environment.this.print(false, localBundle, Environment.this.err, bundleKey, params);
            }

            @Override
            public void output(String bundleKey, Object ... params) {
                Environment.this.print(false, localBundle, Environment.this.out, bundleKey, params);
            }

            @Override
            public boolean verbosePart(String bundleKey, Object ... params) {
                if (bundleKey != null) {
                    Environment.this.print(true, false, localBundle, Environment.this.out, bundleKey, params);
                }
                return Environment.this.verbose;
            }

            @Override
            public boolean verboseOutput(String bundleKey, Object ... params) {
                if (bundleKey != null) {
                    Environment.this.print(true, localBundle, Environment.this.out, bundleKey, params);
                }
                return Environment.this.verbose;
            }

            @Override
            public boolean verbatimOut(String msg, boolean verboseOutput) {
                Environment.this.print(verboseOutput, null, Environment.this.out, msg, new Object[0]);
                return verboseOutput;
            }

            @Override
            public void error(String key, Throwable t, Object ... params) {
                Environment.this.print(false, localBundle, Environment.this.err, key, params);
                if (Environment.this.stacktraces && t != null) {
                    t.printStackTrace(Environment.this.err);
                }
            }

            @Override
            public String l10n(String key, Object ... params) {
                return Environment.createMessage(localBundle, key, params);
            }

            @Override
            public RuntimeException failure(String key, Throwable t, Object ... params) {
                return new FailedOperationException(Environment.createMessage(localBundle, key, params), t);
            }

            public <X> Feedback withBundle(Class<X> anotherClazz) {
                return Environment.this.withBundle(anotherClazz);
            }

            @Override
            public void outputPart(String bundleKey, Object ... params) {
                Environment.this.print(false, false, localBundle, Environment.this.out, bundleKey, params);
            }

            @Override
            public boolean verbatimPart(String msg, boolean verboseOutput) {
                Environment.this.print(verboseOutput, false, null, Environment.this.out, msg, new Object[0]);
                return Environment.this.verbose;
            }

            @Override
            public boolean verbatimPart(String msg, boolean error, boolean verboseOutput) {
                Environment.this.print(verboseOutput, false, null, error ? Environment.this.err : Environment.this.out, msg, new Object[0]);
                return Environment.this.verbose;
            }

            @Override
            public boolean backspace(int chars, boolean beVerbose) {
                return Environment.this.backspace(chars, beVerbose);
            }

            @Override
            public String acceptLine(boolean autoYes) {
                return Environment.this.acceptLine(autoYes);
            }

            @Override
            public char[] acceptPassword() {
                return Environment.this.acceptPassword();
            }

            @Override
            public void addLocalFileCache(URL location, Path local) {
                Environment.this.addLocalFileCache(location, local);
            }

            @Override
            public Path getLocalCache(URL location) {
                return Environment.this.getLocalCache(location);
            }
        };
    }

    private static String createMessage(ResourceBundle bundle, String bundleKey, Object ... args) {
        if (bundle == null) {
            return bundleKey;
        }
        if (args == null) {
            return bundle.getString(bundleKey);
        }
        for (int i = 0; i < args.length; ++i) {
            Object v;
            Object o = args[i];
            if (!(o instanceof Supplier) || (v = ((Supplier)o).get()) != null && !(v instanceof String)) continue;
            args[i] = v;
        }
        if (bundleKey == null) {
            return String.valueOf(args[0]);
        }
        return MessageFormat.format(bundle.getString(bundleKey), args);
    }

    private void print(boolean beVerbose, ResourceBundle msgBundle, PrintStream stm, String bundleKey, Object ... args) {
        if (beVerbose && !this.verbose) {
            return;
        }
        this.print(beVerbose, true, msgBundle, stm, bundleKey, args);
    }

    private void print(boolean beVerbose, boolean addNewline, ResourceBundle msgBundle, PrintStream stm, String bundleKey, Object ... args) {
        if (beVerbose && !this.verbose) {
            return;
        }
        if (addNewline) {
            stm.println(Environment.createMessage(msgBundle, bundleKey, args));
            stm.flush();
        } else {
            stm.print(Environment.createMessage(msgBundle, bundleKey, args));
            stm.flush();
        }
    }

    @Override
    public Path getGraalHomePath() {
        return this.graalHome;
    }

    @Override
    public String nextParameter() {
        if (this.parameterPos >= this.parameters.size()) {
            return null;
        }
        return this.parameters.get(this.parameterPos++);
    }

    @Override
    public String peekParameter() {
        if (this.parameterPos >= this.parameters.size()) {
            return null;
        }
        return this.parameters.get(this.parameterPos);
    }

    @Override
    public String requiredParameter() {
        if (!this.hasParameter()) {
            throw new FailedOperationException(MessageFormat.format(BUNDLE.getString("ERROR_MissingParameter"), this.commandName));
        }
        return this.nextParameter();
    }

    @Override
    public boolean hasParameter() {
        return this.parameters.size() > this.parameterPos;
    }

    @Override
    public ComponentIterable existingFiles() {
        return this.fileIterable;
    }

    @Override
    public String optValue(String optName) {
        return this.options.get(optName);
    }

    public char acceptCharacter() {
        try {
            int input = this.in.read();
            if (input == -1) {
                throw new UserAbortException();
            }
            return (char)input;
        }
        catch (EOFException ex) {
            throw new UserAbortException(ex);
        }
        catch (IOException ex) {
            throw this.withBundle(Environment.class).failure("ERROR_UserInput", ex, ex.getMessage());
        }
    }

    @Override
    public String acceptLine(boolean autoYes) {
        char c;
        if (autoYes && this.isAutoYesEnabled()) {
            return "<automatic-yes>";
        }
        if (this.isNonInteractive()) {
            throw new NonInteractiveException(this.withBundle(Environment.class).l10n("ERROR_NoninteractiveInput", new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        while ((c = this.acceptCharacter()) != '\n') {
            if (c == '\b') {
                sb.delete(sb.length() - 1, sb.length());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public char[] acceptPassword() {
        if (this.isNonInteractive()) {
            throw new NonInteractiveException(this.withBundle(Environment.class).l10n("ERROR_NoninteractiveInput", new Object[0]));
        }
        Console console = System.console();
        if (console != null) {
            console.flush();
            return console.readPassword();
        }
        return this.acceptLine(false).toCharArray();
    }

    @Override
    public void addLocalFileCache(URL location, Path local) {
        this.fileMap.put(location, local);
    }

    @Override
    public Path getLocalCache(URL location) {
        return this.fileMap.get(location);
    }

    @Override
    public FileOperations getFileOperations() {
        return this.fileOperations;
    }

    public void setFileOperations(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public boolean close() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
        if (this.fileOperations != null) {
            return this.fileOperations.flush();
        }
        return false;
    }

    @Override
    public CommandInput.CatalogFactory getCatalogFactory() {
        return this.catalogFactory;
    }

    public void resetParameters() {
        this.parameterPos = 0;
    }

    @Override
    public String getParameter(String key, boolean cmdLine) {
        if (cmdLine) {
            return System.getProperty(key);
        }
        return System.getenv(key.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Map<String, String> parameters(boolean cmdLine) {
        if (cmdLine) {
            HashMap<String, String> res = new HashMap<String, String>();
            for (String s : System.getProperties().stringPropertyNames()) {
                res.put(s, System.getProperty(s));
            }
            return res;
        }
        return System.getenv();
    }
}

