/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class JComponentBuilders {
    JComponentBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JLabel.class.getName())) {
            return new JLabelBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPanel.class.getName())) {
            return new JPanelBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JToolBar.class.getName())) {
            return new JToolBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Box.Filler.class.getName())) {
            return new BoxFillerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Box.class.getName())) {
            return new BoxBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JScrollBar.class.getName())) {
            return new JScrollBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JToolBar.Separator.class.getName())) {
            return new JToolBarSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPopupMenu.Separator.class.getName())) {
            return new JPopupMenuSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSeparator.class.getName())) {
            return new JSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JProgressBar.class.getName())) {
            return new JProgressBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSlider.class.getName())) {
            return new JSliderBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSpinner.class.getName())) {
            return new JSpinnerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPopupMenu.class.getName())) {
            return new JPopupMenuBuilder(instance, heap);
        }
        return null;
    }

    private static Number getNumber(Instance number, Heap heap) {
        if (!DetailsUtils.isSubclassOf(number, Number.class.getName())) {
            return null;
        }
        String _number = DetailsUtils.getInstanceString(number, heap);
        if (_number == null || _number.isEmpty()) {
            return null;
        }
        try {
            if (DetailsUtils.isSubclassOf(number, Integer.class.getName())) {
                return Integer.valueOf(_number);
            }
            if (DetailsUtils.isSubclassOf(number, Byte.class.getName())) {
                return Byte.valueOf(_number);
            }
            if (DetailsUtils.isSubclassOf(number, Short.class.getName())) {
                return Short.valueOf(_number);
            }
            if (DetailsUtils.isSubclassOf(number, Long.class.getName())) {
                return Long.valueOf(_number);
            }
            if (DetailsUtils.isSubclassOf(number, Float.class.getName())) {
                return Float.valueOf(_number);
            }
            if (DetailsUtils.isSubclassOf(number, Double.class.getName())) {
                return Double.valueOf(_number);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static class JPopupMenuBuilder
    extends ComponentBuilders.JComponentBuilder<JPopupMenu> {
        private final String label;
        private final boolean paintBorder;

        JPopupMenuBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.label = Utils.getFieldString(instance, "label");
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
        }

        @Override
        protected void setupInstance(JPopupMenu instance) {
            super.setupInstance(instance);
            if (this.label != null) {
                instance.setLabel(this.label);
            }
            instance.setBorderPainted(this.paintBorder);
        }

        @Override
        protected JPopupMenu createInstanceImpl() {
            return new Utils.JPopupMenuImpl();
        }
    }

    private static class JSpinnerBuilder
    extends ComponentBuilders.JComponentBuilder<JSpinner> {
        private Number value;

        JSpinnerBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            Object _value;
            Number val = null;
            Object model = instance.getValueOfField("model");
            if (model instanceof Instance && (_value = ((Instance)model).getValueOfField("value")) instanceof Instance) {
                val = JComponentBuilders.getNumber((Instance)_value, heap);
            }
            this.value = val;
        }

        @Override
        protected void setupInstance(JSpinner instance) {
            super.setupInstance(instance);
            if (this.value != null) {
                instance.setValue(this.value);
            }
        }

        @Override
        protected JSpinner createInstanceImpl() {
            return new JSpinner();
        }
    }

    private static class JSliderBuilder
    extends ComponentBuilders.JComponentBuilder<JSlider> {
        private final boolean paintTicks;
        private final boolean paintTrack;
        private final boolean paintLabels;
        private final boolean isInverted;
        private final DefaultBoundedRangeModelBuilder sliderModel;
        private final int majorTickSpacing;
        private final int minorTickSpacing;
        private final boolean snapToTicks;
        private final int orientation;

        JSliderBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.paintTicks = DetailsUtils.getBooleanFieldValue(instance, "paintTicks", false);
            this.paintTrack = DetailsUtils.getBooleanFieldValue(instance, "paintTrack", true);
            this.paintLabels = DetailsUtils.getBooleanFieldValue(instance, "paintLabels", false);
            this.isInverted = DetailsUtils.getBooleanFieldValue(instance, "isInverted", false);
            this.sliderModel = DefaultBoundedRangeModelBuilder.fromField(instance, "sliderModel", heap);
            this.majorTickSpacing = DetailsUtils.getIntFieldValue(instance, "majorTickSpacing", 0);
            this.minorTickSpacing = DetailsUtils.getIntFieldValue(instance, "minorTickSpacing", 0);
            this.snapToTicks = DetailsUtils.getBooleanFieldValue(instance, "snapToTicks", false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected void setupInstance(JSlider instance) {
            super.setupInstance(instance);
            instance.setPaintTicks(this.paintTicks);
            instance.setPaintTrack(this.paintTrack);
            instance.setPaintLabels(this.paintLabels);
            instance.setInverted(this.isInverted);
            if (this.sliderModel != null) {
                instance.setModel((BoundedRangeModel)this.sliderModel.createInstance());
            }
            instance.setMajorTickSpacing(this.majorTickSpacing);
            instance.setMinorTickSpacing(this.minorTickSpacing);
            instance.setSnapToTicks(this.snapToTicks);
        }

        @Override
        protected JSlider createInstanceImpl() {
            return new JSlider(this.orientation);
        }
    }

    private static class JProgressBarBuilder
    extends ComponentBuilders.JComponentBuilder<JProgressBar> {
        private final int orientation;
        private final boolean paintBorder;
        private final DefaultBoundedRangeModelBuilder model;
        private final String progressString;
        private final boolean paintString;
        private final boolean indeterminate;

        JProgressBarBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.model = DefaultBoundedRangeModelBuilder.fromField(instance, "model", heap);
            this.progressString = Utils.getFieldString(instance, "progressString");
            this.paintString = DetailsUtils.getBooleanFieldValue(instance, "paintString", false);
            this.indeterminate = DetailsUtils.getBooleanFieldValue(instance, "indeterminate", false);
        }

        @Override
        protected void setupInstance(JProgressBar instance) {
            super.setupInstance(instance);
            instance.setBorderPainted(this.paintBorder);
            if (this.model != null) {
                instance.setModel((BoundedRangeModel)this.model.createInstance());
            }
            if (this.progressString != null) {
                instance.setString(this.progressString);
            }
            instance.setStringPainted(this.paintString);
            instance.setIndeterminate(this.indeterminate);
        }

        @Override
        protected JProgressBar createInstanceImpl() {
            return new JProgressBar(this.orientation);
        }
    }

    private static class JPopupMenuSeparatorBuilder
    extends JSeparatorBuilder {
        JPopupMenuSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return new JPopupMenu.Separator();
        }
    }

    private static class JToolBarSeparatorBuilder
    extends JSeparatorBuilder {
        private final BaseBuilders.DimensionBuilder separatorSize;

        JToolBarSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.separatorSize = BaseBuilders.DimensionBuilder.fromField(instance, "separatorSize", heap);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return this.separatorSize == null ? new JToolBar.Separator() : new JToolBar.Separator((Dimension)this.separatorSize.createInstance());
        }
    }

    private static class JSeparatorBuilder
    extends ComponentBuilders.JComponentBuilder<JSeparator> {
        private final int orientation;

        JSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return new JSeparator(this.orientation);
        }
    }

    private static class JScrollBarBuilder
    extends ComponentBuilders.JComponentBuilder<JScrollBar> {
        private final DefaultBoundedRangeModelBuilder model;
        private final int orientation;

        JScrollBarBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.model = DefaultBoundedRangeModelBuilder.fromField(instance, "model", heap);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
        }

        static JScrollBarBuilder fromField(Instance instance, String field, Heap heap) {
            Object insets = instance.getValueOfField(field);
            if (!(insets instanceof Instance)) {
                return null;
            }
            return new JScrollBarBuilder((Instance)insets, heap);
        }

        @Override
        protected void setupInstance(JScrollBar instance) {
            super.setupInstance(instance);
            if (this.model != null) {
                instance.setModel((BoundedRangeModel)this.model.createInstance());
            }
        }

        @Override
        protected JScrollBar createInstanceImpl() {
            return new JScrollBar(this.orientation);
        }
    }

    private static class DefaultBoundedRangeModelBuilder
    extends Utils.InstanceBuilder<DefaultBoundedRangeModel> {
        private final int value;
        private final int extent;
        private final int min;
        private final int max;

        DefaultBoundedRangeModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.value = DetailsUtils.getIntFieldValue(instance, "value", 0);
            this.extent = DetailsUtils.getIntFieldValue(instance, "extent", 0);
            this.min = DetailsUtils.getIntFieldValue(instance, "min", 0);
            this.max = DetailsUtils.getIntFieldValue(instance, "max", 100);
        }

        static DefaultBoundedRangeModelBuilder fromField(Instance instance, String field, Heap heap) {
            Object model = instance.getValueOfField(field);
            if (!(model instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)model, DefaultBoundedRangeModel.class.getName())) {
                return null;
            }
            return new DefaultBoundedRangeModelBuilder((Instance)model, heap);
        }

        @Override
        protected DefaultBoundedRangeModel createInstanceImpl() {
            return new DefaultBoundedRangeModel(this.value, this.extent, this.min, this.max);
        }
    }

    private static class BoxFillerBuilder
    extends ComponentBuilders.JComponentBuilder<Box.Filler> {
        BoxFillerBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected Box.Filler createInstanceImpl() {
            return new Box.Filler(null, null, null);
        }
    }

    private static class BoxBuilder
    extends ComponentBuilders.JComponentBuilder<Box> {
        BoxBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected Box createInstanceImpl() {
            return new Box(0){

                @Override
                public void layout() {
                }

                @Override
                public void setLayout(LayoutManager l) {
                }
            };
        }
    }

    private static class JToolBarBuilder
    extends ComponentBuilders.JComponentBuilder<JToolBar> {
        private final boolean paintBorder;
        private final BaseBuilders.InsetsBuilder margin;
        private final boolean floatable;
        private final int orientation;

        JToolBarBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
            this.floatable = DetailsUtils.getBooleanFieldValue(instance, "floatable", true);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected void setupInstance(JToolBar instance) {
            super.setupInstance(instance);
            instance.setBorderPainted(this.paintBorder);
            if (this.margin != null) {
                instance.setMargin((Insets)this.margin.createInstance());
            }
            instance.setFloatable(this.floatable);
            instance.setOrientation(this.orientation);
        }

        @Override
        protected JToolBar createInstanceImpl() {
            return new JToolBar();
        }
    }

    private static class JPanelBuilder
    extends ComponentBuilders.JComponentBuilder<JPanel> {
        JPanelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JPanel createInstanceImpl() {
            return new JPanel(null);
        }
    }

    private static final class JLabelBuilder
    extends ComponentBuilders.JComponentBuilder<JLabel> {
        private final String text;
        private final BaseBuilders.IconBuilder defaultIcon;
        private final int verticalAlignment;
        private final int horizontalAlignment;
        private final int verticalTextPosition;
        private final int horizontalTextPosition;
        private final int iconTextGap;

        JLabelBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.text = Utils.getFieldString(instance, "text");
            this.defaultIcon = BaseBuilders.IconBuilder.fromField(instance, "defaultIcon", heap);
            this.verticalAlignment = DetailsUtils.getIntFieldValue(instance, "verticalAlignment", 0);
            this.horizontalAlignment = DetailsUtils.getIntFieldValue(instance, "horizontalAlignment", 10);
            this.verticalTextPosition = DetailsUtils.getIntFieldValue(instance, "verticalTextPosition", 0);
            this.horizontalTextPosition = DetailsUtils.getIntFieldValue(instance, "horizontalTextPosition", 11);
            this.iconTextGap = DetailsUtils.getIntFieldValue(instance, "iconTextGap", 4);
        }

        @Override
        protected void setupInstance(JLabel instance) {
            super.setupInstance(instance);
            instance.setText(this.text);
            if (this.defaultIcon != null) {
                instance.setIcon((Icon)this.defaultIcon.createInstance());
            }
            instance.setVerticalAlignment(this.verticalAlignment);
            instance.setHorizontalAlignment(this.horizontalAlignment);
            instance.setVerticalTextPosition(this.verticalTextPosition);
            instance.setHorizontalTextPosition(this.horizontalTextPosition);
            instance.setIconTextGap(this.iconTextGap);
        }

        @Override
        protected JLabel createInstanceImpl() {
            return new JLabel();
        }
    }
}

