/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.lang.ref.Reference;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;

public final class ReferenceDetailsProvider
extends DetailsProvider.Basic {
    private static final String FEEBLE_REF_MASK = "com.oracle.svm.core.heap.FeebleReference+";

    public ReferenceDetailsProvider() {
        super(Reference.class.getName() + "+", FEEBLE_REF_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (FEEBLE_REF_MASK.equals(className)) {
            Object value = instance.getValueOfField("rawReferent");
            if (value instanceof Instance) {
                return this.getRefDetail(value, heap);
            }
        } else {
            Object value = instance.getValueOfField("referent");
            if (value instanceof Instance) {
                return this.getRefDetail(value, heap);
            }
            value = instance.getValueOfField("feeble");
            if (value instanceof Instance) {
                return DetailsUtils.getInstanceString((Instance)value, heap);
            }
            value = instance.getValueOfField("bootImageStrongValue");
            if (value instanceof Instance) {
                return this.getRefDetail(value, heap);
            }
        }
        return null;
    }

    private String getRefDetail(Object value, Heap heap) {
        Instance i = (Instance)value;
        String s = DetailsUtils.getInstanceString(i, heap);
        s = s == null ? "#" + i.getInstanceNumber() : ": " + s;
        return BrowserUtils.getSimpleType(i.getJavaClass().getName()) + s;
    }
}

