/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DetailsSupport {
    private static final LinkedHashMap<String, List<ProviderClassPair>> PROVIDERS_CACHE = new LinkedHashMap<String, List<ProviderClassPair>>(10000){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5000;
        }
    };
    private static Lookup.Result<DetailsProvider> PROVIDERS;

    public static String getDetailsString(Instance instance, Heap heap) {
        List<ProviderClassPair> pairs = DetailsSupport.getCompatibleProviders(instance.getJavaClass());
        for (ProviderClassPair pair : pairs) {
            String string;
            String classKey = pair.classKey;
            if (pair.subclasses) {
                classKey = classKey + "+";
            }
            if ((string = pair.provider.getDetailsString(classKey, instance, heap)) == null) continue;
            return string;
        }
        return null;
    }

    public static DetailsProvider.View getDetailsView(Instance instance, Heap heap) {
        List<ProviderClassPair> pairs = DetailsSupport.getCompatibleProviders(instance.getJavaClass());
        for (ProviderClassPair pair : pairs) {
            DetailsProvider.View view;
            String classKey = pair.classKey;
            if (pair.subclasses) {
                classKey = classKey + "+";
            }
            if ((view = pair.provider.getDetailsView(classKey, instance, heap)) == null) continue;
            return view;
        }
        return null;
    }

    private static Collection<? extends DetailsProvider> getProviders() {
        if (PROVIDERS == null) {
            PROVIDERS = Lookup.getDefault().lookupResult(DetailsProvider.class);
            PROVIDERS.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    PROVIDERS_CACHE.clear();
                }
            });
        }
        return PROVIDERS.allInstances();
    }

    private static List<ProviderClassPair> getCompatibleProviders(JavaClass cls) {
        String className = cls.getName();
        List<ProviderClassPair> cachedPairs = PROVIDERS_CACHE.get(className);
        if (cachedPairs != null) {
            return cachedPairs;
        }
        ArrayList<ProviderClassPair> allPairs = new ArrayList<ProviderClassPair>();
        ArrayList<ProviderClassPair> simplePairs = new ArrayList<ProviderClassPair>();
        Collection<? extends DetailsProvider> providers = DetailsSupport.getProviders();
        for (DetailsProvider detailsProvider : providers) {
            String[] classes = detailsProvider.getSupportedClasses();
            if (classes != null && classes.length > 0) {
                for (String classs : classes) {
                    allPairs.add(new ProviderClassPair(detailsProvider, classs));
                }
                continue;
            }
            simplePairs.add(new ProviderClassPair(detailsProvider, null));
        }
        ArrayList<ProviderClassPair> pairs = new ArrayList<ProviderClassPair>();
        if (!allPairs.isEmpty()) {
            boolean bl = false;
            while (cls != null) {
                boolean bl2;
                String clsName = cls.getName();
                for (ProviderClassPair pair : allPairs) {
                    if (!pair.subclasses && bl2 || !clsName.equals(pair.classKey)) continue;
                    pairs.add(pair);
                }
                cls = cls.getSuperClass();
                bl2 = true;
            }
        }
        pairs.addAll(simplePairs);
        PROVIDERS_CACHE.put(className, pairs);
        return pairs;
    }

    private static class ProviderClassPair {
        final DetailsProvider provider;
        final String classKey;
        final boolean subclasses;

        ProviderClassPair(DetailsProvider provider, String classKey) {
            this.subclasses = classKey != null && classKey.endsWith("+");
            this.provider = provider;
            this.classKey = !this.subclasses ? classKey : classKey.substring(0, classKey.length() - 1);
        }
    }
}

