/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public interface OriginalFieldProvider {
    public static Field getJavaField(SnippetReflectionProvider reflectionProvider, ResolvedJavaField field) {
        if (field instanceof OriginalFieldProvider) {
            return ((OriginalFieldProvider)field).getJavaField();
        }
        Class<?> declaringClass = OriginalClassProvider.getJavaClass(reflectionProvider, field.getDeclaringClass());
        try {
            return declaringClass.getDeclaredField(field.getName());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Field getJavaField();
}

