/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ConvertUnknownValueTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.ExceptionObjectTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.WordToObjectTypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.flow.builder.TypeFlowGraphBuilder;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.nodes.AnalysisArraysCopyOfNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.AnalysisUnsafePartitionStoreNode;
import com.oracle.graal.pointsto.nodes.ConvertUnknownValueNode;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.AtomicReadAndWriteNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.graph.MergeableState;
import org.graalvm.compiler.phases.graph.PostOrderNodeIterator;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopy;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.ObjectClone;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.word.WordCastNode;
import org.graalvm.util.GuardedAnnotationAccess;

public class MethodTypeFlowBuilder {
    protected final BigBang bb;
    protected final MethodTypeFlow methodFlow;
    protected final AnalysisMethod method;
    protected StructuredGraph graph;
    private NodeBitMap processedNodes;
    private Map<PhiNode, TypeFlowBuilder<?>> loopPhiFlows;
    private final TypeFlowGraphBuilder typeFlowGraphBuilder;

    public MethodTypeFlowBuilder(BigBang bb, MethodTypeFlow methodFlow) {
        this.bb = bb;
        this.methodFlow = methodFlow;
        this.method = methodFlow.getMethod();
        this.typeFlowGraphBuilder = new TypeFlowGraphBuilder(bb);
    }

    public MethodTypeFlowBuilder(BigBang bb, StructuredGraph graph) {
        this.bb = bb;
        this.graph = graph;
        this.method = (AnalysisMethod)graph.method();
        this.methodFlow = this.method.getTypeFlow();
        this.typeFlowGraphBuilder = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse() {
        OptionValues options = this.bb.getOptions();
        GraalJVMCICompiler compiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
        SnippetReflectionProvider snippetReflection = (SnippetReflectionProvider)compiler.getGraalRuntime().getRequiredCapability(SnippetReflectionProvider.class);
        DebugContext.Description description = new DebugContext.Description((Object)this.method, this.toString());
        DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(snippetReflection)).description(description).build();
        try (Indent indent = debug.logAndIndent("parse graph %s", (Object)this.method);){
            InvocationPlugin plugin2;
            boolean needParsing = false;
            this.graph = this.method.buildGraph(debug, this.method, this.bb.getProviders(), GraphProvider.Purpose.ANALYSIS);
            if (this.graph == null && (plugin2 = this.bb.getProviders().getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)this.method)) != null && !plugin2.inlineOnly()) {
                ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)this.method);
                this.graph = new SubstrateIntrinsicGraphBuilder(options, debug, (CoreProviders)this.bb.getProviders(), (Bytecode)code).buildGraph(plugin2);
                if (this.graph != null) {
                    this.method.registerAsIntrinsicMethod();
                }
            }
            if (this.graph == null) {
                if (!this.method.hasBytecodes()) {
                    boolean plugin2 = false;
                    return plugin2;
                }
                needParsing = true;
                this.graph = new StructuredGraph.Builder(options, debug).method((ResolvedJavaMethod)this.method).build();
            }
            try {
                DebugContext.Scope s = debug.scope((Object)"ClosedWorldAnalysis", (Object)this.graph, (Object)this.method, (Object)this);
                Throwable throwable = null;
                try {
                    try (Indent indent2 = debug.logAndIndent("parse graph phases");){
                        if (needParsing) {
                            GraphBuilderConfiguration config = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.bb.getProviders().getGraphBuilderPlugins()).withEagerResolving(true).withUnresolvedIsError(((Boolean)PointstoOptions.UnresolvedIsError.getValue(this.bb.getOptions())).booleanValue()).withNodeSourcePosition(true).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll);
                            config = config.withRetainLocalVariables(true);
                            this.bb.getHostVM().createGraphBuilderPhase(this.bb.getProviders(), config, OptimisticOptimizations.NONE, null).apply(this.graph);
                        }
                    }
                    catch (PermanentBailoutException ex) {
                        this.bb.getUnsupportedFeatures().addMessage(this.method.format("%H.%n(%p)"), this.method, ex.getLocalizedMessage(), null, ex);
                        boolean bl = false;
                        if (s != null) {
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                s.close();
                            }
                        }
                        if (indent == null) return bl;
                        if (var7_7 == null) {
                            indent.close();
                            return bl;
                        }
                        try {
                            indent.close();
                            return bl;
                        }
                        catch (Throwable throwable3) {
                            var7_7.addSuppressed(throwable3);
                            return bl;
                        }
                    }
                    this.registerUsedElements(false);
                    CanonicalizerPhase.create().apply(this.graph, (Object)this.bb.getProviders());
                    this.registerUsedElements(true);
                    return true;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    public void registerUsedElements(boolean registerEmbeddedRoots) {
        for (Node n : this.graph.getNodes()) {
            AnalysisField field;
            AnalysisType type;
            InstanceOfNode node;
            if (n instanceof InstanceOfNode) {
                node = (InstanceOfNode)n;
                type = (AnalysisType)node.type().getType();
                type.registerAsInTypeCheck();
                continue;
            }
            if (n instanceof NewInstanceNode) {
                node = (NewInstanceNode)n;
                type = (AnalysisType)node.instanceClass();
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof NewArrayNode) {
                node = (NewArrayNode)n;
                type = ((AnalysisType)node.elementType()).getArrayClass();
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                node = (NewMultiArrayNode)n;
                type = (AnalysisType)node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    type.registerAsAllocated((Node)node);
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof BoxNode) {
                node = (BoxNode)n;
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node);
                type.registerAsAllocated((Node)node);
                continue;
            }
            if (n instanceof LoadFieldNode) {
                node = (LoadFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsRead(this.methodFlow);
                continue;
            }
            if (n instanceof StoreFieldNode) {
                node = (StoreFieldNode)n;
                field = (AnalysisField)node.field();
                field.registerAsWritten(this.methodFlow);
                continue;
            }
            if (n instanceof StoreIndexedNode) {
                node = (StoreIndexedNode)n;
                AnalysisType arrayType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.array());
                if (arrayType == null) continue;
                assert (arrayType.isArray());
                arrayType.getComponentType().registerAsInTypeCheck();
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode cn = (ConstantNode)n;
                if (!cn.hasUsages() || !cn.isJavaConstant() || cn.asJavaConstant().getJavaKind() != JavaKind.Object || !cn.asJavaConstant().isNonNull()) continue;
                assert (StampTool.isExactType((ValueNode)cn));
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)cn);
                type.registerAsInHeap();
                if (!registerEmbeddedRoots) continue;
                this.registerEmbeddedRoot(cn);
                continue;
            }
            if (n instanceof ForeignCallNode) {
                node = (ForeignCallNode)n;
                MethodTypeFlowBuilder.registerForeignCall(this.bb, node.getDescriptor());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                node = (UnaryMathIntrinsicNode)n;
                MethodTypeFlowBuilder.registerForeignCall(this.bb, this.bb.getProviders().getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature));
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            node = (BinaryMathIntrinsicNode)n;
            MethodTypeFlowBuilder.registerForeignCall(this.bb, this.bb.getProviders().getForeignCalls().getDescriptor(node.getOperation().foreignCallSignature));
        }
    }

    private void registerEmbeddedRoot(ConstantNode cn) {
        if (this.bb.scanningPolicy().trackConstant(this.bb, cn.asJavaConstant())) {
            NodeSourcePosition position = cn.getNodeSourcePosition();
            if (position == null) {
                position = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
            }
            this.bb.getUniverse().registerEmbeddedRoot(cn.asJavaConstant(), (BytecodePosition)position);
        }
    }

    private static void registerForeignCall(BigBang bb, ForeignCallDescriptor foreignCallDescriptor) {
        Optional<AnalysisMethod> targetMethod = bb.getHostVM().handleForeignCall(foreignCallDescriptor, bb.getProviders().getForeignCalls());
        targetMethod.ifPresent(analysisMethod -> bb.addRootMethod((AnalysisMethod)analysisMethod));
    }

    protected void apply() {
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)this.method), Node.NodeIntrinsic.class)) {
            this.graph.getDebug().log("apply MethodTypeFlow on node intrinsic %s", (Object)this.method);
            AnalysisType returnType = (AnalysisType)this.method.getSignature().getReturnType(this.method.getDeclaringClass());
            if (returnType.getJavaKind() == JavaKind.Object) {
                TypeFlow returnTypeFlow = this.methodFlow.getResultFlow().getDeclaredType().getTypeFlow(this.bb, true);
                BytecodePosition source = new BytecodePosition(null, (ResolvedJavaMethod)this.method, 0);
                returnTypeFlow = new ProxyTypeFlow(source, returnTypeFlow);
                FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow(source, returnType, this.method);
                returnTypeFlow.addOriginalUse(this.bb, resultFlow);
                this.methodFlow.addMiscEntry(returnTypeFlow);
                this.methodFlow.setResult(resultFlow);
            }
            return;
        }
        if (!this.parse()) {
            return;
        }
        this.bb.getHostVM().checkMethod(this.bb, this.method, this.graph);
        this.processedNodes = new NodeBitMap((Graph)this.graph);
        TypeFlowsOfNodes typeFlows = new TypeFlowsOfNodes();
        for (Node n : this.graph.getNodes()) {
            AnalysisType type;
            Object node;
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                if (node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<FormalParamTypeFlow> paramBuilder = TypeFlowBuilder.create(this.bb, node, FormalParamTypeFlow.class, () -> this.lambda$apply$1((ParameterNode)node));
                    this.typeFlowGraphBuilder.checkFormalParameterBuilder(paramBuilder);
                    typeFlows.add((ValueNode)node, paramBuilder);
                }
            } else if (n instanceof BoxNode) {
                node = (BoxNode)n;
                Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
                BytecodeLocation boxSite = this.bb.analysisPolicy().createAllocationSite(this.bb, key, this.methodFlow.getMethod());
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node);
                TypeFlowBuilder<BoxTypeFlow> boxBuilder = TypeFlowBuilder.create(this.bb, node, BoxTypeFlow.class, () -> this.lambda$apply$2((BoxNode)node, type, boxSite));
                typeFlows.add((ValueNode)node, boxBuilder);
            }
            for (Node input : n.inputs()) {
                if (!(input instanceof ConstantNode) || typeFlows.contains((ValueNode)((ConstantNode)input))) continue;
                ConstantNode node2 = (ConstantNode)input;
                if (node2.asJavaConstant().isNull()) {
                    TypeFlowBuilder<SourceTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node2, SourceTypeFlow.class, () -> {
                        SourceTypeFlow constantSource = new SourceTypeFlow((ValueNode)node2, TypeState.forNull());
                        this.methodFlow.addSource(constantSource);
                        return constantSource;
                    });
                    typeFlows.add((ValueNode)node2, sourceBuilder);
                    continue;
                }
                if (node2.asJavaConstant().getJavaKind() != JavaKind.Object) continue;
                assert (StampTool.isExactType((ValueNode)node2));
                type = (AnalysisType)StampTool.typeOrNull((ValueNode)node2);
                assert (type.isInstantiated());
                TypeFlowBuilder<SourceTypeFlow> sourceBuilder = TypeFlowBuilder.create(this.bb, node2, SourceTypeFlow.class, () -> {
                    SourceTypeFlow constantSource = new SourceTypeFlow((ValueNode)node2, TypeState.forConstant(this.bb, node2.asJavaConstant(), type));
                    this.methodFlow.addSource(constantSource);
                    return constantSource;
                });
                typeFlows.add((ValueNode)node2, sourceBuilder);
            }
        }
        new NodeIterator((FixedNode)this.graph.start(), typeFlows).apply();
        this.typeFlowGraphBuilder.build();
        for (Node n : this.graph.getNodes()) {
            if (n instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)n;
                MethodTypeFlowBuilder.markFieldsUsedInComparison(instanceOf.getValue());
                continue;
            }
            if (!(n instanceof ObjectEqualsNode)) continue;
            ObjectEqualsNode compareNode = (ObjectEqualsNode)n;
            MethodTypeFlowBuilder.markFieldsUsedInComparison(compareNode.getX());
            MethodTypeFlowBuilder.markFieldsUsedInComparison(compareNode.getY());
        }
    }

    private static void markFieldsUsedInComparison(ValueNode comparedValue) {
        LoadFieldNode load;
        AnalysisField field;
        if (comparedValue instanceof LoadFieldNode && !(field = (AnalysisField)(load = (LoadFieldNode)comparedValue).field()).isStatic()) {
            field.markAsUsedInComparison();
        }
    }

    protected void delegateNodeProcessing(FixedNode n, TypeFlowsOfNodes state) {
    }

    protected static Object uniqueKey(Node node) {
        NodeSourcePosition position = node.getNodeSourcePosition();
        if (position != null && position.getCaller() == null && position.getBCI() >= 0) {
            return position.getBCI();
        }
        return new Object();
    }

    protected void processNewInstance(NewInstanceNode node, TypeFlowsOfNodes state) {
        AnalysisType type = (AnalysisType)node.instanceClass();
        assert (type.isInstantiated());
        Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
        BytecodeLocation allocationLabel = this.bb.analysisPolicy().createAllocationSite(this.bb, key, this.method);
        TypeFlowBuilder<NewInstanceTypeFlow> newInstanceBuilder = TypeFlowBuilder.create(this.bb, node, NewInstanceTypeFlow.class, () -> {
            NewInstanceTypeFlow newInstance = this.createNewInstanceTypeFlow(node, type, allocationLabel);
            this.methodFlow.addAllocation(newInstance);
            return newInstance;
        });
        state.add((ValueNode)node, newInstanceBuilder);
    }

    protected NewInstanceTypeFlow createNewInstanceTypeFlow(NewInstanceNode node, AnalysisType type, BytecodeLocation allocationLabel) {
        return new NewInstanceTypeFlow((ValueNode)node, type, allocationLabel);
    }

    protected void processNewArray(NewArrayNode node, TypeFlowsOfNodes state) {
        AnalysisType type = ((AnalysisType)node.elementType()).getArrayClass();
        assert (type.isInstantiated());
        Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
        BytecodeLocation allocationLabel = this.bb.analysisPolicy().createAllocationSite(this.bb, key, this.method);
        TypeFlowBuilder<NewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(this.bb, node, NewInstanceTypeFlow.class, () -> {
            NewInstanceTypeFlow newArray = this.createNewArrayTypeFlow(node, type, allocationLabel);
            this.methodFlow.addAllocation(newArray);
            return newArray;
        });
        state.add((ValueNode)node, newArrayBuilder);
    }

    protected NewInstanceTypeFlow createNewArrayTypeFlow(NewArrayNode node, AnalysisType type, BytecodeLocation allocationLabel) {
        return new NewInstanceTypeFlow((ValueNode)node, type, allocationLabel);
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offset) {
    }

    private /* synthetic */ BoxTypeFlow lambda$apply$2(BoxNode node, AnalysisType type, BytecodeLocation boxSite) {
        BoxTypeFlow boxFlow = new BoxTypeFlow((ValueNode)node, type, boxSite);
        this.methodFlow.addAllocation(boxFlow);
        return boxFlow;
    }

    private /* synthetic */ FormalParamTypeFlow lambda$apply$1(ParameterNode node) {
        FormalParamTypeFlow parameter;
        boolean isStatic = Modifier.isStatic(this.method.getModifiers());
        int index = node.index();
        if (!isStatic && index == 0) {
            AnalysisType paramType = this.method.getDeclaringClass();
            parameter = new FormalReceiverTypeFlow(node, paramType, this.method);
        } else {
            int offset = isStatic ? 0 : 1;
            AnalysisType paramType = (AnalysisType)this.method.getSignature().getParameterType(index - offset, this.method.getDeclaringClass());
            parameter = new FormalParamTypeFlow(node, paramType, this.method, index);
        }
        this.methodFlow.setParameter(index, parameter);
        return parameter;
    }

    class NodeIterator
    extends PostOrderNodeIterator<TypeFlowsOfNodes> {
        private HashMap<Object, TypeFlowBuilder<?>> instanceOfFlows;
        private TypeFlowBuilder<?> returnBuilder;

        NodeIterator(FixedNode start, TypeFlowsOfNodes typeFlows) {
            super(start, (MergeableState)typeFlows);
            this.instanceOfFlows = new HashMap();
            this.returnBuilder = null;
        }

        private TypeFlowBuilder<?> uniqueReturnFlowBuilder(ReturnNode node) {
            AnalysisType returnType;
            if (this.returnBuilder == null && (returnType = (AnalysisType)MethodTypeFlowBuilder.this.method.getSignature().getReturnType(MethodTypeFlowBuilder.this.method.getDeclaringClass())).getJavaKind() == JavaKind.Object) {
                this.returnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, FormalReturnTypeFlow.class, () -> {
                    FormalReturnTypeFlow resultFlow = new FormalReturnTypeFlow((ValueNode)node, returnType, MethodTypeFlowBuilder.this.method);
                    MethodTypeFlowBuilder.this.methodFlow.setResult(resultFlow);
                    return resultFlow;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(this.returnBuilder);
            }
            return this.returnBuilder;
        }

        private TypeFlowBuilder<?> uniqueInstanceOfFlow(InstanceOfNode node, AnalysisType declaredType) {
            Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
            return this.instanceOfFlows.computeIfAbsent(key, bciKey -> {
                BytecodeLocation location = BytecodeLocation.create(bciKey, MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<InstanceOfTypeFlow> instanceOfBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, InstanceOfTypeFlow.class, () -> {
                    InstanceOfTypeFlow instanceOf = new InstanceOfTypeFlow((ValueNode)node, location, declaredType);
                    MethodTypeFlowBuilder.this.methodFlow.addInstanceOf(key, instanceOf);
                    return instanceOf;
                });
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(instanceOfBuilder);
                return instanceOfBuilder;
            });
        }

        private void handleCondition(ValueNode source, LogicNode condition, boolean isTrue) {
            if (condition instanceof IsNullNode) {
                IsNullNode nullCheck = (IsNullNode)condition;
                ValueNode object = nullCheck.getValue();
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<NullCheckTypeFlow> nullCheckBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, NullCheckTypeFlow.class, () -> {
                    NullCheckTypeFlow nullCheckFlow = new NullCheckTypeFlow(source, ((TypeFlow)inputBuilder.get()).getDeclaredType(), !isTrue);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(nullCheckFlow);
                    return nullCheckFlow;
                });
                nullCheckBuilder.addUseDependency(inputBuilder);
                ((TypeFlowsOfNodes)this.state).update(object, nullCheckBuilder);
            } else if (condition instanceof InstanceOfNode) {
                InstanceOfNode instanceOf = (InstanceOfNode)condition;
                ValueNode object = instanceOf.getValue();
                TypeReference typeReference = instanceOf.type();
                AnalysisType type = (AnalysisType)instanceOf.type().getType();
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                NodeSourcePosition instanceOfPosition = instanceOf.getNodeSourcePosition();
                if (instanceOfPosition != null && instanceOfPosition.getBCI() >= 0) {
                    TypeFlowBuilder<?> instanceOfBuilder = this.uniqueInstanceOfFlow(instanceOf, type);
                    instanceOfBuilder.addUseDependency(objectBuilder);
                }
                TypeFlowBuilder<FilterTypeFlow> filterBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, source, FilterTypeFlow.class, () -> {
                    FilterTypeFlow filterFlow = new FilterTypeFlow(source, type, typeReference.isExact(), isTrue, !isTrue ^ instanceOf.allowsNull());
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(filterFlow);
                    return filterFlow;
                });
                filterBuilder.addUseDependency(objectBuilder);
                ((TypeFlowsOfNodes)this.state).update(object, filterBuilder);
            }
        }

        protected TypeFlowBuilder<?> getDynamicTypeFlow(ValueNode node, ValueNode typeSource, boolean isArrayType) {
            TypeFlowBuilder<Object> dynamicTypeBuilder;
            if (typeSource instanceof GetClassNode) {
                GetClassNode getClassNode = (GetClassNode)typeSource;
                dynamicTypeBuilder = ((TypeFlowsOfNodes)this.state).lookup(getClassNode.getObject());
            } else if (typeSource.isConstant()) {
                assert (((TypeFlowsOfNodes)this.state).lookup(typeSource).getFlowClass() == SourceTypeFlow.class);
                JavaConstant constant = typeSource.asJavaConstant();
                AnalysisType exactType = (AnalysisType)MethodTypeFlowBuilder.this.bb.getProviders().getConstantReflection().asJavaType((Constant)constant);
                exactType.registerAsAllocated((Node)node);
                dynamicTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> {
                    SourceTypeFlow dynamicTypeFlow = new SourceTypeFlow(node, TypeState.forExactType(MethodTypeFlowBuilder.this.bb, exactType, false));
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(dynamicTypeFlow);
                    return dynamicTypeFlow;
                });
            } else {
                AnalysisType arrayType = isArrayType ? MethodTypeFlowBuilder.this.bb.getObjectArrayType() : MethodTypeFlowBuilder.this.bb.getObjectType();
                dynamicTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, AllInstantiatedTypeFlow.class, () -> arrayType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false));
            }
            return dynamicTypeBuilder;
        }

        protected void node(FixedNode n) {
            MethodTypeFlowBuilder.this.processedNodes.mark((Node)n);
            if (n instanceof LoopEndNode) {
                LoopEndNode end = (LoopEndNode)n;
                LoopBeginNode merge = end.loopBegin();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    ((TypeFlowBuilder)MethodTypeFlowBuilder.this.loopPhiFlows.get(phi)).addUseDependency(((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof LoopBeginNode) {
                LoopBeginNode merge = (LoopBeginNode)n;
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    TypeFlowBuilder<MergeTypeFlow> newFlowBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                        MergeTypeFlow newFlow = new MergeTypeFlow((ValueNode)merge);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newFlow);
                        return newFlow;
                    });
                    newFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup((ValueNode)phi));
                    ((TypeFlowsOfNodes)this.state).update((ValueNode)phi, newFlowBuilder);
                    if (MethodTypeFlowBuilder.this.loopPhiFlows == null) {
                        MethodTypeFlowBuilder.this.loopPhiFlows = new HashMap();
                    }
                    MethodTypeFlowBuilder.this.loopPhiFlows.put(phi, newFlowBuilder);
                }
            } else if (n instanceof EndNode) {
                EndNode end = (EndNode)n;
                AbstractMergeNode merge = end.merge();
                int predIdx = merge.phiPredecessorIndex((AbstractEndNode)end);
                for (PhiNode phi : merge.phis()) {
                    if (phi.getStackKind() != JavaKind.Object) continue;
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)phi, ((TypeFlowsOfNodes)this.state).lookup(phi.valueAt(predIdx)));
                }
            } else if (n instanceof ExceptionObjectNode) {
                ExceptionObjectNode node = (ExceptionObjectNode)n;
                TypeFlowBuilder<ExceptionObjectTypeFlow> exceptionObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ExceptionObjectTypeFlow.class, () -> {
                    AllInstantiatedTypeFlow input = ((AnalysisType)StampTool.typeOrNull((ValueNode)node)).getTypeFlow(MethodTypeFlowBuilder.this.bb, false);
                    ExceptionObjectTypeFlow exceptionObjectFlow = new ExceptionObjectTypeFlow((Node)node, input);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(exceptionObjectFlow);
                    return exceptionObjectFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, exceptionObjectBuilder);
            } else if (n instanceof BeginNode) {
                BeginNode node = (BeginNode)n;
                Node pred = node.predecessor();
                if (pred instanceof IfNode) {
                    IfNode ifNode = (IfNode)pred;
                    this.handleCondition((ValueNode)ifNode, ifNode.condition(), node == ifNode.trueSuccessor());
                }
            } else if (n instanceof FixedGuardNode) {
                FixedGuardNode node = (FixedGuardNode)n;
                this.handleCondition((ValueNode)node, node.condition(), !node.isNegated());
            } else if (n instanceof ReturnNode) {
                ReturnNode node = (ReturnNode)n;
                TypeFlowBuilder<?> returnFlowBuilder = this.uniqueReturnFlowBuilder(node);
                if (node.result() != null && node.result().getStackKind() == JavaKind.Object) {
                    returnFlowBuilder.addUseDependency(((TypeFlowsOfNodes)this.state).lookup(node.result()));
                }
            } else if (n instanceof NewInstanceNode) {
                MethodTypeFlowBuilder.this.processNewInstance((NewInstanceNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewInstanceNode) {
                TypeFlowBuilder<AllInstantiatedTypeFlow> instanceTypeBuilder;
                AnalysisType instanceType;
                DynamicNewInstanceNode node = (DynamicNewInstanceNode)n;
                ValueNode instanceTypeNode = node.getInstanceType();
                JVMCIError.guarantee((!instanceTypeNode.isConstant() ? 1 : 0) != 0, (String)"DynamicNewInstanceNode.instanceType is constant, should have been canonicalized to NewInstanceNode.", (Object[])new Object[0]);
                if (instanceTypeNode instanceof GetClassNode) {
                    GetClassNode getClassNode = (GetClassNode)instanceTypeNode;
                    ValueNode getClassReceiver = getClassNode.getObject();
                    instanceType = (AnalysisType)StampTool.typeOrNull((ValueNode)getClassReceiver);
                    instanceTypeBuilder = ((TypeFlowsOfNodes)this.state).lookup(getClassReceiver);
                } else {
                    instanceType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    instanceTypeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, instanceType, AllInstantiatedTypeFlow.class, () -> instanceType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false));
                }
                AnalysisType nonNullInstanceType = Optional.ofNullable(instanceType).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectType);
                Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewInstanceBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newInstanceTypeFlow = new DynamicNewInstanceTypeFlow((TypeFlow<?>)instanceTypeBuilder.get(), nonNullInstanceType, (ValueNode)node, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addDynamicAllocation(newInstanceTypeFlow);
                    return newInstanceTypeFlow;
                });
                if (instanceTypeNode instanceof GetClassNode) {
                    dynamicNewInstanceBuilder.addObserverDependency(instanceTypeBuilder);
                }
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewInstanceBuilder);
            } else if (n instanceof NewArrayNode) {
                MethodTypeFlowBuilder.this.processNewArray((NewArrayNode)n, (TypeFlowsOfNodes)this.state);
            } else if (n instanceof DynamicNewArrayNode) {
                DynamicNewArrayNode node = (DynamicNewArrayNode)n;
                ValueNode elementType = node.getElementType();
                JVMCIError.guarantee((!elementType.isConstant() ? 1 : 0) != 0, (String)"DynamicNewArrayNode.element is constant, should have been canonicalized to NewArrayNode.", (Object[])new Object[0]);
                AnalysisType arrayType = MethodTypeFlowBuilder.this.bb.getObjectArrayType();
                Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> dynamicNewArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newArrayTypeFlow = new DynamicNewInstanceTypeFlow(arrayType.getTypeFlow(MethodTypeFlowBuilder.this.bb, false), arrayType, (ValueNode)node, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addDynamicAllocation(newArrayTypeFlow);
                    return newArrayTypeFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, dynamicNewArrayBuilder);
            } else if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                AnalysisType type = (AnalysisType)node.type();
                assert (type.isInstantiated());
                Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
                BytecodeLocation allocationLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, MethodTypeFlowBuilder.this.method);
                TypeFlowBuilder<NewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, NewInstanceTypeFlow.class, () -> {
                    NewInstanceTypeFlow newArray = new NewInstanceTypeFlow((ValueNode)node, type, allocationLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addAllocation(newArray);
                    return newArray;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, newArrayBuilder);
            } else if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                AnalysisField field = (AnalysisField)node.field();
                assert (field.isAccessed());
                if (node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<LoadFieldTypeFlow> loadFieldBuilder;
                    if (node.isStatic()) {
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class, () -> {
                            FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                            LoadFieldTypeFlow.LoadStaticFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadStaticFieldTypeFlow(node, fieldFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addFieldLoad(loadFieldFLow);
                            return loadFieldFLow;
                        });
                    } else {
                        TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                        loadFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class, () -> {
                            LoadFieldTypeFlow.LoadInstanceFieldTypeFlow loadFieldFLow = new LoadFieldTypeFlow.LoadInstanceFieldTypeFlow(node, (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addFieldLoad(loadFieldFLow);
                            return loadFieldFLow;
                        });
                        loadFieldBuilder.addObserverDependency(objectBuilder);
                    }
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadFieldBuilder);
                }
            } else if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                AnalysisField field = (AnalysisField)node.field();
                assert (field.isWritten());
                if (node.value().getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<StoreFieldTypeFlow> storeFieldBuilder;
                    TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                    if (node.isStatic()) {
                        storeFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, StoreFieldTypeFlow.class, () -> {
                            FieldTypeFlow fieldFlow = field.getStaticFieldFlow();
                            StoreFieldTypeFlow.StoreStaticFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreStaticFieldTypeFlow(node, (TypeFlow<?>)valueBuilder.get(), fieldFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeFieldFlow);
                            return storeFieldFlow;
                        });
                        storeFieldBuilder.addUseDependency(valueBuilder);
                    } else {
                        TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                        storeFieldBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, StoreFieldTypeFlow.class, () -> {
                            StoreFieldTypeFlow.StoreInstanceFieldTypeFlow storeFieldFlow = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow(node, (TypeFlow<?>)valueBuilder.get(), (TypeFlow<?>)objectBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeFieldFlow);
                            return storeFieldFlow;
                        });
                        storeFieldBuilder.addUseDependency(valueBuilder);
                        storeFieldBuilder.addObserverDependency(objectBuilder);
                    }
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeFieldBuilder);
                }
            } else if (n instanceof LoadIndexedNode) {
                LoadIndexedNode node = (LoadIndexedNode)n;
                TypeFlowBuilder<?> arrayBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.array());
                if (node.getStackKind() == JavaKind.Object) {
                    AnalysisType arrayType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.array());
                    AnalysisType nonNullArrayType = Optional.ofNullable(arrayType).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectArrayType);
                    TypeFlowBuilder<OffsetLoadTypeFlow.LoadIndexedTypeFlow> loadIndexedBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadIndexedFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow((ValueNode)node, nonNullArrayType, (TypeFlow<?>)arrayBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addIndexedLoad(loadIndexedFlow);
                        return loadIndexedFlow;
                    });
                    loadIndexedBuilder.addObserverDependency(arrayBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadIndexedBuilder);
                }
            } else if (n instanceof StoreIndexedNode) {
                StoreIndexedNode node = (StoreIndexedNode)n;
                if (node.value().getStackKind() == JavaKind.Object) {
                    AnalysisType arrayType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.array());
                    AnalysisType nonNullArrayType = Optional.ofNullable(arrayType).orElseGet(MethodTypeFlowBuilder.this.bb::getObjectArrayType);
                    TypeFlowBuilder<?> arrayBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.array());
                    TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                    TypeFlowBuilder<OffsetStoreTypeFlow.StoreIndexedTypeFlow> storeIndexedBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.StoreIndexedTypeFlow storeIndexedFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((ValueNode)node, nonNullArrayType, (TypeFlow<?>)arrayBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeIndexedFlow);
                        return storeIndexedFlow;
                    });
                    storeIndexedBuilder.addUseDependency(valueBuilder);
                    storeIndexedBuilder.addObserverDependency(arrayBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeIndexedBuilder);
                }
            } else if (n instanceof AnalysisUnsafePartitionLoadNode) {
                AnalysisUnsafePartitionLoadNode node = (AnalysisUnsafePartitionLoadNode)n;
                assert (node.object().getStackKind() == JavaKind.Object);
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType));
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow> unsafeLoadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow.class, () -> {
                    OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafePartitionLoadTypeFlow(node, objectType, componentType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow, node.unsafePartitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                    return loadTypeFlow;
                });
                unsafeLoadBuilder.addObserverDependency(objectBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, unsafeLoadBuilder);
            } else if (n instanceof AnalysisUnsafePartitionStoreNode) {
                AnalysisUnsafePartitionStoreNode node = (AnalysisUnsafePartitionStoreNode)n;
                assert (node.object().getStackKind() == JavaKind.Object);
                assert (node.value().getStackKind() == JavaKind.Object);
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                AnalysisType partitionType = (AnalysisType)node.partitionType();
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                assert (MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(objectType));
                AnalysisType componentType = MethodTypeFlowBuilder.this.bb.getObjectType();
                AnalysisType valueType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.value());
                assert (valueType == null || MethodTypeFlowBuilder.this.bb.getGraalNodeType().isAssignableFrom(valueType) || MethodTypeFlowBuilder.this.bb.getGraalNodeListType().isAssignableFrom(valueType));
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                TypeFlowBuilder<OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow> unsafeStoreBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow.class, () -> {
                    OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafePartitionStoreTypeFlow(node, objectType, componentType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get(), node.partitionKind(), partitionType);
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                    return storeTypeFlow;
                });
                unsafeStoreBuilder.addUseDependency(valueBuilder);
                unsafeStoreBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(unsafeStoreBuilder);
            } else if (n instanceof RawLoadNode) {
                RawLoadNode node = (RawLoadNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow((ValueNode)node, objectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class, () -> {
                            OffsetLoadTypeFlow.UnsafeLoadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.UnsafeLoadTypeFlow(node, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                            return loadTypeFlow;
                        });
                    }
                    loadBuilder.addObserverDependency(objectBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, loadBuilder);
                }
            } else if (n instanceof RawStoreNode) {
                RawStoreNode node = (RawStoreNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.value().getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    TypeFlowBuilder<?> valueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.value());
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((ValueNode)node, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.UnsafeStoreTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.UnsafeStoreTypeFlow(node, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)valueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(valueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndSwapNode) {
                UnsafeCompareAndSwapNode node = (UnsafeCompareAndSwapNode)n;
                MethodTypeFlowBuilder.this.checkUnsafeOffset(node.object(), node.offset());
                if (node.object().getStackKind() == JavaKind.Object && node.newValue().getStackKind() == JavaKind.Object) {
                    TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                    AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.object());
                    TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                    TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.newValue());
                    if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow((ValueNode)node, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    } else {
                        AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                        storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.CompareAndSwapTypeFlow.class, () -> {
                            OffsetStoreTypeFlow.CompareAndSwapTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.CompareAndSwapTypeFlow(node, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                            return storeTypeFlow;
                        });
                    }
                    storeBuilder.addUseDependency(newValueBuilder);
                    storeBuilder.addObserverDependency(objectBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                }
            } else if (n instanceof UnsafeCompareAndExchangeNode) {
                UnsafeCompareAndExchangeNode node = (UnsafeCompareAndExchangeNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof AtomicReadAndWriteNode) {
                AtomicReadAndWriteNode node = (AtomicReadAndWriteNode)n;
                this.modelUnsafeReadAndWriteFlow((ValueNode)node, node.object(), node.newValue(), node.offset());
            } else if (n instanceof ArrayCopy) {
                TypeFlowBuilder<?> dstBuilder;
                ArrayCopy node = (ArrayCopy)n;
                TypeFlowBuilder<?> srcBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getSource());
                if (srcBuilder != (dstBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getDestination()))) {
                    AnalysisType type = (AnalysisType)StampTool.typeOrNull((ValueNode)node.asNode());
                    TypeFlowBuilder<ArrayCopyTypeFlow> arrayCopyBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ArrayCopyTypeFlow.class, () -> {
                        ArrayCopyTypeFlow arrayCopyFlow = new ArrayCopyTypeFlow((ValueNode)node.asNode(), type, (TypeFlow<?>)srcBuilder.get(), (TypeFlow<?>)dstBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(arrayCopyFlow);
                        return arrayCopyFlow;
                    });
                    arrayCopyBuilder.addObserverDependency(srcBuilder);
                    arrayCopyBuilder.addObserverDependency(dstBuilder);
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(arrayCopyBuilder);
                }
            } else if (n instanceof WordCastNode) {
                WordCastNode node = (WordCastNode)n;
                ValueNode input = node.getInput();
                if (input.getStackKind() != JavaKind.Object) {
                    TypeFlowBuilder<WordToObjectTypeFlow> wordToObjectBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, WordToObjectTypeFlow.class, () -> {
                        TypeFlow<?> unknown = MethodTypeFlowBuilder.this.bb.getUnknownTypeFlow();
                        WordToObjectTypeFlow objectFlow = new WordToObjectTypeFlow((Node)node, unknown);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(objectFlow);
                        return objectFlow;
                    });
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)node, wordToObjectBuilder);
                }
            } else if (n instanceof AnalysisArraysCopyOfNode) {
                AnalysisArraysCopyOfNode node = (AnalysisArraysCopyOfNode)n;
                ValueNode original = node.getOriginal();
                ValueNode newArrayType = node.getNewArrayType();
                TypeFlowBuilder<?> originalArrayBuilder = ((TypeFlowsOfNodes)this.state).lookup(original);
                Object key = MethodTypeFlowBuilder.uniqueKey((Node)node);
                BytecodeLocation newArrayLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, key, MethodTypeFlowBuilder.this.methodFlow.getMethod());
                TypeFlowBuilder<?> newArrayTypeBuilder = newArrayType == null ? originalArrayBuilder : this.getDynamicTypeFlow((ValueNode)node, newArrayType, true);
                TypeFlowBuilder<DynamicNewInstanceTypeFlow> newArrayBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, DynamicNewInstanceTypeFlow.class, () -> {
                    DynamicNewInstanceTypeFlow newArrayFlow = new DynamicNewInstanceTypeFlow((TypeFlow<?>)newArrayTypeBuilder.get(), MethodTypeFlowBuilder.this.bb.getObjectArrayType(), (ValueNode)node, newArrayLabel);
                    MethodTypeFlowBuilder.this.methodFlow.addDynamicAllocation(newArrayFlow);
                    return newArrayFlow;
                });
                if (newArrayType != null && (newArrayType instanceof GetClassNode || newArrayType.isConstant())) {
                    newArrayBuilder.addObserverDependency(newArrayTypeBuilder);
                }
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, newArrayBuilder);
                TypeFlowBuilder<ArrayCopyTypeFlow> arrayCopyBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, ArrayCopyTypeFlow.class, () -> {
                    ArrayCopyTypeFlow arrayCopyFlow = new ArrayCopyTypeFlow((ValueNode)node, null, (TypeFlow<?>)originalArrayBuilder.get(), (TypeFlow<?>)newArrayBuilder.get());
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(arrayCopyFlow);
                    return arrayCopyFlow;
                });
                arrayCopyBuilder.addObserverDependency(originalArrayBuilder);
                arrayCopyBuilder.addObserverDependency(newArrayBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(arrayCopyBuilder);
            } else if (n instanceof InvokeNode || n instanceof InvokeWithExceptionNode) {
                Invoke invoke = (Invoke)n;
                if (invoke.callTarget() instanceof MethodCallTargetNode) {
                    JVMCIError.guarantee((invoke.stateAfter().outerFrameState() == null ? 1 : 0) != 0, (String)"Outer FrameState must not be null.", (Object[])new Object[0]);
                    MethodCallTargetNode target = (MethodCallTargetNode)invoke.callTarget();
                    AnalysisMethod callerMethod = MethodTypeFlowBuilder.this.methodFlow.getMethod();
                    AnalysisMethod targetMethod = (AnalysisMethod)target.targetMethod();
                    MethodTypeFlowBuilder.this.bb.isCallAllowed(MethodTypeFlowBuilder.this.bb, callerMethod, targetMethod, target.getNodeSourcePosition());
                    Object key = MethodTypeFlowBuilder.uniqueKey((Node)n);
                    BytecodeLocation location = BytecodeLocation.create(key, MethodTypeFlowBuilder.this.methodFlow.getMethod());
                    boolean targetIsStatic = Modifier.isStatic(targetMethod.getModifiers());
                    TypeFlowBuilder[] actualParametersBuilders = new TypeFlowBuilder[target.arguments().size()];
                    for (int i = 0; i < actualParametersBuilders.length; ++i) {
                        TypeFlowBuilder<?> paramBuilder;
                        ValueNode actualParam = (ValueNode)target.arguments().get(i);
                        if (actualParam.getStackKind() != JavaKind.Object) continue;
                        actualParametersBuilders[i] = paramBuilder = ((TypeFlowsOfNodes)this.state).lookup(actualParam);
                        paramBuilder.markAsBuildingAnActualParameter();
                        if (i == 0 && !targetIsStatic) {
                            paramBuilder.markAsBuildingAnActualReceiver();
                        }
                        MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(paramBuilder);
                    }
                    TypeFlowBuilder<InvokeTypeFlow> invokeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, invoke, InvokeTypeFlow.class, () -> {
                        TypeFlow[] actualParameters = new TypeFlow[actualParametersBuilders.length];
                        for (int i = 0; i < actualParameters.length; ++i) {
                            actualParameters[i] = actualParametersBuilders[i] != null ? actualParametersBuilders[i].get() : null;
                        }
                        ActualReturnTypeFlow actualReturn = null;
                        AnalysisType receiverType = invoke.getInvokeKind().hasReceiver() ? (AnalysisType)invoke.getReceiverType() : null;
                        BytecodePosition invokeLocation = InvokeTypeFlow.findBytecodePosition(invoke);
                        InvokeTypeFlow invokeFlow = null;
                        switch (target.invokeKind()) {
                            case Static: {
                                invokeFlow = new StaticInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                                break;
                            }
                            case Special: {
                                invokeFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().createSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                                break;
                            }
                            case Virtual: 
                            case Interface: {
                                invokeFlow = MethodTypeFlowBuilder.this.bb.analysisPolicy().createVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
                                break;
                            }
                            default: {
                                throw JVMCIError.shouldNotReachHere();
                            }
                        }
                        MethodTypeFlowBuilder.this.methodFlow.addInvoke(key, invokeFlow);
                        return invokeFlow;
                    });
                    if (target.invokeKind() == CallTargetNode.InvokeKind.Special || target.invokeKind() == CallTargetNode.InvokeKind.Virtual || target.invokeKind() == CallTargetNode.InvokeKind.Interface) {
                        invokeBuilder.addObserverDependency(actualParametersBuilders[0]);
                    }
                    if (invoke.asNode().getStackKind() == JavaKind.Object) {
                        AnalysisType returnType = (AnalysisType)target.targetMethod().getSignature().getReturnType(null);
                        TypeFlowBuilder<ActualReturnTypeFlow> actualReturnBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, invoke.asNode(), ActualReturnTypeFlow.class, () -> {
                            ActualReturnTypeFlow actualReturn = new ActualReturnTypeFlow((ValueNode)invoke.asNode(), returnType);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(actualReturn);
                            InvokeTypeFlow invokeFlow = (InvokeTypeFlow)invokeBuilder.get();
                            invokeFlow.setActualReturn(actualReturn);
                            actualReturn.setInvokeFlow(invokeFlow);
                            return actualReturn;
                        });
                        ((TypeFlowsOfNodes)this.state).add((ValueNode)invoke.asNode(), actualReturnBuilder);
                    }
                    MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(invokeBuilder);
                    ((TypeFlowsOfNodes)this.state).add((ValueNode)target, invokeBuilder);
                }
            } else if (n instanceof ObjectClone) {
                ObjectClone node = (ObjectClone)n;
                BytecodeLocation cloneLabel = MethodTypeFlowBuilder.this.bb.analysisPolicy().createAllocationSite(MethodTypeFlowBuilder.this.bb, node.bci(), MethodTypeFlowBuilder.this.methodFlow.getMethod());
                TypeFlowBuilder<?> inputBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.getObject());
                AnalysisType inputType = (AnalysisType)StampTool.typeOrNull((ValueNode)node.getObject());
                TypeFlowBuilder<CloneTypeFlow> cloneBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, CloneTypeFlow.class, () -> {
                    CloneTypeFlow cloneFlow = new CloneTypeFlow((ValueNode)node.asNode(), inputType, cloneLabel, (TypeFlow<?>)inputBuilder.get());
                    MethodTypeFlowBuilder.this.methodFlow.addClone(cloneFlow);
                    return cloneFlow;
                });
                cloneBuilder.addObserverDependency(inputBuilder);
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node.asNode(), cloneBuilder);
            } else if (n instanceof MonitorEnterNode) {
                MonitorEnterNode node = (MonitorEnterNode)n;
                BytecodeLocation monitorLocation = BytecodeLocation.create(MethodTypeFlowBuilder.uniqueKey((Node)node), MethodTypeFlowBuilder.this.methodFlow.getMethod());
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(node.object());
                TypeFlowBuilder<MonitorEnterTypeFlow> monitorEntryBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, MonitorEnterTypeFlow.class, () -> {
                    MonitorEnterTypeFlow monitorEntryFlow = new MonitorEnterTypeFlow(MethodTypeFlowBuilder.this.bb, node, monitorLocation, MethodTypeFlowBuilder.this.methodFlow.getMethod());
                    MethodTypeFlowBuilder.this.methodFlow.addMonitorEntryFlow(monitorEntryFlow);
                    return monitorEntryFlow;
                });
                monitorEntryBuilder.addUseDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(monitorEntryBuilder);
            } else if (n instanceof ConvertUnknownValueNode) {
                ConvertUnknownValueNode node = (ConvertUnknownValueNode)n;
                AnalysisType nodeType = (AnalysisType)StampTool.typeOrNull((ValueNode)node);
                TypeFlowBuilder<ConvertUnknownValueTypeFlow> resultBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, (Object)node, ConvertUnknownValueTypeFlow.class, () -> {
                    ConvertUnknownValueTypeFlow resultFlow = new ConvertUnknownValueTypeFlow((Node)node, nodeType.getTypeFlow(MethodTypeFlowBuilder.this.bb, true));
                    MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(resultFlow);
                    return resultFlow;
                });
                ((TypeFlowsOfNodes)this.state).add((ValueNode)node, resultBuilder);
            } else {
                MethodTypeFlowBuilder.this.delegateNodeProcessing(n, (TypeFlowsOfNodes)this.state);
            }
        }

        private void modelUnsafeReadAndWriteFlow(ValueNode node, ValueNode object, ValueNode newValue, ValueNode offset) {
            assert (node instanceof UnsafeCompareAndExchangeNode || node instanceof AtomicReadAndWriteNode);
            MethodTypeFlowBuilder.this.checkUnsafeOffset(object, offset);
            if (object.getStackKind() == JavaKind.Object && newValue.getStackKind() == JavaKind.Object) {
                TypeFlowBuilder<OffsetLoadTypeFlow> loadBuilder;
                TypeFlowBuilder<OffsetStoreTypeFlow> storeBuilder;
                AnalysisType objectType = (AnalysisType)StampTool.typeOrNull((ValueNode)object);
                TypeFlowBuilder<?> objectBuilder = ((TypeFlowsOfNodes)this.state).lookup(object);
                TypeFlowBuilder<?> newValueBuilder = ((TypeFlowsOfNodes)this.state).lookup(newValue);
                if (objectType != null && objectType.isArray() && objectType.getComponentType().getJavaKind() == JavaKind.Object) {
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.StoreIndexedTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.StoreIndexedTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.StoreIndexedTypeFlow(node, objectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.LoadIndexedTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.LoadIndexedTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.LoadIndexedTypeFlow(node, objectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                        return loadTypeFlow;
                    });
                } else {
                    AnalysisType nonNullObjectType = MethodTypeFlowBuilder.this.bb.getObjectType();
                    storeBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetStoreTypeFlow.AtomicWriteTypeFlow.class, () -> {
                        OffsetStoreTypeFlow.AtomicWriteTypeFlow storeTypeFlow = new OffsetStoreTypeFlow.AtomicWriteTypeFlow(node, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), (TypeFlow<?>)newValueBuilder.get());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(storeTypeFlow);
                        return storeTypeFlow;
                    });
                    loadBuilder = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, OffsetLoadTypeFlow.AtomicReadTypeFlow.class, () -> {
                        OffsetLoadTypeFlow.AtomicReadTypeFlow loadTypeFlow = new OffsetLoadTypeFlow.AtomicReadTypeFlow(node, nonNullObjectType, nonNullObjectType, (TypeFlow<?>)objectBuilder.get(), MethodTypeFlowBuilder.this.methodFlow);
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(loadTypeFlow);
                        return loadTypeFlow;
                    });
                }
                storeBuilder.addUseDependency(newValueBuilder);
                storeBuilder.addObserverDependency(objectBuilder);
                loadBuilder.addObserverDependency(objectBuilder);
                MethodTypeFlowBuilder.this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
                ((TypeFlowsOfNodes)this.state).add(node, loadBuilder);
            }
        }
    }

    protected class TypeFlowsOfNodes
    extends MergeableState<TypeFlowsOfNodes>
    implements Cloneable {
        private final Map<Node, TypeFlowBuilder<?>> flows;

        TypeFlowsOfNodes() {
            this.flows = new HashMap();
        }

        protected TypeFlowsOfNodes(TypeFlowsOfNodes copyFrom) {
            this.flows = new HashMap(copyFrom.flows);
        }

        public boolean contains(ValueNode node) {
            return this.flows.containsKey(GraphUtil.unproxify((ValueNode)node));
        }

        public TypeFlowBuilder<?> lookup(ValueNode n) {
            assert (n.stamp(NodeView.DEFAULT) instanceof ObjectStamp);
            ValueNode node = GraphUtil.unproxify((ValueNode)n);
            TypeFlowBuilder<Object> result = this.flows.get(node);
            if (result == null) {
                ObjectStamp stamp = (ObjectStamp)n.stamp(NodeView.DEFAULT);
                if (stamp.isEmpty()) {
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> new SourceTypeFlow(node, TypeState.forEmpty()));
                } else if (stamp.isExactType()) {
                    result = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, SourceTypeFlow.class, () -> {
                        SourceTypeFlow src = new SourceTypeFlow(node, TypeState.forExactType(MethodTypeFlowBuilder.this.bb, (AnalysisType)stamp.type(), !stamp.nonNull()));
                        MethodTypeFlowBuilder.this.methodFlow.addSource(src);
                        return src;
                    });
                } else {
                    AnalysisType type = stamp.type() == null ? MethodTypeFlowBuilder.this.bb.getObjectType() : stamp.type();
                    result = type.isJavaLangObject() ? TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ProxyTypeFlow.class, () -> {
                        ProxyTypeFlow proxy = new ProxyTypeFlow((Node)node, MethodTypeFlowBuilder.this.bb.getUnknownTypeFlow());
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(proxy);
                        return proxy;
                    }) : TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, node, ProxyTypeFlow.class, () -> {
                        ProxyTypeFlow proxy = new ProxyTypeFlow((Node)node, type.getTypeFlow(MethodTypeFlowBuilder.this.bb, true));
                        MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(proxy);
                        return proxy;
                    });
                }
                this.flows.put((Node)node, result);
            }
            return result;
        }

        public void add(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (!this.contains(node));
            this.flows.put((Node)GraphUtil.unproxify((ValueNode)node), flow);
        }

        public void update(ValueNode node, TypeFlowBuilder<?> flow) {
            assert (this.contains(node));
            this.flows.put((Node)GraphUtil.unproxify((ValueNode)node), flow);
        }

        public boolean merge(AbstractMergeNode merge, List<TypeFlowsOfNodes> withStates) {
            for (AbstractEndNode end : merge.forwardEnds()) {
                if (MethodTypeFlowBuilder.this.processedNodes.contains((Node)end)) continue;
                return false;
            }
            Iterator<Map.Entry<Node, TypeFlowBuilder<?>>> iterator = this.flows.entrySet().iterator();
            block1: while (iterator.hasNext()) {
                Map.Entry<Node, TypeFlowBuilder<?>> entry = iterator.next();
                Node node = entry.getKey();
                TypeFlowBuilder<?> oldFlow = entry.getValue();
                TypeFlowBuilder<Object> newFlow = oldFlow;
                for (TypeFlowsOfNodes other : withStates) {
                    TypeFlowBuilder<?> mergeFlow = other.flows.get(node);
                    if (mergeFlow == null) {
                        iterator.remove();
                        continue block1;
                    }
                    if (mergeFlow == newFlow) continue;
                    if (newFlow == oldFlow) {
                        newFlow = TypeFlowBuilder.create(MethodTypeFlowBuilder.this.bb, merge, MergeTypeFlow.class, () -> {
                            MergeTypeFlow newMergeFlow = new MergeTypeFlow((ValueNode)merge);
                            MethodTypeFlowBuilder.this.methodFlow.addMiscEntry(newMergeFlow);
                            return newMergeFlow;
                        });
                        newFlow.addUseDependency(oldFlow);
                        entry.setValue(newFlow);
                    }
                    newFlow.addUseDependency(mergeFlow);
                }
            }
            return true;
        }

        public TypeFlowsOfNodes clone() {
            return new TypeFlowsOfNodes(this);
        }
    }
}

