/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.graalvm.compiler.hotspot.management.libgraal.annotation.JMXFromLibGraalRepeated;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;

@Repeatable(value=JMXFromLibGraalRepeated.class)
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.METHOD})
public @interface JMXFromLibGraal {
    public Id value();

    public static enum Id implements FromLibGraalId
    {
        GetFactory(Object.class, new Class[0]),
        SignalRegistrationRequest(Void.TYPE, Object.class, Long.TYPE),
        Unregister(Void.TYPE, Object.class, Long.TYPE, String[].class);

        private final String signature;
        private final String methodName;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;

        public String getName() {
            return this.name();
        }

        public String getSignature() {
            return this.signature;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.methodName + this.signature;
        }

        private Id(Class<?> returnType, Class<?> ... parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.signature = FromLibGraalId.encodeMethodSignature(returnType, (Class[])parameterTypes);
            this.methodName = Character.toLowerCase(this.name().charAt(0)) + this.name().substring(1);
        }
    }
}

