/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javax.management.DynamicMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.AggregatedMemoryPoolBean;
import org.graalvm.compiler.hotspot.management.JMXFromLibGraalEntryPoints;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.compiler.hotspot.management.LibGraalMBean;
import org.graalvm.compiler.hotspot.management.libgraal.LibGraalMemoryPoolMBean;
import org.graalvm.compiler.hotspot.management.libgraal.MBeanProxyGen;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.WordFactory;

class MBeanProxy<T extends DynamicMBean> {
    private static final Method getCurrentJavaThreadMethod;
    private static final ClassData HS_BEAN_CLASS;
    private static final ClassData HS_BEAN_FACTORY_CLASS;
    private static final ClassData HS_CALLS_CLASS;
    private static final ClassData HS_PUSHBACK_ITER_CLASS;
    private static final ClassData HS_ENTRYPOINTS_CLASS;
    private static final ClassData HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS;
    private static Queue<MBeanProxy<?>> registrations;
    private static JNI.JClass fromLibGraalEntryPoints;
    private static volatile long jniEnvOffset;
    private static LibGraalMemoryPoolMBean memPoolBean;
    private static List<MBeanProxy<?>> mBeansToUnregisterOnIsolateClose;
    private static State state;
    private T bean;
    private String name;
    private ObjectName objName;
    private volatile boolean needsRegistration = true;

    MBeanProxy() {
    }

    MBeanProxy(T mbean, String strName) throws MalformedObjectNameException {
        this.initialize(mbean, strName, new ObjectName(strName));
    }

    void initialize(T mbean, String strName, ObjectName objectName) {
        Objects.requireNonNull(mbean);
        Objects.requireNonNull(strName);
        Objects.requireNonNull(objectName);
        if (this.bean != null) {
            throw new IllegalStateException("Already initialized.");
        }
        assert (this.name == null);
        assert (this.objName == null);
        this.bean = mbean;
        this.name = strName;
        this.objName = objectName;
    }

    T getBean() {
        return this.bean;
    }

    void finishRegistration() {
        this.needsRegistration = false;
    }

    String getName() {
        return this.name;
    }

    ObjectName poll() {
        LibGraalMemoryPoolMBean memPool = memPoolBean;
        if (memPool != null) {
            memPool.update();
        }
        if (this.bean == null || this.needsRegistration) {
            return null;
        }
        return this.objName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean initializeJNI(GraalHotSpotVMConfig config, HotSpotGraalRuntime runtime) {
        if (getCurrentJavaThreadMethod == null) {
            return false;
        }
        if (jniEnvOffset != 0L) return true;
        Class<MBeanProxy> clazz = MBeanProxy.class;
        synchronized (MBeanProxy.class) {
            if (jniEnvOffset != 0L) return true;
            if (config.jniEnvironmentOffset == Integer.MIN_VALUE) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            memPoolBean = new LibGraalMemoryPoolMBean();
            jniEnvOffset = config.jniEnvironmentOffset;
            MBeanProxy.defineClassesInHotSpot(MBeanProxy.getCurrentJNIEnv());
            try {
                MBeanProxy<LibGraalMemoryPoolMBean> memPoolMBean = new MBeanProxy<LibGraalMemoryPoolMBean>(memPoolBean, MBeanProxy.nameWithIsolateId("java.lang:type=MemoryPool,name=Libgraal"));
                MBeanProxy.enqueueForRegistration(memPoolMBean, runtime);
            }
            catch (MalformedObjectNameException mon) {
                throw new AssertionError("Invlid object name.", mon);
            }
            return true;
        }
    }

    static JNI.JClass getHotSpotEntryPoints() {
        return fromLibGraalEntryPoints;
    }

    static JNI.JNIEnv getCurrentJNIEnv() {
        if (jniEnvOffset == 0L) {
            throw new IllegalStateException("JniEnvOffset is not yet initialized.");
        }
        if (getCurrentJavaThreadMethod == null) {
            throw new IllegalStateException("CurrentJavaThread not supported by JVMCI.");
        }
        try {
            long currentJavaThreadAddr = (Long)getCurrentJavaThreadMethod.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
            return (JNI.JNIEnv)WordFactory.pointer((long)(currentJavaThreadAddr + jniEnvOffset));
        }
        catch (ReflectiveOperationException reflectiveException) {
            throw new RuntimeException("Failed to invoke HotSpotJVMCIRuntime::getCurrentJavaThread", reflectiveException);
        }
    }

    static synchronized List<MBeanProxy<?>> drainRegistrations() {
        if (state != State.ACTIVE || registrations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList res = new ArrayList(registrations);
        registrations.clear();
        return res;
    }

    static <T extends MBeanProxy<?>> T enqueueForRegistrationAndNotify(T instance, HotSpotGraalRuntime runtime) {
        T res = MBeanProxy.enqueueForRegistration(instance, runtime);
        if (res != null) {
            MBeanProxy.signalRegistrationRequest();
        }
        return res;
    }

    static String nameWithIsolateId(String name) {
        long id = IsolateUtil.getIsolateID();
        return id == 0L ? name : name + ",isolate=" + id;
    }

    private static synchronized <T extends MBeanProxy<?>> T enqueueForRegistration(T instance, HotSpotGraalRuntime runtime) {
        if (state == State.CLOSED) {
            return null;
        }
        registrations.add(instance);
        if (mBeansToUnregisterOnIsolateClose.isEmpty()) {
            runtime.addShutdownHook((Runnable)new OnShutDown());
        }
        mBeansToUnregisterOnIsolateClose.add(instance);
        return instance;
    }

    private static synchronized void updateStateToActive() {
        if (state == State.INIT) {
            state = State.ACTIVE;
        }
    }

    private static void defineClassesInHotSpot(JNI.JNIEnv env) {
        JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader((JNI.JNIEnv)env);
        MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_CALLS_CLASS);
        JNI.JClass entryPoints = MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_ENTRYPOINTS_CLASS);
        MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_BEAN_CLASS);
        MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_BEAN_FACTORY_CLASS);
        MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_PUSHBACK_ITER_CLASS);
        MBeanProxy.findOrDefineClassInHotSpot(env, classLoader, HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS);
        fromLibGraalEntryPoints = (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)entryPoints, (String)("Class<" + MBeanProxy.HS_ENTRYPOINTS_CLASS.binaryName + ">"));
    }

    private static JNI.JClass findOrDefineClassInHotSpot(JNI.JNIEnv env, JNI.JObject classLoader, ClassData classData) {
        JNI.JClass res = MBeanProxy.findClassInHotSpot(env, classLoader, classData.binaryName, false);
        if (res.isNonNull()) {
            return res;
        }
        res = MBeanProxy.defineClassInHotSpot(env, classLoader, classData);
        if (res.isNonNull()) {
            return res;
        }
        return MBeanProxy.findClassInHotSpot(env, classLoader, classData.binaryName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JNI.JClass findClassInHotSpot(JNI.JNIEnv env, JNI.JObject classLoader, String className, boolean required) {
        JNI.JClass jClass;
        block9: {
            block7: {
                Class allowedException;
                block5: {
                    JNI.JClass jClass2;
                    block8: {
                        block6: {
                            allowedException = null;
                            try {
                                if (!classLoader.isNonNull()) break block5;
                                allowedException = required ? null : ClassNotFoundException.class;
                                jClass2 = JNIUtil.findClass((JNI.JNIEnv)env, (JNI.JObject)classLoader, (String)className);
                                if (allowedException == null) break block6;
                            }
                            catch (Throwable throwable) {
                                if (allowedException != null) {
                                    JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[]{allowedException});
                                } else {
                                    JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[0]);
                                }
                                throw throwable;
                            }
                            JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[]{allowedException});
                            break block8;
                        }
                        JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[0]);
                    }
                    return jClass2;
                }
                allowedException = required ? null : NoClassDefFoundError.class;
                jClass = JNIUtil.findClass((JNI.JNIEnv)env, (String)className);
                if (allowedException == null) break block7;
                JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[]{allowedException});
                break block9;
            }
            JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[0]);
        }
        return jClass;
    }

    /*
     * Exception decompiling
     */
    private static JNI.JClass defineClassInHotSpot(JNI.JNIEnv env, JNI.JObject classLoader, ClassData classData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JNI.JObject getFactory(JNI.JNIEnv env) {
        return MBeanProxyGen.callGetFactory(env);
    }

    private static void signalRegistrationRequest() {
        JNI.JNIEnv env = MBeanProxy.getCurrentJNIEnv();
        JNI.JObject factory = MBeanProxy.getFactory(env);
        MBeanProxy.updateStateToActive();
        MBeanProxyGen.callSignalRegistrationRequest(env, factory, CurrentIsolate.getIsolate().rawValue());
    }

    private static void unregister(List<MBeanProxy<?>> toUnregister) {
        JNI.JNIEnv env = MBeanProxy.getCurrentJNIEnv();
        JNI.JObject factory = MBeanProxy.getFactory(env);
        JNI.JObjectArray objectNamesHandle = JNIUtil.NewObjectArray((JNI.JNIEnv)env, (int)toUnregister.size(), (JNI.JClass)JNIUtil.findClass((JNI.JNIEnv)env, (String)JNIUtil.getBinaryName((String)String.class.getName())), (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
        for (int i = 0; i < toUnregister.size(); ++i) {
            JNI.JString objectName = JNIUtil.createHSString((JNI.JNIEnv)env, (String)toUnregister.get(i).getName());
            JNIUtil.SetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)objectNamesHandle, (int)i, (JNI.JObject)objectName);
        }
        MBeanProxyGen.callUnregister(env, factory, CurrentIsolate.getIsolate().rawValue(), (JNI.JObject)objectNamesHandle);
    }

    static {
        Method m;
        try {
            m = HotSpotJVMCIRuntime.class.getMethod("getCurrentJavaThread", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        getCurrentJavaThreadMethod = m;
        HS_BEAN_CLASS = ClassData.create(LibGraalMBean.class);
        HS_BEAN_FACTORY_CLASS = ClassData.create(LibGraalMBean.Factory.class);
        HS_CALLS_CLASS = ClassData.create(JMXToLibGraalCalls.class);
        HS_PUSHBACK_ITER_CLASS = ClassData.create(LibGraalMBean.PushBackIterator.class);
        HS_ENTRYPOINTS_CLASS = ClassData.create(JMXFromLibGraalEntryPoints.class);
        HS_AGGREGATED_MEMORY_POOL_BEAN_CLASS = ClassData.create(AggregatedMemoryPoolBean.class);
        registrations = new ArrayDeque();
        mBeansToUnregisterOnIsolateClose = new LinkedList();
        state = State.INIT;
    }

    private static final class ClassData {
        final String binaryName;
        final byte[] byteCode;

        private ClassData(String binaryName, byte[] byteCode) {
            this.binaryName = binaryName;
            this.byteCode = byteCode;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static ClassData create(Class<?> clz) {
            String binaryName = JNIUtil.getBinaryName((String)clz.getName());
            try (DataInputStream in = new DataInputStream(clz.getResourceAsStream('/' + binaryName + ".class"));){
                byte[] buffer = new byte[in.available()];
                in.readFully(buffer);
                ClassData classData = new ClassData(binaryName, buffer);
                return classData;
            }
            catch (IOException ioe) {
                throw new InternalError("Error loading class file for %s: " + clz.getName(), ioe);
            }
        }
    }

    private static final class OnShutDown
    implements Runnable {
        private OnShutDown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<MBeanProxy> clazz = MBeanProxy.class;
            synchronized (MBeanProxy.class) {
                State prevState = state;
                state = State.CLOSED;
                List toUnregister = mBeansToUnregisterOnIsolateClose;
                mBeansToUnregisterOnIsolateClose = null;
                // ** MonitorExit[var3_1] (shouldn't be in output)
                if (prevState == State.ACTIVE) {
                    MBeanProxy.unregister(toUnregister);
                }
                return;
            }
        }
    }

    private static enum State {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

