/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

final class LibGraalMemoryPoolMBean
implements DynamicMBean {
    static final String NAME = "java.lang:type=MemoryPool,name=Libgraal";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_VALID = "Valid";
    private static final String ATTR_USAGE = "Usage";
    private static final String ATTR_PEAK_USAGE = "PeakUsage";
    private static final String ATTR_COLLECTION_USAGE = "CollectionUsage";
    private static final String ATTR_COLLECTION_USAGE_THRESHOLD_SUPPORTED = "CollectionUsageThresholdSupported";
    private static final String ATTR_COLLECTION_USAGE_THRESHOLD = "CollectionUsageThreshold";
    private static final String ATTR_COLLECTION_USAGE_THRESHOLD_COUNT = "CollectionUsageThresholdCount";
    private static final String ATTR_COLLECTION_USAGE_THRESHOLD_EXCEEDED = "CollectionUsageThresholdExceeded";
    private static final String ATTR_USAGE_THRESHOLD_SUPPORTED = "UsageThresholdSupported";
    private static final String ATTR_USAGE_THRESHOLD = "UsageThreshold";
    private static final String ATTR_USAGE_THRESHOLD_COUNT = "UsageThresholdCount";
    private static final String ATTR_USAGE_THRESHOLD_EXCEEDED = "UsageThresholdExceeded";
    private static final String ATTR_COMMITTED = "committed";
    private static final String ATTR_INIT = "init";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_USED = "used";
    private static final String[] USAGE_TYPE_ATTRS = new String[]{"committed", "init", "max", "used"};
    private static final CompositeType USAGE_TYPE;
    private final Runtime rt = Runtime.getRuntime();
    private volatile long peekTotalMemory;
    private volatile long peekUsedMemory;

    LibGraalMemoryPoolMBean() {
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_TYPE, String.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_VALID, Boolean.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_USAGE, CompositeData.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_PEAK_USAGE, CompositeData.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_COLLECTION_USAGE, CompositeData.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_COLLECTION_USAGE_THRESHOLD_SUPPORTED, Boolean.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_COLLECTION_USAGE_THRESHOLD, Long.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_COLLECTION_USAGE_THRESHOLD_COUNT, Long.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_COLLECTION_USAGE_THRESHOLD_EXCEEDED, Boolean.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_USAGE_THRESHOLD_SUPPORTED, Boolean.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_USAGE_THRESHOLD, Long.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_USAGE_THRESHOLD_COUNT, Long.class));
        attrs.add(LibGraalMemoryPoolMBean.createAttributeInfo(ATTR_USAGE_THRESHOLD_EXCEEDED, Boolean.class));
        return new MBeanInfo(this.getClass().getName(), "Libgraal Memory Pool", attrs.toArray(new MBeanAttributeInfo[attrs.size()]), new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    private static MBeanAttributeInfo createAttributeInfo(String name, Class<?> type) {
        return new MBeanAttributeInfo(name, type.getName(), name, true, false, false);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        switch (attribute) {
            case "Type": {
                return "NON_HEAP";
            }
            case "Valid": {
                return true;
            }
            case "Usage": {
                return this.getUsage();
            }
            case "PeakUsage": {
                return this.getPeekUsage();
            }
            case "CollectionUsageThresholdSupported": {
                return false;
            }
            case "CollectionUsageThresholdExceeded": {
                return false;
            }
            case "CollectionUsageThresholdCount": {
                return 0L;
            }
            case "CollectionUsageThreshold": {
                return 0L;
            }
            case "CollectionUsage": {
                return null;
            }
            case "UsageThresholdSupported": {
                return false;
            }
            case "UsageThresholdExceeded": {
                return false;
            }
            case "UsageThresholdCount": {
                return 0L;
            }
            case "UsageThreshold": {
                return 0L;
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    void update() {
        this.updateMemStat();
    }

    private CompositeData getUsage() {
        try {
            return new CompositeDataSupport(USAGE_TYPE, USAGE_TYPE_ATTRS, this.updateMemStat());
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private CompositeData getPeekUsage() {
        try {
            Object[] data = this.updateMemStat();
            data[0] = this.peekTotalMemory;
            data[3] = this.peekUsedMemory;
            return new CompositeDataSupport(USAGE_TYPE, USAGE_TYPE_ATTRS, data);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] updateMemStat() {
        long maxMemory = this.rt.maxMemory();
        long totalMemory = this.rt.totalMemory();
        long freeMemory = this.rt.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        this.peekTotalMemory = Math.max(this.peekTotalMemory, totalMemory);
        this.peekUsedMemory = Math.max(this.peekUsedMemory, usedMemory);
        return new Object[]{totalMemory, 0L, maxMemory, usedMemory};
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (String attribute : attributes) {
            try {
                Object value = this.getAttribute(attribute);
                result.add(new Attribute(attribute, value));
            }
            catch (AttributeNotFoundException | MBeanException | ReflectionException jMException) {
                // empty catch block
            }
        }
        return new AttributeList((List<Attribute>)result);
    }

    @Override
    public void setAttribute(Attribute atrbt) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Set attribute is not supported.");
    }

    @Override
    public AttributeList setAttributes(AttributeList al) {
        throw new UnsupportedOperationException("Set attribute is not supported.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Operation invoke is not supported.");
    }

    static {
        try {
            OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
            USAGE_TYPE = new CompositeType(MemoryUsage.class.getName(), "Memory Usage", USAGE_TYPE_ATTRS, USAGE_TYPE_ATTRS, types);
        }
        catch (OpenDataException e) {
            throw new AssertionError("Cannot create memory usage type.", e);
        }
    }
}

