/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class AggregatedMemoryPoolBean
implements MemoryPoolMXBean {
    private static final String[] MEMORY_MANAGER_NAMES = new String[0];
    private final ObjectName objectName;
    private final String name;
    private final MemoryType type;
    private final Map<ObjectName, DynamicMBean> delegates = Collections.synchronizedMap(new HashMap());

    AggregatedMemoryPoolBean(ObjectName aggregateBeanObjectName, DynamicMBean delegate, ObjectName delegateObjectName) {
        this.objectName = aggregateBeanObjectName;
        String typeName = AggregatedMemoryPoolBean.safeReadAttribute(delegate, "Type", String.class);
        this.type = typeName != null ? MemoryType.valueOf(typeName) : MemoryType.NON_HEAP;
        this.name = String.format("Aggregated %s", delegate.getMBeanInfo().getDescription());
        this.delegates.put(delegateObjectName, delegate);
    }

    void addDelegate(DynamicMBean delegate, ObjectName delegateObjectName) {
        this.delegates.put(delegateObjectName, delegate);
    }

    void removeDelegate(ObjectName delegate) {
        this.delegates.remove(delegate);
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public MemoryUsage getUsage() {
        return this.collect("Usage");
    }

    @Override
    public MemoryUsage getPeakUsage() {
        return this.collect("PeakUsage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryUsage collect(String attributeName) {
        long init = 0L;
        long used = 0L;
        long committed = 0L;
        long max = 0L;
        Map<ObjectName, DynamicMBean> map = this.delegates;
        synchronized (map) {
            for (DynamicMBean delegate : this.delegates.values()) {
                CompositeData compositeData = AggregatedMemoryPoolBean.safeReadAttribute(delegate, attributeName, CompositeData.class);
                if (compositeData == null) continue;
                MemoryUsage isolateMemoryUsage = MemoryUsage.from(compositeData);
                init += isolateMemoryUsage.getInit();
                used += isolateMemoryUsage.getUsed();
                committed += isolateMemoryUsage.getCommitted();
                max += isolateMemoryUsage.getMax();
            }
        }
        return new MemoryUsage(init, used, committed, max);
    }

    static <T> T safeReadAttribute(DynamicMBean mbean, String name, Class<T> attrType) {
        try {
            return attrType.cast(mbean.getAttribute(name));
        }
        catch (AttributeNotFoundException | MBeanException | ReflectionException e) {
            return null;
        }
    }

    @Override
    public String[] getMemoryManagerNames() {
        return MEMORY_MANAGER_NAMES;
    }

    @Override
    public void resetPeakUsage() {
    }

    @Override
    public MemoryUsage getCollectionUsage() {
        return null;
    }

    @Override
    public boolean isUsageThresholdSupported() {
        return false;
    }

    @Override
    public boolean isUsageThresholdExceeded() {
        throw new UnsupportedOperationException("UsageThreshold is not supported.");
    }

    @Override
    public long getUsageThresholdCount() {
        throw new UnsupportedOperationException("UsageThreshold is not supported.");
    }

    @Override
    public long getUsageThreshold() {
        throw new UnsupportedOperationException("UsageThreshold is not supported.");
    }

    @Override
    public void setUsageThreshold(long threshold) {
        throw new UnsupportedOperationException("UsageThreshold is not supported.");
    }

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return false;
    }

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        throw new UnsupportedOperationException("CollectionUsageThreshold is not supported.");
    }

    @Override
    public long getCollectionUsageThresholdCount() {
        throw new UnsupportedOperationException("CollectionUsageThreshold is not supported.");
    }

    @Override
    public long getCollectionUsageThreshold() {
        throw new UnsupportedOperationException("CollectionUsageThreshold is not supported.");
    }

    @Override
    public void setCollectionUsageThreshold(long threshold) {
        throw new UnsupportedOperationException("CollectionUsageThreshold is not supported.");
    }
}

