/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class ArrayType
extends AggregateType {
    private Type elementType;
    private final long length;

    public ArrayType(Type type, long length) {
        this.elementType = type;
        this.length = length;
    }

    public void setElementType(Type elementType) {
        CompilerAsserts.neverPartOfCompilation();
        this.verifyCycleFree(elementType);
        this.elementType = elementType;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public long getBitSize() throws Type.TypeOverflowException {
        return ArrayType.multiplyUnsignedExact(this.getElementType().getBitSize(), this.getNumberOfElements());
    }

    public Type getElementType() {
        CompilerAsserts.neverPartOfCompilation();
        return this.elementType;
    }

    @Override
    public long getNumberOfElements() {
        return this.length;
    }

    @Override
    public Type getElementType(long index) {
        return this.getElementType();
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return this.getElementType().getAlignment(targetDataLayout);
    }

    @Override
    public long getSize(DataLayout targetDataLayout) throws Type.TypeOverflowException {
        return ArrayType.multiplyUnsignedExact(this.getElementType().getSize(targetDataLayout), this.length);
    }

    @Override
    public long getOffsetOf(long index, DataLayout targetDataLayout) throws Type.TypeOverflowException {
        return ArrayType.multiplySignedExact(this.getElementType().getSize(targetDataLayout), index);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("[%s x %s]", Long.toUnsignedString(this.getNumberOfElements()), this.getElementType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getElementType() == null ? 0 : this.getElementType().hashCode());
        result = 31 * result + (int)this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        if (this.getElementType() == null ? other.getElementType() != null : !this.getElementType().equals(other.getElementType())) {
            return false;
        }
        return this.length == other.length;
    }
}

