/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.ManagedPointerLibrariesFactory;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ManagedPointerLibraries.class)
final class ManagedPointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private ManagedPointerLibrariesGen() {
    }

    static {
        LibraryExport.register(ManagedPointerLibraries.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports(), new InteropLibraryExports(), new LLVMAsForeignLibraryExports(), new ReferenceLibraryExports()});
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class ReferenceLibraryExports
    extends LibraryExport<ReferenceLibrary> {
        private ReferenceLibraryExports() {
            super(ReferenceLibrary.class, LLVMPointerImpl.class, false);
        }

        protected ReferenceLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ReferenceLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private LLVMAddressEqualsNode native_equals_;

            Cached(Object originalReceiver) {
                LLVMPointerImpl receiver = (LLVMPointerImpl)originalReceiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                    }
                    if ((state & 2) != 0 && Cached.fallbackGuard_(state, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.native_equals_ = (LLVMAddressEqualsNode)super.insert((Node)LLVMAddressEqualsNode.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                        return bl;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            private static boolean fallbackGuard_(int state, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state & 1) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }
        }
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object asForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached());
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @Node.Child
            private LLVMAsForeignLibrary isForeignNode__foreigns_;
            @Node.Child
            private LLVMAsForeignLibrary asForeignNode__foreigns_;

            Cached(Object originalReceiver) {
                LLVMPointerImpl receiver = (LLVMPointerImpl)originalReceiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            @Override
            public boolean isForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return ManagedPointerLibraries.isForeign(arg0Value, this.isForeignNode__foreigns_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isForeignNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isForeignNode_AndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.isForeignNode__foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = ManagedPointerLibraries.isForeign(arg0Value, this.isForeignNode__foreigns_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object asForeign(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    return ManagedPointerLibraries.asForeign(arg0Value, this.asForeignNode__foreigns_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asForeignNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object asForeignNode_AndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.asForeignNode__foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = ManagedPointerLibraries.asForeign(arg0Value, this.asForeignNode__foreigns_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (!((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object)).isForeign(arg0Value.object)) {
                    return ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object));
                }
                if (((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object)).isForeign(arg0Value.object)) {
                    return ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value.object), ManagedPointerLibrariesFactory.ForeignIdentityHashNodeGen.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isExecutable(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.execute(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                ManagedPointerLibraries.toNative(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.object));
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private LLVMAsForeignLibrary receiverObjectLLVMAsForeignLibrary_;
            @Node.Child
            private InteropLibrary receiverObjectInteropLibrary_;
            @Node.Child
            private LLVMNativeLibrary receiverObjectLLVMNativeLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @Node.Child
            private LLVMAddressEqualsNode isIdenticalOrUndefined_pointer_equals_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__write_;
            @Node.Child
            private ManagedPointerLibraries.ForeignIdentityHashNode identityHashCode_foreign_hashForeign_;

            Cached(Object originalReceiver) {
                LLVMPointerImpl receiver = (LLVMPointerImpl)originalReceiver;
                this.receiverObjectLLVMAsForeignLibrary_ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create(receiver.object));
                this.receiverObjectInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver.object));
                this.receiverObjectLLVMNativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.create(receiver.object));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)receiver));
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != ManagedPointerLibraries.class) {
                    return false;
                }
                if (!this.receiverObjectLLVMAsForeignLibrary_.accepts(((LLVMPointerImpl)receiver).object)) {
                    return false;
                }
                if (!this.receiverObjectInteropLibrary_.accepts(((LLVMPointerImpl)receiver).object)) {
                    return false;
                }
                return this.receiverObjectLLVMNativeLibrary_.accepts(((LLVMPointerImpl)receiver).object);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                    }
                    if ((state & 2) != 0 && Cached.isIdenticalOrUndefinedFallbackGuard_(state, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.isIdenticalOrUndefined_pointer_equals_ = (LLVMAddressEqualsNode)super.insert((Node)LLVMAddressEqualsNode.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                        return triState;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 4) != 0) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 8) != 0) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.readMemberNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver), member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.writeMemberNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    return CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    long l = CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x100) != 0) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x200) != 0) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.readArrayElementNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x400) != 0) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver), index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x800) != 0) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.writeArrayElementNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver), allowSideEffects);
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public int identityHashCode(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x3000) != 0) {
                    LLVMAsForeignLibrary identityHashCode_foreign_foreigns__;
                    LLVMAsForeignLibrary identityHashCode_internal_foreigns__;
                    if ((state & 0x1000) != 0 && !(identityHashCode_internal_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_).isForeign(arg0Value.object)) {
                        return ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, identityHashCode_internal_foreigns__);
                    }
                    if ((state & 0x2000) != 0 && (identityHashCode_foreign_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_).isForeign(arg0Value.object)) {
                        return ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, identityHashCode_foreign_foreigns__, this.identityHashCode_foreign_hashForeign_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.identityHashCodeAndSpecialize(arg0Value);
            }

            private int identityHashCodeAndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMAsForeignLibrary identityHashCode_internal_foreigns__ = null;
                    identityHashCode_internal_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                    if (!identityHashCode_internal_foreigns__.isForeign(arg0Value.object)) {
                        this.state_ = state |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        int n = ManagedPointerLibraries.IdentityHashCode.doInternal(arg0Value, identityHashCode_internal_foreigns__);
                        return n;
                    }
                    LLVMAsForeignLibrary identityHashCode_foreign_foreigns__ = null;
                    identityHashCode_foreign_foreigns__ = this.receiverObjectLLVMAsForeignLibrary_;
                    if (identityHashCode_foreign_foreigns__.isForeign(arg0Value.object)) {
                        this.identityHashCode_foreign_hashForeign_ = (ManagedPointerLibraries.ForeignIdentityHashNode)super.insert((Node)ManagedPointerLibrariesFactory.ForeignIdentityHashNodeGen.create());
                        this.state_ = state |= 0x2000;
                        lock.unlock();
                        hasLock = false;
                        int n = ManagedPointerLibraries.IdentityHashCode.doForeign(arg0Value, identityHashCode_foreign_foreigns__, this.identityHashCode_foreign_hashForeign_);
                        return n;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isNull(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                InteropLibrary isNullNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.isNull(arg0Value, isNullNode__interop__);
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                InteropLibrary isExecutableNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.isExecutable(arg0Value, isExecutableNode__interop__);
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                InteropLibrary executeNode__interop__ = this.receiverObjectInteropLibrary_;
                return ManagedPointerLibraries.execute(arg0Value, arg1Value, executeNode__interop__);
            }

            public boolean isPointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                LLVMNativeLibrary isPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.isPointer(arg0Value, isPointerNode__natives__);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                LLVMNativeLibrary asPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.asPointer(arg0Value, asPointerNode__natives__);
            }

            public void toNative(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                InteropLibrary toNativeNode__interop__ = this.receiverObjectInteropLibrary_;
                ManagedPointerLibraries.toNative(arg0Value, toNativeNode__interop__);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state & 1) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }
        }
    }

    @GeneratedBy(value=ManagedPointerLibraries.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == ManagedPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.isPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.asPointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return ManagedPointerLibraries.toNativePointer(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value.object));
            }
        }

        @GeneratedBy(value=ManagedPointerLibraries.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private LLVMNativeLibrary receiverObjectLLVMNativeLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Cached(Object originalReceiver) {
                LLVMPointerImpl receiver = (LLVMPointerImpl)originalReceiver;
                this.receiverObjectLLVMNativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.create(receiver.object));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create((Object)receiver));
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != ManagedPointerLibraries.class) {
                    return false;
                }
                return this.receiverObjectLLVMNativeLibrary_.accepts(((LLVMPointerImpl)receiver).object);
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                LLVMNativeLibrary isPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.isPointer(arg0Value, isPointerNode__natives__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                LLVMNativeLibrary asPointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.asPointer(arg0Value, asPointerNode__natives__);
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value_) {
                assert (this.dynamicDispatch_.accepts(arg0Value_) && this.dynamicDispatch_.dispatch(arg0Value_) == ManagedPointerLibraries.class) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                LLVMNativeLibrary toNativePointerNode__natives__ = this.receiverObjectLLVMNativeLibrary_;
                return ManagedPointerLibraries.toNativePointer(arg0Value, toNativePointerNode__natives__);
            }
        }
    }
}

