/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMNativeLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMAsForeignLibrary.class, receiverType=LLVMPointerImpl.class)})
abstract class ManagedPointerLibraries
extends CommonPointerLibraries {
    ManagedPointerLibraries() {
    }

    @ExportMessage
    static boolean isNull(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isNull(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static boolean isExecutable(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isExecutable(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static Object execute(LLVMPointerImpl receiver, Object[] args, @CachedLibrary(value="receiver.object") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        if (receiver.getOffset() == 0L) {
            return interop.execute(receiver.object, args);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(library=LLVMNativeLibrary.class), @ExportMessage(library=InteropLibrary.class)})
    static boolean isPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) {
        return natives.isPointer(receiver.object);
    }

    @ExportMessage.Repeat(value={@ExportMessage(library=LLVMNativeLibrary.class), @ExportMessage(library=InteropLibrary.class)})
    static long asPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) throws UnsupportedMessageException {
        return natives.asPointer(receiver.object) + receiver.getOffset();
    }

    @ExportMessage
    static void toNative(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        interop.toNative(receiver.object);
    }

    @ExportMessage
    static LLVMNativePointer toNativePointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) {
        return natives.toNativePointer(receiver.object).increment(receiver.getOffset());
    }

    @ExportMessage
    static boolean isForeign(LLVMPointerImpl receiver, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return ManagedPointerLibraries.isForeignTest(receiver, foreigns);
    }

    @ExportMessage
    static Object asForeign(LLVMPointerImpl receiver, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return foreigns.asForeign(receiver.object);
    }

    static boolean isForeignTest(LLVMPointerImpl receiver, LLVMAsForeignLibrary foreigns) {
        return receiver.getOffset() == 0L && foreigns.isForeign(receiver.object);
    }

    @GenerateUncached
    static abstract class ForeignIdentityHashNode
    extends LLVMNode {
        ForeignIdentityHashNode() {
        }

        abstract int execute(Object var1);

        @Specialization(limit="3", rewriteOn={UnsupportedMessageException.class})
        int doUnchecked(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.identityHashCode(obj);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(limit="3", guards={"!interop.hasIdentity(obj)"}, replaces={"doUnchecked"})
        int doNoIdentity(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return System.identityHashCode(obj);
        }

        @Specialization(limit="3", replaces={"doNoIdentity"})
        int doChecked(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            try {
                return interop.identityHashCode(obj);
            }
            catch (UnsupportedMessageException ex) {
                return this.doNoIdentity(obj, interop);
            }
        }
    }

    @ExportMessage
    static class IdentityHashCode {
        IdentityHashCode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!foreigns.isForeign(receiver.object)"})
        static int doInternal(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns) {
            return IdentityHashCode.hash(System.identityHashCode(receiver.getObject()), receiver.getOffset());
        }

        @Specialization(guards={"foreigns.isForeign(receiver.object)"})
        static int doForeign(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMAsForeignLibrary foreigns, @Cached ForeignIdentityHashNode hashForeign) {
            Object foreign = foreigns.asForeign(receiver.getObject());
            return IdentityHashCode.hash(hashForeign.execute(foreign), receiver.getOffset());
        }

        private static int hash(int objHash, long offset) {
            int ret = 0;
            ret = ret * 31 + objHash;
            ret = ret * 31 + Long.hashCode(offset);
            return ret;
        }
    }
}

